/* parsecc.c Version 0.4.0. Parse Eccentric Strlen Output */
/* Copyright (C) 2004-2010  dondalah721@yahoo.com (Dondalah) */

/* Xdome is free software; you can redistribute it and/or */
/* modify it under the terms of the GNU General Public License */
/* as published by the Free Software Foundation; either version 2 */
/* of the License, or (at your option) any later version. */

/* Xdome is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the */
/* GNU General Public License for more details. */

/* You should have received a copy of the GNU General Public License */
/* along with this program; if not, write to: */

/*       Free Software Foundation, Inc. */
/*       51 Franklin St, Fifth Floor    */
/*       Boston, MA  02110-1301, USA   */

#include "verify.h"

void parsecc(xwfmt *xw)
   {
   int eofsw;
   int len;
   char ln[128];
   len = getln(&eofsw, ln);
   if (eofsw)
      {
      fprintf(stderr,"parsecc: end of "
         "file on first line\n");
      eccfree(xw);
      exit(1);
      } /* eof */
   if (len < 40)
      {
      fprintf(stderr,"<<%s>>\n", ln);
      fprintf(stderr,"parsecc: "
         "invalid first line\n");
      eccfree(xw);
      exit(1);
      } /* invalid first line */
   else getspec(xw, len, ln);
   len = getln(&eofsw, ln);
   if (eofsw)
      {
      fprintf(stderr,"parsecc: end of "
         "file on second line\n");
      eccfree(xw);
      exit(1);
      } /* eof */
   if (len < 9)
      {
      fprintf(stderr,"<<%s>>\n", ln);
      fprintf(stderr,"parsecc: "
         "invalid second line\n");
      eccfree(xw);
      exit(1);
      } /* invalid second line */
   else getpolar(xw, len, ln);
   if (xw->ecc == 1.0)
      {
      fprintf(stderr,"parsecc: "
         "dome is not eccentric -- run spin\n");
      eccfree(xw);
      exit(1);
      } /* not eccentric */
   while (!eofsw)
      {
      len = getln(&eofsw, ln);
      if (len < 50 && !eofsw);
      else if (len >= 50)
	 getecc(xw, len, ln);
      } /* read to eof */
   }  /* parsecc */
