/*
initx.c Version 0.4.0.  Initialize X Windows Session 
Copyright (C) 2004-2010 dondalah721@yahoo.com (Dondalah)

Xdome is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

Xdome is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to:

	Free Software Foundation, Inc.
	51 Franklin St, Fifth Floor
	Boston, MA  02110-1301, USA
*/

/* This X Windows code is based on: */
/* http://tronche.lri.fr:8000/gui/x/xlib-tutorial/2nd-program-anatomy.html */

#include "verify.h"

void initx(xwfmt *xw,
   char *pgm)
   {
   int rslt;
   char title[64];

   xw->dpy = XOpenDisplay(NIL);

   if (xw->dpy == NULL)
      {
      fprintf(stderr,"X Windows failure\n");
      exit(1);
      } /* if X Windows is not active */

   assert(xw->dpy);

   xw->rootww  = XDisplayWidth(xw->dpy,0);
   xw->rootwh  = XDisplayHeight(xw->dpy,0);
   xw->dpywdth = xw->rootww -  80;
   xw->dpyhght = xw->rootwh - 100;
   xw->imgsz   = (double) xw->dpyhght - 20.0;
   xw->radius  = (xw->imgsz - 40) * 0.5;

   if (xw->rootww < 700)
      xw->lftmarg = 10.0;
   else
      xw->lftmarg = 20.0;

   xw->font = (char *) malloc(64);
   if (xw->font == NULL)
      {
      fprintf(stderr,"Verify:  out of memory "
         "allocating font name\n");
      exit(1);
      } /* out of mem */


   if (xw->rootww < 700)
      strcpy(xw->font,"7x13");
   else if (xw->rootww < 900)
      strcpy(xw->font,"8x16");
   else
      strcpy(xw->font,"10x20");

   xw->whiteColor = WhitePixel(xw->dpy, DefaultScreen(xw->dpy));
   xw->blackColor = BlackPixel(xw->dpy, DefaultScreen(xw->dpy));

   xw->w = XCreateSimpleWindow(xw->dpy,
      DefaultRootWindow(xw->dpy),
      0, 0, 
      xw->dpywdth, xw->dpyhght,
      0, xw->whiteColor,
      xw->whiteColor);

   XSelectInput(xw->dpy, xw->w, StructureNotifyMask);

   XMapWindow(xw->dpy, xw->w);

   xw->gc = XCreateGC(xw->dpy, xw->w, 0, NIL);

   xw->fontid = (Font) XLoadFont(xw->dpy,xw->font);

   XSetFont(xw->dpy,xw->gc,xw->fontid);

   XSetForeground(xw->dpy, xw->gc, xw->blackColor);

   xw->dfltscr = XDefaultScreenOfDisplay(xw->dpy);
   if (xw->dfltscr == NULL)
      {
      fprintf(stderr,"XDefaultScreenOfDisplay failed\n");
      perror("XDefaultScreenOfDisplay failed");
      exit(1);
      } /* if error */

   xw->cmap = XDefaultColormapOfScreen(xw->dfltscr);

   rslt = XAllocNamedColor(xw->dpy,xw->cmap,"red",
      &xw->scrdef,&xw->exctdef);

   if (rslt < 0)
      {
      fprintf(stderr,"XAllocNamedColor failed\n");
      perror("XAllocNamedColor failed");
      exit(1);
      } /* if error */
   xw->red = xw->scrdef.pixel;

   rslt = XAllocNamedColor(xw->dpy,xw->cmap,"blue",
      &xw->scrdef,&xw->exctdef);

   if (rslt < 0)
      {
      fprintf(stderr,"XAllocNamedColor failed\n");
      perror("XAllocNamedColor failed");
      exit(1);
      } /* if error */
   xw->blue = xw->scrdef.pixel;

   XSetWindowBorderWidth(xw->dpy, xw->w, 40);

   strcpy(title,pgm);
   XStoreName(xw->dpy,xw->w,title);
   XSetIconName(xw->dpy,xw->w,title);

#ifdef UPPERLEFT

   XMoveWindow(xw->dpy,xw->w,0,0);

#endif

   while(1)
      {
      XEvent e;
      XNextEvent(xw->dpy, &e);
      if (e.type == MapNotify) break;
      } /* wait for window initialization */

   } /* initx */
