/* getpolar.c Version 0.4.0. Parse Second Line */
/* Copyright (C) 2004-2010  dondalah721@yahoo.com (Dondalah) */

/* Xdome is free software; you can redistribute it and/or */
/* modify it under the terms of the GNU General Public License */
/* as published by the Free Software Foundation; either version 2 */
/* of the License, or (at your option) any later version. */

/* Xdome is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the */
/* GNU General Public License for more details. */

/* You should have received a copy of the GNU General Public License */
/* along with this program; if not, write to: */

/*       Free Software Foundation, Inc. */
/*       51 Franklin St, Fifth Floor    */
/*       Boston, MA  02110-1301, USA   */

#include "verify.h"

void getpolar(xwfmt *xw, int lnlen, char *ln)
   {
   int rslt;
   int rslt1;
   int rslt2;
   int rslt3;
   int rslt4;
   double eccval;
   char *p,*q,*r;
   char str[128];
   xw->bball = 0;
   xw->ecc   = 1.0;
   p = (char *) ln;
   q = (char *) ln + lnlen;
   r = (char *) str;
   while (p < q)
      {
      if (*p == ' ')
	 {
	 p++;
         break;
	 } /* if delimiter */
      *r++ = *p++;
      } /* first token */
   *r = '\0';
   rslt1 = strcmp(str,"Polar");
   if (!rslt1) return;
   rslt2 = strcmp(str,"Eccentricity");
   rslt3 = strcmp(str,"Buckyball");
   if (!rslt3)
      {
      xw->bball = 1;
      return;
      } /* if buckyball */
   rslt4 = strcmp(str,"From");
   if (!rslt4) return;
   if (rslt1 && rslt2 && rslt3 && rslt4)
      {
      fprintf(stderr,"%s\n", str);
      fprintf(stderr,"getpolar: Invalid line\n");
      exit(1);
      } /* if eol */
   r = (char *) str;
   while (p < q)
      {
      if (*p == ' ')
	 {
	 p++;
         break;
	 } /* if delimiter */
      *r++ = *p++;
      } /* Eccentricity value */
   *r = '\0';
   eccval = (double) atof(str);
   if (eccval < 0.5 || eccval > 2.0)
      {
      fprintf(stderr,"%s\n", str);
      fprintf(stderr,"getpolar: invalid "
         "eccentricity %f\n",
	 eccval);
      exit(1);
      } /* invalid */
   xw->ecc = eccval;
   if (p >= q) return;
   while (p < q)
      {
      if (*p != ' ') break;
      p++;
      } /* bypass delimiter */
   r = (char *) str;
   while (p < q)
      {
      if (*p == ' ')
	 {
         fprintf(stderr,"%s\n", str);
         fprintf(stderr,"getpolar: invalid "
	    "delimiter after "
	    "buckyball token\n");
         exit(1);
	 } /* if delimiter after buckyball */
      *r++ = *p++;
      } /* buckyball token */
   *r = '\0';
   rslt = strcmp(str,"Buckyball");
   if (rslt)
      {
      fprintf(stderr,"%s\n", str);
      fprintf(stderr,"getpolar: invalid "
	 "buckyball token\n");
      exit(1);
      } /* if eol */
   xw->bball = 1;
   }  /* getpolar */
