/* getphi.c Version 0.4.0. Parse From and To Lines */
/* Copyright (C) 2004-2010  dondalah721@yahoo.com (Dondalah) */

/* Xdome is free software; you can redistribute it and/or */
/* modify it under the terms of the GNU General Public License */
/* as published by the Free Software Foundation; either version 2 */
/* of the License, or (at your option) any later version. */

/* Xdome is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the */
/* GNU General Public License for more details. */

/* You should have received a copy of the GNU General Public License */
/* along with this program; if not, write to: */

/*       Free Software Foundation, Inc. */
/*       51 Franklin St, Fifth Floor    */
/*       Boston, MA  02110-1301, USA   */

#include "verify.h"

#define FROM 0
#define TO   1

void getphi(xwfmt *xw,
   int lnlen,
   char *ln)
   {
   int i;
   int rslt1;
   int rslt2;
   int fromto;
   double *phifromptr;
   double *thetafromptr;
   double *phitoptr;
   double *thetatoptr;
   double phival;
   double thetaval;
   char *p,*q,*r;
   char str[128];
   p = (char *) ln;
   q = (char *) ln + lnlen;
   r = (char *) str;
   while (p < q)
      {
      if (*p == ' ')
	 {
	 p++;
         break;
	 } /* if delimiter */
      *r++ = *p++;
      } /* from/to */
   *r = '\0';
   if (p >= q)
      {
      fprintf(stderr,"%s\n", str);
      fprintf(stderr,"getphi: end of line "
         "reading from and to\n");
      vfyfree(xw);
      exit(1);
      } /* if eol */
   rslt1 = strcmp(str,"From");
   rslt2 = strcmp(str,"To");
   /* only accept from and to lines */
   if (rslt1 && rslt2) return;
   fromto = -999;
   if (!rslt1) fromto = FROM;
   else if (!rslt2) fromto = TO;
   while (p < q)
      {
      if (*p != ' ') break;
      p++;
      } /* bypass from/to delimiter */
   /* after from/to & node, */
   /* bypass the following tokens */
   /* 1 = node */
   /* 2 = 'xyz' */
   /* 3 = x */
   /* 4 = y */
   /* 5 = z */
   /* 6 = 'phi' */
   /* 7 = 'theta' */
   i = 7;
   while (i--)
      {
      while (p < q)
         {
         if (*p == ' ') break;
	 p++;
         } /* token */
      if (p >= q)
         {
         fprintf(stderr,"%s\n", str);
         fprintf(stderr,"getphi: end of line "
            "reading token to "
	    "left of phi & theta\n");
         vfyfree(xw);
         exit(1);
         } /* if eol */
      while (p < q)
         {
         if (*p != ' ') break;
	 p++;
         } /* token delimiter */
      if (p >= q)
         {
         fprintf(stderr,"%s\n", str);
         fprintf(stderr,"getphi: end of line "
            "reading token delimiter to "
	    "left of phi & theta\n");
         vfyfree(xw);
         exit(1);
         } /* if eol */
      } /* for each token & delimiter to bypass */
   /* read phi value in degrees */
   r = (char *) str;
   while (p < q)
      {
      if (*p == ' ') break;
      *r++ = *p++;
      } /* phi value in degrees */
   *r = '\0';
   if (p >= q)
      {
      fprintf(stderr,"%s\n", str);
      fprintf(stderr,"getphi: end of line "
         "reading phi value\n");
      vfyfree(xw);
      exit(1);
      } /* if eol */
   phival = atof(str);
   if (phival < 0.0 || phival > 360.0)
      {
      fprintf(stderr,"%s\n", ln);
      fprintf(stderr,"%s\n", str);
      fprintf(stderr,"getphi: invalid "
	 "phi value %f\n", phival);
      vfyfree(xw);
      exit(1);
      } /* if invalid */
   while (p < q)
      {
      if (*p != ' ') break;
      p++;
      } /* token delimiter */
   if (p >= q)
      {
      fprintf(stderr,"%s\n", str);
      fprintf(stderr,"getphi: end of line "
         "reading token delimiter "
         "after phi value\n");
      vfyfree(xw);
      exit(1);
      } /* if eol */
   /* read theta value in degrees */
   r = (char *) str;
   while (p < q)
      {
      if (*p == ' ') break;
      *r++ = *p++;
      } /* theta value in degrees */
   *r = '\0';
   thetaval = atof(str);
   if (thetaval < 0.0 || thetaval > 180.0)
      {
      fprintf(stderr,"%s\n", ln);
      fprintf(stderr,"%s\n", str);
      fprintf(stderr,"getphi: invalid "
	 "theta value %f\n", thetaval);
      vfyfree(xw);
      exit(1);
      } /* if invalid */
   if (fromto == FROM)
      {
      phifromptr    = (double *) xw->phifrom   + xw->totstr;
      *phifromptr   = phival;
      thetafromptr  = (double *) xw->thetafrom + xw->totstr;
      *thetafromptr = thetaval;
      } /* if from */
   else
      {
      phitoptr      = (double *) xw->phito     + xw->totstr;
      *phitoptr     = phival;
      thetatoptr    = (double *) xw->thetato   + xw->totstr;
      *thetatoptr   = thetaval;
      xw->totstr++;
      } /* if to */
   }  /* getphi */
