/* getln.c Version 0.4.0. Read 1 line from stdin */
/* Copyright (C) 2004-2010  dondalah721@yahoo.com (Dondalah) */

/* Xdome is free software; you can redistribute it and/or */
/* modify it under the terms of the GNU General Public License */
/* as published by the Free Software Foundation; either version 2 */
/* of the License, or (at your option) any later version. */

/* Xdome is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the */
/* GNU General Public License for more details. */

/* You should have received a copy of the GNU General Public License */
/* along with this program; if not, write to: */

/*       Free Software Foundation, Inc. */
/*       51 Franklin St, Fifth Floor    */
/*       Boston, MA  02110-1301, USA   */

#include <stdio.h>
#include <stdlib.h>

#define MAXLEN 96

int getln(int *eofsw, char *ln)
   {
   int ch;
   int totlen;
   int getbyte(void);
   char *p,*q;
   totlen = 0;
   *eofsw = 0;
   p = (char *) ln;
   q = (char *) ln + MAXLEN;
   while (p < q)
      {
      ch = getbyte();
      if (ch == EOF)
	 {
	 *p = '\0';
	 *eofsw = 1;
	 break;
	 } /* if eof */
      if (ch == '\n')
	 {
	 *p = '\0';
         break;
	 } /* if eol */
      *p++ = (char) ch;
      } /* for each char in line */
   if (p >= q)
      {
      q--;
      *q = '\0';
      fprintf(stderr,"%s\n", ln);
      fprintf(stderr,"getln: line overflow\n");
      exit(1);
      } /* if overflow */
   q = (char *) ln;
   totlen = (int) p - (int) q;
   return(totlen);
   }  /* getln */
