/*
getkey.c Version 0.4.0. Wait for keyboard input and read key
Copyright (C) 2004-2010 dondalah721@yahoo.com (Dondalah)

Xdome is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

Xdome is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to:

	Free Software Foundation, Inc.
	51 Franklin St, Fifth Floor
	Boston, MA  02110-1301, USA
*/

#include "verify.h"

void getkey(xw)
xwfmt *xw;
   {
   /* After each drawn image, */
   /* wait for command or exposure. */

   XSelectInput(xw->dpy, xw->w,
      KeyPressMask|ExposureMask
      |ButtonPressMask|KeyReleaseMask);

   while(1)
      {
      int symbol;
      XEvent e;
      XKeyEvent *k;
      XNextEvent(xw->dpy, &e);
      if (e.type == KeyPress)
         {
         k = (XKeyEvent *) &e;
         symbol = XLookupKeysym(k,0);
         if (symbol == XK_Escape || symbol == XK_q)
            {
            xw->runflg = 0;
            break;
            } /* if quit */
         else if (symbol == XK_Return)
            {
            break;
            } /* if draw image */
         else if (symbol == XK_Right)
            {
	    /* horizontal right rotation */
	    xw->hrot += 1.0;
	    if (xw->hrot >= 360.0)
	       xw->hrot -= 360.0;
            break;
            } /* if rotate right */
         else if (symbol == XK_Left)
            {
	    /* horizontal left rotation */
	    xw->hrot -= 1.0;
	    if (xw->hrot < 0.0)
	       xw->hrot += 360.0;
            break;
            } /* if rotate left */
         else if (symbol == XK_Up)
            {
	    /* vertical up rotation */
	    xw->vrot -= 1.0;
	    if (xw->vrot < 0.0)
	       xw->vrot += 360.0;
            break;
            } /* if rotate up */
         else if (symbol == XK_Down)
            {
	    /* vertical down rotation */
	    xw->vrot += 1.0;
	    if (xw->vrot >= 360.0)
	       xw->vrot -= 360.0;
            break;
            } /* if rotate down */
         else if (symbol == XK_Insert)
            {
	    xw->view = FRONT;
            break;
            } /* if front view */
         else if (symbol == XK_Delete)
            {
	    xw->view = TOP;
            break;
            } /* if top view */
         else if (symbol == XK_F1)
            {
	    xw->spin -= 1.0;
	    if (xw->spin < 0.0)
	       xw->spin += 360.0;
            break;
            } /* if spin left */
         else if (symbol == XK_F2)
            {
	    xw->spin += 1.0;
	    if (xw->spin >= 360.0)
	       xw->spin -= 360.0;
            break;
            } /* if spin right */
         else if (symbol == XK_F3)
            {
	    xw->spin = xw->hrot = xw->vrot = 0.0;
            break;
            } /* if reset rotation */
	 else if (symbol == XK_Shift_L
            || symbol == XK_Shift_R)
            {
            xw->shift = 1;
            /* don't break yet */
            /* wait for next key */
            } /* if shift key pressed */
         } /* if keypress event */
      if (e.type == KeyRelease)
         {
         k = (XKeyEvent *) &e;
         symbol = XLookupKeysym(k,0);
	 if (symbol == XK_Shift_L
	    || symbol == XK_Shift_R)
	    xw->shift = 0;
         } /* if key release event */
      if (e.type == ButtonPress)
         {
	 xw->runflg = 0;
	 break;
         } /* if button press event */
      else if (e.type == Expose)
         {
         break;
         } /* if expose event */
      } /* wait for window shutdown */
   } /* getkey */
