/*
drawspin.c Version 0.4.0. Draw one chord on screen
verify program version
Copyright (C) 2004-2010 dondalah721@yahoo.com (Dondalah)

Xdome is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

Xdome is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to:

	Free Software Foundation, Inc.
	51 Franklin St, Fifth Floor
	Boston, MA  02110-1301, USA
*/

#include "verify.h"

void drawspin(xwfmt *xw,
   double exx1, double wyy1, double zee1,
   double exx2, double wyy2, double zee2)
   {
   int x1,y1,z1;
   int x2,y2,z2;
   if (xw->view != TOP)
      {
      y1 = (int) (((wyy1 * xw->radius) + xw->lftmarg + xw->radius) + 0.5); 
      z1 = (int) ((xw->imgsz - ((zee1 * xw->radius) + xw->radius)) + 0.5);
      y2 = (int) (((wyy2 * xw->radius) + xw->lftmarg + xw->radius) + 0.5);
      z2 = (int) ((xw->imgsz - ((zee2 * xw->radius) + xw->radius)) + 0.5);
      XDrawLine(xw->dpy,xw->w,xw->gc,y1,z1,y2,z2);
      } /* if front or side view */
   else if (xw->view == TOP)
      {
      y1 = (int) (((wyy1 * xw->radius) + xw->lftmarg + xw->radius) + 0.5); 
      x1 = (int) ((xw->imgsz - ((exx1 * xw->radius) + xw->radius)) + 0.5);
      y2 = (int) (((wyy2 * xw->radius) + xw->lftmarg + xw->radius) + 0.5);
      x2 = (int) ((xw->imgsz - ((exx2 * xw->radius) + xw->radius)) + 0.5);
      XDrawLine(xw->dpy,xw->w,xw->gc,y1,x1,y2,x2);
      } /* else top view */
   } /* drawspin */
