/* bldspin.c Version 0.4.0. build dome on screen */
/* Copyright (C) 2004-2010  dondalah721@yahoo.com (Dondalah) */

/* Xdome is free software; you can redistribute it and/or */
/* modify it under the terms of the GNU General Public License */
/* as published by the Free Software Foundation; either version 2 */
/* of the License, or (at your option) any later version. */

/* Xdome is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the */
/* GNU General Public License for more details. */

/* You should have received a copy of the GNU General Public License */
/* along with this program; if not, write to: */

/*       Free Software Foundation, Inc. */
/*       51 Franklin St, Fifth Floor    */
/*       Boston, MA  02110-1301, USA   */

#include "verify.h"

void bldspin(xwfmt *xw)
   {
   int i;
   double *phifromptr;
   double *thetafromptr;
   double *phitoptr;
   double *thetatoptr;
   double phi1,phi2;
   double theta1,theta2;
   double epsilon;
   double spinphi1,spinphi2;
   double spinexx1,spinwyy1,spinzee1;
   double spinexx2,spinwyy2,spinzee2;
   double vexx1,vwyy1,vzee1;
   double vexx2,vwyy2,vzee2;
   double hexx1,hwyy1,hzee1;
   double hexx2,hwyy2,hzee2;

   while (xw->runflg)
      {
      XClearWindow(xw->dpy,xw->w);
      /* Don't allow top view */
      xw->view = FRONT;
      spinmenu(xw);
      phifromptr   = (double *) xw->phifrom;
      thetafromptr = (double *) xw->thetafrom;
      phitoptr     = (double *) xw->phito;
      thetatoptr   = (double *) xw->thetato;
      i = xw->totstr;
      while (i--)
         {
	 phi1   = *phifromptr++;
	 theta1 = *thetafromptr++;
	 phi2   = *phitoptr++;
	 theta2 = *thetatoptr++;
	 spinphi1 = phi1 + xw->spin;
	 if (spinphi1 >= 360.0)
	    spinphi1 -= 360.0;
	 spinphi2 = phi2 + xw->spin;
	 if (spinphi2 >= 360.0)
	    spinphi2 -= 360.0;
	 if (xw->ecc == 1.0)
	    {
	    spinexx1 = sin(theta1 * xw->d2r)
	       * cos(spinphi1 * xw->d2r);
	    spinwyy1 = sin(theta1 * xw->d2r)
	       * sin(spinphi1 * xw->d2r);
	    spinzee1 = cos(theta1 * xw->d2r);
	    spinexx2 = sin(theta2 * xw->d2r)
	       * cos(spinphi2 * xw->d2r);
	    spinwyy2 = sin(theta2 * xw->d2r)
	       * sin(spinphi2 * xw->d2r);
	    spinzee2 = cos(theta2 * xw->d2r);
	    } /* if no eccentricity */
	 else if (xw->ecc < 1.0)
	    {
	    spinexx1 = sin(theta1 * xw->d2r)
	       * cos(spinphi1 * xw->d2r)
	       * xw->ecc;
	    spinwyy1 = sin(theta1 * xw->d2r)
	       * sin(spinphi1 * xw->d2r);
	    spinzee1 = cos(theta1 * xw->d2r)
	       * xw->ecc;
	    spinexx2 = sin(theta2 * xw->d2r)
	       * cos(spinphi2 * xw->d2r)
	       * xw->ecc;
	    spinwyy2 = sin(theta2 * xw->d2r)
	       * sin(spinphi2 * xw->d2r);
	    spinzee2 = cos(theta2 * xw->d2r)
	       * xw->ecc;
	    } /* if horizontal eccentricity */
	 else /* if (xw->ecc > 1.0) */
	    {
	    spinexx1 = sin(theta1 * xw->d2r)
	       * cos(spinphi1 * xw->d2r)
	       / xw->ecc;
	    spinwyy1 = sin(theta1 * xw->d2r)
	       * sin(spinphi1 * xw->d2r)
	       / xw->ecc;
	    spinzee1 = cos(theta1 * xw->d2r);
	    spinexx2 = sin(theta2 * xw->d2r)
	       * cos(spinphi2 * xw->d2r)
	       / xw->ecc;
	    spinwyy2 = sin(theta2 * xw->d2r)
	       * sin(spinphi2 * xw->d2r)
	       / xw->ecc;
	    spinzee2 = cos(theta2 * xw->d2r);
	    } /* if vertical eccentricity */
	 /* rotate vertically */
	 epsilon = xw->vrot * xw->d2r;
	 rotate(DOWN,
	    epsilon,
	    spinexx1,spinwyy1,spinzee1,
	    &vexx1, &vwyy1, &vzee1);
	 rotate(DOWN,
	    epsilon,
	    spinexx2,spinwyy2,spinzee2,
	    &vexx2, &vwyy2, &vzee2);
	 /* rotate horizontally */
	 epsilon = xw->hrot * xw->d2r;
	 rotate(RIGHT,
	    epsilon,
	    vexx1,vwyy1,vzee1,
	    &hexx1, &hwyy1, &hzee1);
	 rotate(RIGHT,
	    epsilon,
	    vexx2,vwyy2,vzee2,
	    &hexx2, &hwyy2, &hzee2);
	 if (hexx1 > -0.2
	    && hexx2 > -0.2)
	    {
            drawspin(xw,hexx1,hwyy1,hzee1,
               hexx2,hwyy2,hzee2);
	    } /* if foreground */
         } /* for each vertex in dome */
      getkey(xw);
      } /* for each rotation */
   }  /* bldspin */
