/* strlen.c Version 0.4.0. Strut length main routine */
/* Copyright (C) 2004-2010  dondalah721@yahoo.com (Dondalah) */

/* Xdome is free software; you can redistribute it and/or */
/* modify it under the terms of the GNU General Public License */
/* as published by the Free Software Foundation; either version 2 */
/* of the License, or (at your option) any later version. */

/* Xdome is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the */
/* GNU General Public License for more details. */

/* You should have received a copy of the GNU General Public License */
/* along with this program; if not, write to: */

/*       Free Software Foundation, Inc. */
/*       51 Franklin St, Fifth Floor    */
/*       Boston, MA  02110-1301, USA   */

/* The mathematics for this program is based on    */

/* Hugh Kenner, 1923-2003                          */
/* Geodesic Math and How To Use It                 */
/* Berkeley: University of California Press, 1976  */
/* Reprinted in October, 2003.                     */
/* ISBN: 0-520-23931-8.   Paperback.               */

#include "strlen.h"

int main(argc,argv)
int argc;
char **argv;
   {
   int i;
   int rslt;
   char *p;
   xwfmt *xw;
   xw = (xwfmt *) malloc(sizeof(xwfmt) + 16);
   if (xw == NULL)
      {
      fprintf(stderr,"strlen: out of memory "
         "alocating the xw structure\n");
      exit(1);
      } /* out of memory */

   xw->class    = CLASS_I;
   xw->dometype = ICOSA;
   xw->freq     = 3;
   xw->bball    = 0;
   xw->ecc      = 1.0;
   xw->radius   = 1.0;
   xw->spheresw = 0;

   if (argc == 2)
      {
      rslt = strcmp(*(argv+1),"-h");
      if (!rslt) putstx(*argv);
      } /* if 1 parm */
   i = 1;
   while (i < argc)
      {
      rslt = strncmp(*(argv+i),"-f",2);
      if (!rslt)
         {
         p = (char *) *(argv+i) + 2;
         xw->freq = atoi(p);
         if (xw->freq < 1 || xw->freq > 32)
            {
            fprintf(stderr,"Invalid "
               "frequency %s\n",
               *(argv+i));
            putstx(*argv);
            } /* invalid freq */
         i++;
         continue;
         } /* if -f */
      rslt = strncmp(*(argv+i),"-d",2);
      if (!rslt)
         {
         p = (char *) *(argv+i) + 2;
         xw->radius = (double) atof(p) * 0.5;
         if (xw->radius < 1.0
            || xw->radius > 999999.0)
            {
            fprintf(stderr,"Invalid "
               "diameter %s\n",
               *(argv+i));
            putstx(*argv);
            } /* invalid diameter */
         i++;
         continue;
         } /* if -d */
      rslt = strncmp(*(argv+i),"-e",2);
      if (!rslt)
         {
         p = (char *) *(argv+i) + 2;
         xw->ecc = (double) atof(p);
         if (xw->ecc < 0.5
            || xw->ecc > 2.0)
            {
            fprintf(stderr,"Invalid "
               "eccentricity %s\n",
               *(argv+i));
            putstx(*argv);
            } /* invalid eccentricity */
         i++;
         continue;
         } /* if -e */
      rslt = strcmp(*(argv+i),"-c1");
      if (!rslt)
         {
         xw->class = CLASS_I;
         i++;
         continue;
         } /* if -c1 */
      rslt = strcmp(*(argv+i),"-c2");
      if (!rslt)
         {
         xw->class = CLASS_II;
         i++;
         continue;
         } /* if -c2 */
      rslt = strcmp(*(argv+i),"-pi");
      if (!rslt)
         {
         xw->dometype = ICOSA;
         i++;
         continue;
         } /* if -pi */
      rslt = strcmp(*(argv+i),"-po");
      if (!rslt)
         {
         xw->dometype = OCTA;
         i++;
         continue;
         } /* if -po */
      rslt = strcmp(*(argv+i),"-pt");
      if (!rslt)
         {
         xw->dometype = TETRA;
         i++;
         continue;
         } /* if -pt */
      rslt = strcmp(*(argv+i),"-s");
      if (!rslt)
         {
         xw->spheresw = SPHERE;
         i++;
         continue;
         } /* if -s */
      rslt = strcmp(*(argv+i),"-b");
      if (!rslt)
         {
         xw->bball = 1;
         i++;
         continue;
         } /* if -b */
      rslt = strcmp(*(argv+i),"-a");
      if (!rslt)
         {
         about();
         i++;
         continue;
         } /* if -a */
      rslt = strcmp(*(argv+i),"-h");
      if (!rslt)
         {
         putstx(*argv);
         i++;
         continue;
         } /* if -h */
      fprintf(stderr,"Invalid argument %s\n",
         *(argv+i));
      putstx(*argv);
      } /* for each argument */

   if (xw->class == CLASS_II)
      {
      if (xw->freq % 2)
         {
         xw->freq++;
         if (xw->freq > 32) xw->freq = 32;
         } /* odd frequency */
      } /* class II */

   if (xw->bball)
      {
      if (xw->class == CLASS_I)
         {
         if (xw->freq % 3)
            {
	    xw->freq = 3 - (xw->freq % 3) + xw->freq;
            } /* if frequency not multiple of 3 */
         } /* class I */
      else
         {
         if (xw->freq % 6)
            {
	    xw->freq = 6 - (xw->freq % 6) + xw->freq;
            } /* if frequency not multiple of 6 */
         } /* class II */
      if (xw->freq > 30) xw->freq = 30;
      } /* if buckyball */

   shwparm(xw);
   domemain(xw);         /* Start strlen application */
   if (!xw->spheresw) putstat(xw);

   return(0);
   }  /* main */
