/* putlen.c Version 0.4.0. Print one chord */
/* Copyright (C) 2004-2010  dondalah721@yahoo.com (Dondalah) */

/* Xdome is free software; you can redistribute it and/or */
/* modify it under the terms of the GNU General Public License */
/* as published by the Free Software Foundation; either version 2 */
/* of the License, or (at your option) any later version. */

/* Xdome is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the */
/* GNU General Public License for more details. */

/* You should have received a copy of the GNU General Public License */
/* along with this program; if not, write to: */

/*       Free Software Foundation, Inc. */
/*       51 Franklin St, Fifth Floor */
/*       Boston, MA  02110-1301, USA */

/*									*/
/*      PUTLEN: Print one chord.                                        */
/*									*/

#include "strlen.h"

void putlen(xwfmt *xw,
   int nodefrom, int nodeto,
   int x1,int y1,int z1,
   int x2,int y2,int z2,
   double phi1, double theta1,
   double phi2, double theta2)
   {
   int *p,*q;
   double *a,*b,*c;
   double exx1,wyy1,zee1,exx2,wyy2,zee2;
   double xdiff,ydiff,zdiff;
   double xsqd,ysqd,zsqd;
   double phi;
   double diff;
   double lgth;
   double reallgth;
   if (xw->ecc == 1.0)
      {
      exx1 = sin(theta1) * cos(phi1);
      wyy1 = sin(theta1) * sin(phi1);
      zee1 = cos(theta1);
      exx2 = sin(theta2) * cos(phi2);
      wyy2 = sin(theta2) * sin(phi2);
      zee2 = cos(theta2);
      } /* if no eccentricity */
   else if (xw->ecc < 1.0)
      {
      exx1 = sin(theta1) * cos(phi1)
	 * xw->ecc;
      wyy1 = sin(theta1) * sin(phi1);
      zee1 = cos(theta1)
	 * xw->ecc;
      exx2 = sin(theta2) * cos(phi2)
	 * xw->ecc;
      wyy2 = sin(theta2) * sin(phi2);
      zee2 = cos(theta2)
	 * xw->ecc;
      } /* if horizontal eccentricity */
   else /* if (xw->ecc > 1.0) */
      {
      exx1 = sin(theta1) * cos(phi1)
	 / xw->ecc;
      wyy1 = sin(theta1) * sin(phi1)
	 / xw->ecc;
      zee1 = cos(theta1);
      exx2 = sin(theta2) * cos(phi2)
	 / xw->ecc;
      wyy2 = sin(theta2) * sin(phi2)
	 / xw->ecc;
      zee2 = cos(theta2);
      } /* if vertical eccentricity */
   reallgth = 999999999.0;
   if (xw->ecc == 1.0)
      {
      xdiff = exx2 - exx1;
      xsqd  = xdiff * xdiff;
      ydiff = wyy2 - wyy1;
      ysqd  = ydiff * ydiff;
      zdiff = zee2 - zee1;
      zsqd  = zdiff * zdiff;
      lgth  = sqrt(xsqd + ysqd + zsqd);
      reallgth = lgth * xw->radius;
      if (phi1 >= DBLPI)
         phi = phi1 - xw->rad360;
      else if (phi1 < 0.0)
         phi = phi1 + xw->rad360;
      else
         phi = phi1;
      printf("From %2d  xyz %2d %2d %2d  "
         "phi theta %16.12f %16.12f\n",
         nodefrom, x1, y1, z1,
         phi * xw->r2d, theta1 * xw->r2d);
      if (phi2 >= DBLPI)
         phi = phi2 - xw->rad360;
      else if (phi2 < 0.0)
         phi = phi2 + xw->rad360;
      else
         phi = phi2;
      printf("To   %2d  xyz %2d %2d %2d  "
         "phi theta %16.12f %16.12f\n",
         nodeto, x2, y2, z2,
         phi * xw->r2d, theta2 * xw->r2d);
      printf("Length %16.12f %20.12f\n",
         lgth, reallgth);
      } /* if no eccentricity */
   else /* if (xw->ecc != 1.0) */
      {
      xdiff = exx2 - exx1;
      xsqd  = xdiff * xdiff;
      ydiff = wyy2 - wyy1;
      ysqd  = ydiff * ydiff;
      zdiff = zee2 - zee1;
      zsqd  = zdiff * zdiff;
      lgth  = sqrt(xsqd + ysqd + zsqd);
      reallgth = lgth * xw->radius;
      if (phi1 >= DBLPI)
         phi = phi1 - xw->rad360;
      else if (phi1 < 0.0)
         phi = phi1 + xw->rad360;
      else
         phi = phi1;
      printf("From %2d  xyz %2d %2d %2d  "
         "phi theta %16.12f %16.12f\n",
         nodefrom, x1, y1, z1,
         phi * xw->r2d, theta1 * xw->r2d);
      if (phi2 >= DBLPI)
         phi = phi2 - xw->rad360;
      else if (phi2 < 0.0)
         phi = phi2 + xw->rad360;
      else
         phi = phi2;
      printf("To   %2d  xyz %2d %2d %2d  "
         "phi theta %16.12f %16.12f\n",
         nodeto, x2, y2, z2,
         phi * xw->r2d, theta2 * xw->r2d);
      printf("Eccfrom xyz %16.12f %16.12f %16.12f\n", 
         exx1, wyy1, zee1);
      printf("Eccto   xyz %16.12f %16.12f %16.12f\n", 
         exx2, wyy2, zee2);
      printf("Ecclength %16.12f %20.12f\n",
         lgth, reallgth);
      } /* if elipse */
   printf("-------------------------------\n");
   /********************************************************/
   /*                  Collect stats                       */
   /********************************************************/
   if (!xw->spheresw)
      {
      xw->totstrut++;
      if (reallgth < xw->minlen)
         xw->minlen = reallgth;
      if (reallgth > xw->maxlen)
         xw->maxlen = reallgth;
      xw->sumlen += reallgth;
      xw->sumlensqd += (reallgth * reallgth);
      p = (int *) xw->lencount;
      a = (double *) xw->lenlst;
      b = (double *) a + TOTSTRUTS;
      while (a < b)
         {
         diff = (double) fabs(reallgth - *a);
         if (diff < 0.0000001)
	    {
	    (*p)++;
	    break;
	    } /* if length found */
         else if (reallgth < *a)
	    {
	    xw->maxstrut++;
	    q = (int *) p + xw->maxstrut;
	    while (q >= p)
	       {
	       *(q+1) = *q;
	       q--;
	       } /* shift right */
	    *p = 1;
	    c = (double *) xw->lenlst + xw->maxstrut;
	    while (c >= a)
	       {
	       *(c+1) = *c;
	       c--;
	       } /* shift right */
	    *a = reallgth;
	    break;
	    } /* insertion point */
         a++;
         p++;
         } /* for each strut in list */
      } /* if not entire sphere */
   } /* putlen */
