/* 5g29 version 004 */
/* c1t_side.c Version 0.4.0. Class I Tetrahedron */
/* Bottom Triangle */
/* Copyright (C) 2004-2010  dondalah721@yahoo.com (Dondalah) */

/* Xdome is free software; you can redistribute it and/or */
/* modify it under the terms of the GNU General Public License */
/* as published by the Free Software Foundation; either version 2 */
/* of the License, or (at your option) any later version. */

/* Xdome is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the */
/* GNU General Public License for more details. */

/* You should have received a copy of the GNU General Public License */
/* along with this program; if not, write to: */

/*       Free Software Foundation, Inc. */
/*       51 Franklin St, Fifth Floor    */
/*       Boston, MA  02110-1301, USA   */

/*									*/
/*      C1T_SIDE: class I tetrahedron, bottom triangle                  */
/*									*/

#include "strlen.h"

void c1t_side(xwfmt *xw)
   {
   int node,nodefrom,nodeto;
   int exx1,wyy1,zee1;
   int exx2,wyy2,zee2;
   int x;
   int y;
   int z;
   int row;
   double x1,y1,z1;
   double phi,theta;
   double newphi,newtheta;
   double phi1,theta1,phi2,theta2;
   double root;
   double phimed,thetamed;
   double rowphimed,rowthetamed;
   double diff;
   double sum;
   double prod1,prod2,prod3; 
   double dvsr,quotient;
   double thetaleft;
   double philft;
   double thetalft;
   double sidephimed;
   double sidethetamed;
   double root3,root2;
   int *vtxfromptr;
   int *vtxtoptr;
   int *vtxendptr;
   double *philstptr;
   double *thetalstptr;
   double *philowptr;
   double *thetalowptr;
   double *phiendptr;
   /***********************************************************************/
   /* Bottom Triangle */
   /***********************************************************************/
   vtxfromptr  = xw->vtxfrom;
   vtxtoptr    = xw->vtxto;
   philstptr   = xw->philst;
   phiendptr   = xw->philst + xw->totnode;
   thetalstptr = xw->thetalst;
   philowptr   = xw->philow;
   thetalowptr = xw->thetalow;
   root2 = sqrt(2.0);
   root3 = sqrt(3.0);
   /* x=3 y=3 z=0 */
   x1 = root3 * 3.0;
   y1 = 3.0;                  /* y + y - x          */
   z1 = -6.0 / root2;         /* z + z + z - x - y  */
   phimed   = xw->rad60;
   root = sqrt((x1 * x1) + (y1 * y1));
   thetamed = atan2(root,z1);
   thetaleft = thetamed + thetamed - xw->rad180;
   /* x=0 y=6 z=0 */
         /***** x = 0; *****/
         /***** y = row - x; *****/
         /***** y = 6; *****/
         /***** z = xw->freq - x - y; *****/
         /***** z = 0; *****/
         /***** x1 = root3 * (double) x; *****/
         /***** y1 = (double) (y + y - x); *****/
         /***** z1 = (double) (z + z + z - x - y) / root2; *****/
   x1 = 0.0;
   y1 = 12.0;                 /* y _ y - x          */
   z1 = -6.0 / root2;         /* z + z + z - x - y  */
   philft = 0.0;
   root = 12.0;  /***** sqrt((x1 * x1) + (y1 * y1)); *****/
   thetalft = atan2(root,z1);
   sidethetamed = xw->rad180 - thetalft;
   sidephimed   = 0.0;
   node = row = 0;
   rowthetamed = 0.0;
   while (philstptr < phiendptr)
      {
      phi   = *philstptr++;
      theta = *thetalstptr++;
      if (phi == 0.0)
	 {
         /* x=row/2 y=row/2 z=freq - x - y */
         /***** x = row/2; *****/
         /***** y = row - x; *****/
         /***** z = xw->freq - x - y; *****/
         /***** x1 = root3 * (double) x; *****/
         /***** y1 = (double) (y + y - x); *****/
         /***** z1 = (double) (z + z + z - x - y) / root2; *****/
	 x = row >> 1;
	 y = row - x;
	 z = xw->freq - x - y;
         x1 = root3 * (double) x;
         y1 = (double) (y + y - x);          /* y + y - x          */
         z1 = (double) (z+z+z-x-y) / root2;  /* z + z + z - x - y  */
         rowphimed   = xw->rad60;
         root = sqrt((x1 * x1) + (y1 * y1));
         rowthetamed = atan2(root,z1);
	 row++;
	 } /* if beginning of row */
      diff = phimed - phi;
      prod1 = cos(-thetalft) * cos(theta);     
      prod2 = sin(-thetalft)                   
         * sin(theta) * cos(diff);
      sum = prod1 + prod2;
      newtheta = acos(sum);
      prod3 = sin(theta) * sin(diff);
      dvsr = sin(newtheta);
      if (dvsr == 0.0)
         {
	 fprintf(stderr,"newtheta %f dvsr %f node %d\n",
	    newtheta * xw->r2d, dvsr, node);
         quotient = 1.0;
         } /* divide by zero */
      else quotient = prod3 / dvsr;
      if (quotient > 1.0) quotient = 1.0;
      else if (quotient < -1.0) quotient = -1.0;
      newphi = asin(quotient);
      if (phi < xw->rad60 && newphi > 0.0)
	 {
	 if (rowthetamed < sidethetamed + 0.001)
	    {
            newphi = -newphi;
	    } /* if foreground */
	 else
	    {
            newphi = -xw->rad180 + newphi;
	    } /* if background */
	 } /* if wrong side */
      else if (phi > xw->rad60 && newphi < 0.0)
	 {
	 if (rowthetamed < sidethetamed + 0.001)
	    {
            newphi = -newphi;
	    } /* if foreground */
	 else
	    {
            newphi = xw->rad180 + newphi;
	    } /* if background */
	 } /* if wrong side */
      else if (phi == xw->rad60 && newphi == 0.0)
	 {
	 if (rowthetamed < sidethetamed + 0.001)
	    {
            newphi = -newphi;
	    } /* if foreground */
	 else
	    {
            newphi = xw->rad180;
	    } /* if background */
	 } /* if wrong side */
      *philowptr++   = newphi;
      *thetalowptr++ = newtheta;
      node++;
      } /* for each vertex */
   vtxfromptr  = xw->vtxfrom;
   vtxtoptr    = xw->vtxto;
   vtxendptr   = xw->vtxfrom + xw->totvtx;
   printf("Bottom triangle\n");
   while (vtxfromptr < vtxendptr)
      {
      nodefrom = *vtxfromptr++;
      nodeto   = *vtxtoptr++;
      phi1   = *(xw->philow  +nodefrom);
      theta1 = *(xw->thetalow+nodefrom);
      phi2   = *(xw->philow  +nodeto);
      theta2 = *(xw->thetalow+nodeto);
      exx1   = *(xw->xlst+nodefrom);
      wyy1   = *(xw->ylst+nodefrom);
      zee1   = *(xw->zlst+nodefrom);
      exx2   = *(xw->xlst+nodeto);
      wyy2   = *(xw->ylst+nodeto);
      zee2   = *(xw->zlst+nodeto);
      putlen(xw,nodefrom,nodeto,
         exx1,wyy1,zee1,
         exx2,wyy2,zee2,
         phi1,theta1,
         phi2,theta2);
      } /* for each node */
   } /* c1t_side */
