/* c1o_top.c Version 0.4.0. Class I Octahedron */
/* Top Triangle */
/* Copyright (C) 2004-2010  dondalah721@yahoo.com (Dondalah) */

/* Xdome is free software; you can redistribute it and/or */
/* modify it under the terms of the GNU General Public License */
/* as published by the Free Software Foundation; either version 2 */
/* of the License, or (at your option) any later version. */

/* Xdome is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the */
/* GNU General Public License for more details. */

/* You should have received a copy of the GNU General Public License */
/* along with this program; if not, write to: */

/*       Free Software Foundation, Inc. */
/*       51 Franklin St, Fifth Floor    */
/*       Boston, MA  02110-1301, USA   */

/*									*/
/*      C1O_TOP: class I octahedron, top triangle                       */
/*									*/

#include "strlen.h"

void c1o_top(xwfmt *xw)
   {
   int x,y,z;
   int exx1,wyy1,zee1;
   int exx2,wyy2,zee2;
   int row;
   int trunc;
   int node,nodefrom,nodeto;
   int rowlmt;
   int xlmt;
   double dblx,dbly,dblz;
   double root;
   double phi,theta;
   double phi1,theta1,phi2,theta2;
   int *vtxfromptr;
   int *vtxtoptr;
   int *vtxendptr;
   int *xlstptr;
   int *ylstptr;
   int *zlstptr;
   double *philstptr;
   double *thetalstptr;
   rowlmt = xw->freq + 1;
   vtxfromptr  = xw->vtxfrom;
   vtxtoptr    = xw->vtxto;
   philstptr   = xw->philst;
   thetalstptr = xw->thetalst;
   xlstptr     = xw->xlst;
   ylstptr     = xw->ylst;
   zlstptr     = xw->zlst;
   node = xw->totvtx = 0;
   for (row=0;row<rowlmt;row++)
      {
      trunc = row % 3;
      xlmt = row + 1;
      for (x=0;x<xlmt;x++)
         {
         y = row - x;
         z = xw->freq - x - y;
         dblx = (double) x;
         dbly = (double) y;
         dblz = (double) z;
	 /* cotangent = x/y */
         if (dbly == 0.0)
            {
            if (dblx == 0.0) phi = 0.0;
            else
               {
               phi = xw->rad90;
               } /* atan2 err */
            } /* if divide by zero */
         else phi = atan2(dblx,dbly);
         root  = sqrt((dblx * dblx) + (dbly * dbly));
         theta = atan2(root,dblz);
         if (x < row)
            {
	    if (xw->bball)
	       {
	       if (trunc == 1)
	          {
                  *vtxfromptr++ = node;
                  *vtxtoptr++   = node + 1;
                  xw->totvtx++;
	          } /* if trunc == 1 */
	       } /* if buckyball */
	    else
	       {
               *vtxfromptr++ = node;
               *vtxtoptr++   = node + 1;
               xw->totvtx++;
	       } /* else not buckyball */
            } /* if x < row */
         if (row < xw->freq)
            {
	    if (xw->bball)
	       {
	       if (trunc == 1)
	          {
                  *vtxfromptr++ = node;
	          *vtxtoptr++   = node + row + 1;
                  xw->totvtx++;
	          } /* if trunc == 1 */
	       else if (trunc == 2)
	          {
                  *vtxfromptr++ = node;
	          *vtxtoptr++   = node + row + 2;
                  xw->totvtx++;
	          } /* if trunc == 2 */
	       } /* if buckyball */
	    else
	       {
	       *vtxfromptr++ = node;
	       *vtxfromptr++ = node;
	       *vtxtoptr++   = node + row + 1;
	       *vtxtoptr++   = node + row + 2;
	       xw->totvtx   += 2;
	       } /* else not buckyball */
            } /* if x < row */
         *philstptr++   = phi;
         *thetalstptr++ = theta;
         *xlstptr++     = x;
         *ylstptr++     = y;
         *zlstptr++     = z;
	 trunc++;
	 trunc %= 3;
         node++;
         } /* for each x */
      } /* for each row */
   xw->totnode = node;
   vtxfromptr  = xw->vtxfrom;
   vtxtoptr    = xw->vtxto;
   vtxendptr   = xw->vtxfrom + xw->totvtx;
   while (vtxfromptr < vtxendptr)
      {
      nodefrom = *vtxfromptr++;
      nodeto   = *vtxtoptr++;
      phi1   = *(xw->philst+nodefrom);
      theta1 = *(xw->thetalst+nodefrom);
      phi2   = *(xw->philst+nodeto);
      theta2 = *(xw->thetalst+nodeto);
      exx1   = *(xw->xlst+nodefrom);
      wyy1   = *(xw->ylst+nodefrom);
      zee1   = *(xw->zlst+nodefrom);
      exx2   = *(xw->xlst+nodeto);
      wyy2   = *(xw->ylst+nodeto);
      zee2   = *(xw->zlst+nodeto);
      putlen(xw,nodefrom,nodeto,
         exx1,wyy1,zee1,
         exx2,wyy2,zee2,
         phi1,theta1,
         phi2,theta2);
      if (xw->spheresw)
         {
         putlen(xw,nodefrom,nodeto,
            exx1,wyy1,zee1,
            exx2,wyy2,zee2,
            phi1+xw->rad90,theta1,
            phi2+xw->rad90,theta2);
         putlen(xw,nodefrom,nodeto,
            exx1,wyy1,zee1,
            exx2,wyy2,zee2,
            phi1+xw->rad180,theta1,
            phi2+xw->rad180,theta2);
         putlen(xw,nodefrom,nodeto,
            exx1,wyy1,zee1,
            exx2,wyy2,zee2,
            phi1+xw->rad270,theta1,
            phi2+xw->rad270,theta2);
         putlen(xw,nodefrom,nodeto,
            exx1,wyy1,zee1,
            exx2,wyy2,zee2,
            phi1,xw->rad180-theta1,
            phi2,xw->rad180-theta2);
         putlen(xw,nodefrom,nodeto,
            exx1,wyy1,zee1,
            exx2,wyy2,zee2,
            phi1+xw->rad90,xw->rad180-theta1,
            phi2+xw->rad90,xw->rad180-theta2);
         putlen(xw,nodefrom,nodeto,
            exx1,wyy1,zee1,
            exx2,wyy2,zee2,
            phi1+xw->rad180,xw->rad180-theta1,
            phi2+xw->rad180,xw->rad180-theta2);
         putlen(xw,nodefrom,nodeto,
            exx1,wyy1,zee1,
            exx2,wyy2,zee2,
            phi1+xw->rad270,xw->rad180-theta1,
            phi2+xw->rad270,xw->rad180-theta2);
         } /* if entire sphere */
      } /* for each node */
   } /* c1o_top */
