/* shwmenu.c Version 0.4.0. Display menu */
/* Copyright (C) 2004-2010  dondalah721@yahoo.com (Dondalah) */

/* Xdome is free software; you can redistribute it and/or */
/* modify it under the terms of the GNU General Public License */
/* as published by the Free Software Foundation; either version 2 */
/* of the License, or (at your option) any later version. */

/* Xdome is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the */
/* GNU General Public License for more details. */

/* You should have received a copy of the GNU General Public License */
/* along with this program; if not, write to: */

/*       Free Software Foundation, Inc. */
/*       51 Franklin St, Fifth Floor    */
/*       Boston, MA  02110-1301, USA   */

#include <xdome.h>

/*									*/
/*      SHWMENU: Display menu on right side of screen.                  */
/*									*/

void shwmenu(xwfmt *xw)
   {
   int jmp;
   int row;
   int col;
   char str[128];
   char classname[64];
   char hedraname[64];
   char viewname[64];

   /****************** XGA         *******************/
   /****************** 1024x768    *******************/
   /****************** jmp = 30;   *******************/
   /****************** row = 40;   *******************/
   /****************** col = 770;  *******************/

   /****************** VGA         *******************/
   /****************** 640x480     *******************/
   /****************** jmp = 15;   *******************/
   /****************** row = 20;   *******************/
   /****************** col = 440;  *******************/

   if (xw->dpywdth < 700)
      {
      jmp = 15;
      row = 20;
      col = xw->dpywdth - 200;
      } /* if VGA */
   else
      {
      jmp = 30;
      row = 40;
      col = xw->dpywdth - 250;
      } /* if XGA */

   XSetForeground(xw->dpy, xw->gc, xw->whiteColor);
   XFillRectangle(xw->dpy,xw->w,xw->gc,col,0,160,400);
   XSetBackground(xw->dpy, xw->gc, xw->whiteColor);
   XSetForeground(xw->dpy, xw->gc, xw->blackColor);
   if (xw->class == CLASS_I)
      {
      strcpy(classname,"I");
      } /* if class I */
   else
      {
      strcpy(classname,"II");
      } /* if class II */
   if (xw->dometype == ICOSA)
      strcpy(hedraname,"Icosahedron");
   else if (xw->dometype == OCTA)
      strcpy(hedraname,"Octahedron");
   else if (xw->dometype == TETRA)
      strcpy(hedraname,"Tetrahedron");
   if (xw->view == FRONT)
      strcpy(viewname,"Front");
   else if (xw->view == BACK)
      {
      if (xw->dometype == OCTA)
         strcpy(viewname,"Side");
      else
         strcpy(viewname,"Back");
      } /* if back view */
   else if (xw->view == TOP)
      strcpy(viewname,"Top");
   sprintf(str,"Class %s %s",
      classname, hedraname);
   XDrawImageString(xw->dpy,xw->w,xw->gc,
      col,row,str,strlen(str));
   row += jmp;
   sprintf(str,"Freq %d %s View",
      xw->freq, viewname);
   XDrawImageString(xw->dpy,xw->w,xw->gc,
      col,row,str,strlen(str));
   row += jmp;
   if (xw->ecc != 1.0)
      {
      sprintf(str,"Elipse %4.2f",
         xw->ecc);
      XDrawImageString(xw->dpy,xw->w,xw->gc,
         col,row,str,strlen(str));
      row += jmp;
      } /* if elipse */
   row += jmp;
   sprintf(str,"p) Pause/Continue");
   XDrawImageString(xw->dpy,xw->w,xw->gc,
      col,row,str,strlen(str));
   row += jmp;
   sprintf(str,"q) Quit");
   XDrawImageString(xw->dpy,xw->w,xw->gc,
      col,row,str,strlen(str));
   } /* shwmenu */
