# rndpwr.s - random number generator based on 16 byte seed
#   	generates a random number with normal distribution
#   	from 0 to (2^n) - 1
#   	where 1 <= n <= 32
# Version 1.4.0
# Copyright (C) 1999-2010  dondalah721@yahoo.com (Dondalah)

# Xdome is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License as
# published by the Free Software Foundation; either version 2 of
# the License, or (at your option) any later version.

# Xdome is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to:

#	Free Software Foundation, Inc.
#	51 Franklin St, Fifth Floor
#	Boston, MA  02110-1301, USA

# Usage:
#   	unsigned int rndpwr(int bits,
#		unsigned char *sd);

# called by:
#   	unsigned int rndnum(unsigned int limit,
#		unsigned char *sd);

#   	rnd() function is inline

# initialize the seed with:
#   	unsigned char *sd;
#   	sd = (unsigned char *) rndinit();

# The inner loop again: is a copy of rnd()

	.file	"rndpwr.s"
	.version	"1.4.0"
gcc2_compiled.:
.text
	.align 4
.globl rndpwr
	.type	 rndpwr,@function
rndpwr:
	pushl %ebp
	movl %esp,%ebp
	pushl %ebx
	pushl %ecx
	pushl %esi
	subl $64,%esp           /* local variables */
	movl 8(%ebp),%ecx	/* loop counter = #bits */
	cmpl $32,%ecx		/* if parm1 > 32 */
	ja   fail		/* default = 0 */
	orl  %ecx,%ecx		/* if parm1 <> 0 */
	jnz  setup		/* calculate result */
fail:
	xorl %eax,%eax		/* default = 0 */
	jmp  .L1		/* return */
setup:
	movl 12(%ebp),%esi	/* 2nd parm = sd pointer */
	xorl %ebx,%ebx		/* clear result */
again:
	/* next iteration of randomizer */
	clc				/* clear carry flag */
	movl (%esi),%eax		/* get sd */
	shll $1,%eax			/* double it */
	movl %eax,-48(%ebp)		/* save in sd2 */
	movl 4(%esi),%eax		/* get sd+4 */
	rcll $1,%eax			/* double it with carry */
	movl %eax,-44(%ebp)		/* save in sd2+4 */
	movl 8(%esi),%eax		/* get sd+8 */
	rcll $1,%eax			/* double it with carry */
	movl %eax,-40(%ebp)		/* save in sd2+8 */
	movl 12(%esi),%eax		/* get sd+12 */
	rcll $1,%eax			/* double it with carry */
	movl %eax,-36(%ebp)		/* save in sd2+12 */

	clc				/* clear carry flag */
	movl 8(%esi),%eax		/* get sd+8 */
	addl (%esi),%eax		/* add sd */
	movl %eax,8(%esi)		/* save in sd+8 */
	movl 12(%esi),%eax		/* get sd+12 */
	adcl 4(%esi),%eax		/* add sd+4 */
	movl %eax,12(%esi)		/* save in sd+12 */

	clc				/* clear carry flag */
	movl (%esi),%eax		/* get sd */
	addl -48(%ebp),%eax		/* add sd2 */
	movl %eax,(%esi)		/* save in sd */
	movl 4(%esi),%eax		/* get sd+4 */
	adcl -44(%ebp),%eax		/* add sd2+4 */
	movl %eax,4(%esi)		/* save in sd+4 */
	movl 8(%esi),%eax		/* get sd+8 */
	adcl -40(%ebp),%eax		/* add sd2+8 */
	movl %eax,8(%esi)		/* save in sd+8 */
	movl 12(%esi),%eax		/* get sd+12 */
	adcl -36(%ebp),%eax		/* add sd2+12 */
	movl %eax,12(%esi)		/* save in sd+12 */
	shll $1,%eax                    /* high order bit to carry */
	rcll $1,%ebx		/* rslt = (rslt << 1) | carry; */
	loop again
	movl %ebx,%eax		/* return(rslt) */

	jmp .L1
	.align 4
.L1:
	addl $64,%esp
	popl %esi
	popl %ecx
	popl %ebx
	popl %ebp
	ret
