#!/usr/bin/make

# nonintel.mak Version 0.4.0. Compile domedemo.c.
# for non-Intel machines.
# Copyright (C) 2004-2010 dondalah721@yahoo.com (Dondalah)

# Xdome is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.

# Xdome is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to:

# 	Free Software Foundation, Inc.
# 	51 Franklin St, Fifth Floor
# 	Boston, MA  02110-1301, USA

# Make sure that the Debian font package xfonts-base
# is installed on your system.  Or have the equivalent
# of xfonts-base installed.

# Debian font
XFONT=\"7x13\"

# uncomment if you want the dome window in
# the upper left of your virtual desktop
# UPPERLEFT=-D UPPERLEFT

OBJ=domedemo.o \
	bld.o \
	shwmenu.o \
	rnd.o \
	rndinit.o \
	rndnum.o \
	rndpwr.o \
	getmd5.o \
	md5c.o

CC=gcc

CFLAGS=-c -Wall -O6 -I. \
	-I/usr/X11R6/include/X11 \
	-I../xdome \
        -DFONT=$(XFONT) \
	$(UPPERLEFT)

LDFLAGS=-L/usr/X11R6/lib -lX11 -L. -ldemo \
	-L../xdome -lxdome -lm

all:		$(OBJ) libdemo.a domedemo

domedemo:		$(OBJ)
	$(CC) -Wall -O6 $(OBJ) -o domedemo $(LDFLAGS)

libdemo.a:		$(OBJ)
	rm -f libdemo.a
	ar r libdemo.a $(OBJ)

domedemo.o:	domedemo.c
	$(CC) $(CFLAGS) domedemo.c

bld.o:		bld.c
	$(CC) $(CFLAGS) bld.c

shwmenu.o:		shwmenu.c
	$(CC) $(CFLAGS) shwmenu.c

rndinit.o:		rndinit.c
	$(CC) $(CFLAGS) rndinit.c

rnd.o:			rnd2.c
	$(CC) $(CFLAGS) rnd2.c -o rnd.o

rndpwr.o:		rndpwr2.c
	$(CC) $(CFLAGS) rndpwr2.c -o rndpwr.o

rndnum.o:		rndnum2.c
	$(CC) $(CFLAGS) rndnum2.c -o rndnum.o

getmd5.o:		getmd5.c
	$(CC) $(CFLAGS) getmd5.c

md5c.o:			md5c.c
	$(CC) $(CFLAGS) md5c.c

clean:
	rm -f domedemo libdemo.a $(OBJ)
