/* bld.c Version 0.4.0. build random domes */
/* Copyright (C) 2004-2010  dondalah721@yahoo.com (Dondalah) */

/* Xdome is free software; you can redistribute it and/or */
/* modify it under the terms of the GNU General Public License */
/* as published by the Free Software Foundation; either version 2 */
/* of the License, or (at your option) any later version. */

/* Xdome is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the */
/* GNU General Public License for more details. */

/* You should have received a copy of the GNU General Public License */
/* along with this program; if not, write to: */

/*       Free Software Foundation, Inc. */
/*       51 Franklin St, Fifth Floor    */
/*       Boston, MA  02110-1301, USA   */

/*									*/
/*      BLD: Loop to choose random dome specs and then                  */
/*      build the dome for a screen saver.                              */
/*									*/

#include <xdome.h>
#include "rnd.h"

void bld(xwfmt *xw)
   {
   int wt;
   int buckyb;
   int eccsw;
   int eccval;
   int vertsw;
   int pauserow;
   int pausecol;
   double dblecc;
   char str[64];
   unsigned char *sd;
   sd = (unsigned char *) rndinit();
   if (sd == NULL)
      {
      fprintf(stderr,"bld: out of memory "
	 "allocating sd\n");
      exit(1);
      } /* out of mem */

   pauserow = 15 * 25;

   if (xw->rootww < 700)
      pausecol = xw->dpywdth - 200;
   else
      pausecol = xw->dpywdth - 250;

   while (xw->runflg)
      {
      xw->class    = (int) rndpwr(1,sd);
      xw->dometype = (int) rndnum(3,sd);
      xw->view     = (int) rndnum(3,sd);
      buckyb = (int) rndpwr(2,sd);
      if (!buckyb)
	 {
	 xw->bball = 1;
         if (xw->class == CLASS_II)
            {
            xw->freq = (int) (rndnum(5,sd) * 6) + 6;
            } /* if class 2 */
         else
            {
            xw->freq = (int) (rndnum(10,sd) * 3) + 3;
            } /* if class 1 */
	 } /* if buckyball (1/4) */
      else
	 {
	 xw->bball = 0;
         if (xw->class == CLASS_II)
            {
            xw->freq = (int) (rndnum(16,sd) << 1) + 2;
            } /* if class 2 */
         else
            {
            xw->freq = (int) rndnum(32,sd) + 1;
            } /* if class 1 */
	 } /* not buckyball (3/4) */
      eccsw = (int) rndpwr(2,sd);
      if (!eccsw)
         {
	 vertsw = (int) rnd(sd);
	 if (!vertsw)
	    {
	    /* 1.01 - 2.00 */
	    eccval = (int) rndnum(100,sd) + 1;
	    dblecc = (double) eccval;
            xw->ecc = 1.0 + (dblecc / 100.0);
	    } /* vertical eccentricity 1/2 of time */
	 else
	    {
	    /* 0.50 - 0.99 */
	    eccval = (int) rndnum(50,sd);
	    dblecc = (double) eccval;
            xw->ecc = 0.5 + (dblecc / 100.0);
	    } /* horizontal eccentricity 1/2 of time */
         } /* eccentricity 1/4 of the time */
      else
         {
         xw->ecc = 1.0;
         } /* no eccentricity 3/4 of the time */
      shwmenu(xw);
      if (xw->class == CLASS_I) calc_c1(xw);
      else if (xw->class == CLASS_II) calc_c2(xw);
      wt = 5;
      while (wt-- && xw->runflg)
         {
         ifkey(xw);
	 if (!xw->runflg) break;
	 if (xw->pause)   break;
	 sleep(1);
         } /* wait loop */
      if (xw->pause)
         {
         strcpy(str,"Pause");
         XDrawImageString(xw->dpy,xw->w,xw->gc,
            pausecol,pauserow,str,strlen(str));
         } /* if pause active */
      while (xw->runflg && xw->pause)
	 {
         ifkey(xw);
	 if (!xw->pause)
	    {
            strcpy(str,"                 ");
            XDrawImageString(xw->dpy,xw->w,xw->gc,
               pausecol,pauserow,str,strlen(str));
	    break;
	    } /* if pause ended */
	 sleep(1);
	 } /* if pause */
      if (xw->runflg)
         {
         XSetForeground(xw->dpy, xw->gc, xw->whiteColor);
         XFillRectangle(xw->dpy,xw->w,xw->gc,
	    0,0,SCRW,SCRH);
         XSetForeground(xw->dpy, xw->gc, xw->blackColor);
         } /* if still running program */
      } /* while running program */
   } /* bld */
