/*
initx.c Version 0.3.2.  Initialize X Windows Session 
Copyright (C) 2004-2005 dondalah@ripco.com (Dondalah)

Xdome is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

Xdome is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to:

	Free Software Foundation, Inc.
	51 Franklin St, Fifth Floor
	Boston, MA  02110-1301, USA
*/

/* This X Windows code is based on: */
/* http://tronche.lri.fr:8000/gui/x/xlib-tutorial/2nd-program-anatomy.html */

#include "xdome.h"

void initx(xwfmt *xw,
   char *pgm)
   {
   int rslt;
   char title[64];

   xw->dpy = XOpenDisplay(NIL);

   if (xw->dpy == NULL)
      {
      fprintf(stderr,"X Windows failure\n");
      exit(1);
      } /* if X Windows is not active */

   assert(xw->dpy);

   xw->whiteColor = WhitePixel(xw->dpy, DefaultScreen(xw->dpy));
   xw->blackColor = BlackPixel(xw->dpy, DefaultScreen(xw->dpy));

   xw->w = XCreateSimpleWindow(xw->dpy,
      DefaultRootWindow(xw->dpy),
      0, 0, 
      SCRW, SCRH,
      0, xw->whiteColor,
      xw->whiteColor);

   XSelectInput(xw->dpy, xw->w, StructureNotifyMask);

   XMapWindow(xw->dpy, xw->w);

   xw->gc = XCreateGC(xw->dpy, xw->w, 0, NIL);

   xw->fontid = (Font) XLoadFont(xw->dpy,FONT);

   XSetFont(xw->dpy,xw->gc,xw->fontid);

   XSetForeground(xw->dpy, xw->gc, xw->blackColor);

   xw->dfltscr = XDefaultScreenOfDisplay(xw->dpy);
   if (xw->dfltscr == NULL)
      {
      fprintf(stderr,"XDefaultScreenOfDisplay failed\n");
      perror("XDefaultScreenOfDisplay failed");
      exit(1);
      } /* if error */

   xw->cmap = XDefaultColormapOfScreen(xw->dfltscr);

   rslt = XAllocNamedColor(xw->dpy,xw->cmap,"red",
      &xw->scrdef,&xw->exctdef);

   if (rslt < 0)
      {
      fprintf(stderr,"XAllocNamedColor failed\n");
      perror("XAllocNamedColor failed");
      exit(1);
      } /* if error */
   xw->red = xw->scrdef.pixel;

   rslt = XAllocNamedColor(xw->dpy,xw->cmap,"blue",
      &xw->scrdef,&xw->exctdef);

   if (rslt < 0)
      {
      fprintf(stderr,"XAllocNamedColor failed\n");
      perror("XAllocNamedColor failed");
      exit(1);
      } /* if error */
   xw->blue = xw->scrdef.pixel;

   XSetWindowBorderWidth(xw->dpy, xw->w, 40);

   sprintf(title,pgm);
   XStoreName(xw->dpy,xw->w,title);
   XSetIconName(xw->dpy,xw->w,title);

#ifdef UPPERLEFT

   XMoveWindow(xw->dpy,xw->w,0,0);

#endif

   while(1)
      {
      XEvent e;
      XNextEvent(xw->dpy, &e);
      if (e.type == MapNotify) break;
      } /* wait for window initialization */

   } /* initx */
