/*
ifkey.c Version 0.3.2.  Test keyboard for input, read key if present
Copyright (C) 2004-2005 dondalah@ripco.com (Dondalah)

Xdome is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

Xdome is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to:

	Free Software Foundation, Inc.
	51 Franklin St, Fifth Floor
	Boston, MA  02110-1301, USA
*/

#include "xdome.h"

void ifkey(xw)
xwfmt *xw;
   {
   int msk;
   int symbol;
   int XCheckMaskEvent();
   XEvent e;
   XKeyEvent *k;

   msk = KeyPressMask|ExposureMask
      |ButtonPressMask|KeyReleaseMask;

   XSelectInput(xw->dpy, xw->w, msk);

   while (XCheckMaskEvent(xw->dpy, msk, &e))
      {
      if (e.type == KeyPress)
         {
         k = (XKeyEvent *) &e;
         symbol = XLookupKeysym(k,0);
         if (symbol == XK_Escape
	    || symbol == XK_q)
            {
            xw->runflg = 0;
            break;
            } /* if quit */
         else if (symbol == XK_p)
            {
            xw->pause ^= 1;
            break;
            } /* if pause in domedemo */
         else if (symbol == XK_Shift_L
	    || symbol == XK_Shift_R)
	    {
	    xw->shift = 1;
	    } /* if shift key pressed */
         else if (symbol == XK_F1)
            {
	    if (xw->shift)
	       {
	       xw->wtfact = 0;
	       break;
	       } /* if shift F1 */
	    else
	       {
	       xw->wtfact <<= 1;
	       if (!xw->wtfact)
	          xw->wtfact = 1;
	       else if (xw->wtfact > 16)
	          xw->wtfact = 0;
               break;
	       } /* if simple F1 */
            } /* if fast/slow */
         else if (symbol == XK_F2)
            {
	    if (xw->shift)
	       {
	       xw->wtfact = 0;
	       xw->ecc = 1.0;
	       break;
	       } /* if shift F2 */
            } /* if horizontal elipse */
         else if (symbol == XK_F3)
            {
	    if (xw->shift)
	       {
	       xw->wtfact = 0;
	       xw->ecc = 1.0;
	       break;
	       } /* if shift F3 */
            } /* if vertical elipse */
         } /* if keypress event */
      else if (e.type == KeyRelease)
	 {
         k = (XKeyEvent *) &e;
         symbol = XLookupKeysym(k,0);
         if (symbol == XK_Shift_L
	    || symbol == XK_Shift_R)
	    xw->shift = 0;
	 } /* if key release event */
      else if (e.type == ButtonPress)
         {
	 xw->runflg = 0;
	 break;
         } /* if button press event */
      else if (e.type == Expose)
         {
         xw->drawsw = 1;
	 break;
         } /* if expose event */
      } /* if event received */
   } /* ifkey */
