/* c2t_top_fg.c Version 0.3.2. Class II Tetrahedron */
/* Top View, Side Triangle, foreground */
/* Copyright (C) 2004-2005  dondalah@ripco.com (Dondalah) */

/* Xdome is free software; you can redistribute it and/or */
/* modify it under the terms of the GNU General Public License */
/* as published by the Free Software Foundation; either version 2 */
/* of the License, or (at your option) any later version. */

/* Xdome is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the */
/* GNU General Public License for more details. */

/* You should have received a copy of the GNU General Public License */
/* along with this program; if not, write to: */

/*       Free Software Foundation, Inc. */
/*       51 Franklin St, Fifth Floor    */
/*       Boston, MA  02110-1301, USA   */

/*									*/
/*      C2T_TOP_FG: class II tetrahedron, top view                      */
/*                      side triangle, foreground                       */
/*									*/

#include "xdome.h"

void c2t_top_fg(xwfmt *xw)
   {
   int nodefrom,nodeto;
   double phi1,theta1,phi2,theta2;
   int *vtxfromptr;
   int *vtxtoptr;
   int *vtxendptr;
   int *topfromptr;
   int *topfromend;
   int *lefttoptr;
   int *rghttoptr;
   int *bbmidptr;
   int basefrom;
   int baseto;
   int topfromvtx;
   int lefttovtx;
   int rghttovtx;
   int bbmidvtx;
   int bbputsw;
   double leftmidtheta;
   double rghttotheta;
   double northmidtheta;
   vtxfromptr   = (int *) xw->vtxfrom;
   vtxtoptr     = (int *) xw->vtxto;
   vtxendptr    = (int *) xw->vtxfrom   + xw->totvtx;
   topfromptr   = (int *) xw->topfrom;
   topfromend   = (int *) xw->topfrom   + xw->tottri;
   lefttoptr    = (int *) xw->leftto;
   rghttoptr    = (int *) xw->rghtto;
   bbmidptr     = (int *) xw->bbmidpt;
   /* for each triangle */
   while (!xw->bball && topfromptr < topfromend)
      {
      topfromvtx  = *topfromptr++;
      lefttovtx   = *lefttoptr++;
      rghttovtx   = *rghttoptr++;
      basefrom    = lefttovtx;
      baseto      = rghttovtx;

      theta1        = *(xw->thetalow+topfromvtx);
      theta2        = *(xw->thetalow+lefttovtx);
      leftmidtheta  = (theta1 + theta2) * 0.5;
      rghttotheta   = *(xw->thetalow+rghttovtx);
      northmidtheta = (leftmidtheta + rghttotheta) * 0.5;

      /* base strut */
      phi1     = *(xw->philow  +basefrom);
      theta1   = *(xw->thetalow+basefrom);
      phi2     = *(xw->philow  +baseto);
      theta2   = *(xw->thetalow+baseto);
      /* northern hemisphere */
      bbputsw = 0;
      if (xw->freq == 2
	 && theta1 < xw->rad90 + 1.5
         && theta2 < xw->rad90 + 1.5)
         bbputsw = 1;
      else if (xw->freq == 4
	 && theta1 < xw->rad90 + 0.5
         && theta2 < xw->rad90 + 0.5)
         bbputsw = 1;
      else if (xw->freq == 6
	 && theta1 < xw->rad90 + 0.1
         && theta2 < xw->rad90 + 0.1)
         bbputsw = 1;
      else if (xw->freq == 8
	 && theta1 < xw->rad90 + 0.1
         && theta2 < xw->rad90 + 0.1)
         bbputsw = 1;
      else if (xw->freq == 10
	 && theta1 < xw->rad90 + 0.1
         && theta2 < xw->rad90 + 0.1)
         bbputsw = 1;
      else if (xw->freq >= 12
	 && theta1 < xw->rad90 + 0.01
         && theta2 < xw->rad90 + 0.01)
         bbputsw = 1;
      if (bbputsw)
	 {
         drawchord(xw,phi1+xw->rad60,theta1,
            phi2+xw->rad60,theta2);
         drawchord(xw,phi1+xw->rad180,theta1,
            phi2+xw->rad180,theta2);
         drawchord(xw,-phi1-xw->rad60,theta1,
            -phi2-xw->rad60,theta2);
	 } /* else foreground */
      /* left strut */
      phi1     = *(xw->philow  +topfromvtx);
      theta1   = *(xw->thetalow+topfromvtx);
      phi2     = *(xw->philow  +lefttovtx);
      theta2   = *(xw->thetalow+lefttovtx);
      /* northern hemisphere */
      bbputsw = 0;
      if (xw->freq == 2
	 && theta1 < xw->rad90 + 1.5
         && theta2 < xw->rad90 + 1.5)
         bbputsw = 1;
      else if (xw->freq == 4
	 && theta1 < xw->rad90 + 0.5
         && theta2 < xw->rad90 + 0.5)
         bbputsw = 1;
      else if (xw->freq == 6
	 && theta1 < xw->rad90 + 0.2
         && theta2 < xw->rad90 + 0.2)
         bbputsw = 1;
      else if (xw->freq == 8
	 && theta1 < xw->rad90 + 0.2
         && theta2 < xw->rad90 + 0.2)
         bbputsw = 1;
      else if (xw->freq == 10
	 && theta1 < xw->rad90 + 0.1
         && theta2 < xw->rad90 + 0.1)
         bbputsw = 1;
      else if (xw->freq >= 12
	 && theta1 < xw->rad90 + 0.01
         && theta2 < xw->rad90 + 0.01)
         bbputsw = 1;
      if (bbputsw)
	 {
         drawchord(xw,phi1+xw->rad60,theta1,
            phi2+xw->rad60,theta2);
         drawchord(xw,phi1+xw->rad180,theta1,
            phi2+xw->rad180,theta2);
         drawchord(xw,-phi1-xw->rad60,theta1,
            -phi2-xw->rad60,theta2);
	 } /* else foreground */
      /* right strut */
      phi1     = *(xw->philow  +topfromvtx);
      theta1   = *(xw->thetalow+topfromvtx);
      phi2     = *(xw->philow  +rghttovtx);
      theta2   = *(xw->thetalow+rghttovtx);
      /* northern hemisphere */
      bbputsw = 0;
      if (xw->freq == 2
	 && theta1 < xw->rad90 + 1.5
         && theta2 < xw->rad90 + 1.5)
         bbputsw = 1;
      else if (xw->freq == 4
	 && theta1 < xw->rad90 + 0.5
         && theta2 < xw->rad90 + 0.5)
         bbputsw = 1;
      else if (xw->freq == 6
	 && theta1 < xw->rad90 + 0.2
         && theta2 < xw->rad90 + 0.2)
         bbputsw = 1;
      else if (xw->freq == 8
	 && theta1 < xw->rad90 + 0.2
         && theta2 < xw->rad90 + 0.2)
         bbputsw = 1;
      else if (xw->freq == 10
	 && theta1 < xw->rad90 + 0.1
         && theta2 < xw->rad90 + 0.1)
         bbputsw = 1;
      else if (xw->freq >= 12
	 && theta1 < xw->rad90 + 0.01
         && theta2 < xw->rad90 + 0.01)
         bbputsw = 1;
      if (bbputsw)
	 {
         drawchord(xw,phi1+xw->rad60,theta1,
            phi2+xw->rad60,theta2);
         drawchord(xw,phi1+xw->rad180,theta1,
            phi2+xw->rad180,theta2);
         drawchord(xw,-phi1-xw->rad60,theta1,
            -phi2-xw->rad60,theta2);
	 } /* else foreground */
      } /* for each triangle */
   /* for each buckyball strut */
   while (xw->bball && vtxfromptr < vtxendptr)
      {
      nodefrom      = *vtxfromptr++;
      nodeto        = *vtxtoptr++;
      bbmidvtx      = *bbmidptr++;
      northmidtheta = *(xw->thetalow+bbmidvtx);

      phi1     = *(xw->philow   + nodefrom);
      theta1   = *(xw->thetalow + nodefrom);
      phi2     = *(xw->philow   + nodeto);
      theta2   = *(xw->thetalow + nodeto);
      /* northern hemisphere */
      bbputsw = 0;
      if (xw->freq == 6
	 && theta1 < xw->rad90 + 0.5
         && theta2 < xw->rad90 + 0.5)
         bbputsw = 1;
      else if (xw->freq == 12
	 && theta1 < xw->rad90 + 0.3
         && theta2 < xw->rad90 + 0.3)
         bbputsw = 1;
      else if (xw->freq == 18
	 && theta1 < xw->rad90 + 0.2
         && theta2 < xw->rad90 + 0.2)
         bbputsw = 1;
      else if (xw->freq > 18
	 && theta1 < xw->rad90 + 0.1
         && theta2 < xw->rad90 + 0.1)
         bbputsw = 1;
      if (bbputsw)
	 {
         drawchord(xw,phi1+xw->rad60,theta1,
            phi2+xw->rad60,theta2);
         drawchord(xw,phi1+xw->rad180,theta1,
            phi2+xw->rad180,theta2);
         drawchord(xw,-phi1-xw->rad60,theta1,
            -phi2-xw->rad60,theta2);
	 } /* else foreground */
      } /* for each buckyball strut */
   } /* c2t_top_fg */
