/* c2i_back_fg.c Version 0.3.2. Class II Icosahedron  */
/* Back View, Side Triangles, foreground              */
/* Copyright (C) 2004-2005  dondalah@ripco.com (Dondalah)  */

/* Xdome is free software; you can redistribute it and/or */
/* modify it under the terms of the GNU General Public License */
/* as published by the Free Software Foundation; either version 2 */
/* of the License, or (at your option) any later version. */

/* Xdome is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the */
/* GNU General Public License for more details. */

/* You should have received a copy of the GNU General Public License */
/* along with this program; if not, write to: */

/*       Free Software Foundation, Inc. */
/*       51 Franklin St, Fifth Floor    */
/*       Boston, MA  02110-1301, USA   */

/*									*/
/*      C2I_FRONT_SIDE: class II icosahedron, back view                 */
/*                      side triangles, foreground                      */
/*									*/

#include "xdome.h"

void c2i_back_fg(xwfmt *xw)
   {
   int nodefrom,nodeto;
   double phi1,theta1,phi2,theta2;
   int *vtxfromptr;
   int *vtxtoptr;
   int *vtxendptr;
   int *topfromptr;
   int *topfromend;
   int *lefttoptr;
   int *rghttoptr;
   int *bbmidptr;
   int basefrom;
   int baseto;
   int topfromvtx;
   int lefttovtx;
   int rghttovtx;
   int bbmidvtx;
   double leftmidphi;
   double rghttophi;
   double northmidphi;
   double southmidphi;
   vtxfromptr  = xw->vtxfrom;
   vtxtoptr    = xw->vtxto;
   vtxendptr   = xw->vtxfrom + xw->totvtx;
   topfromptr   = (int *) xw->topfrom;
   topfromend   = (int *) xw->topfrom   + xw->tottri;
   lefttoptr    = (int *) xw->leftto;
   rghttoptr    = (int *) xw->rghtto;
   bbmidptr     = (int *) xw->bbmidpt;
   /* for each triangle */
   while (!xw->bball && topfromptr < topfromend)
      {
      topfromvtx  = *topfromptr++;
      lefttovtx   = *lefttoptr++;
      rghttovtx   = *rghttoptr++;
      basefrom    = lefttovtx;
      baseto      = rghttovtx;

      phi1        = *(xw->philow+topfromvtx)  + xw->rad36;
      phi2        = *(xw->philow+lefttovtx)   + xw->rad36;
      leftmidphi  = (phi1 + phi2) * 0.5;
      rghttophi   = *(xw->philow+rghttovtx)   + xw->rad36;
      northmidphi = (leftmidphi + rghttophi) * 0.5;
      phi1        = *(xw->philow+topfromvtx)  + xw->rad72;
      phi2        = *(xw->philow+lefttovtx)   + xw->rad72;
      leftmidphi  = (phi1 + phi2) * 0.5;
      rghttophi   = *(xw->philow+rghttovtx)   + xw->rad72;
      southmidphi = (leftmidphi + rghttophi) * 0.5;

      /* base strut */
      phi1     = *(xw->philow  +basefrom);
      theta1   = *(xw->thetalow+basefrom);
      phi2     = *(xw->philow  +baseto);
      theta2   = *(xw->thetalow+baseto);
      /* northern hemisphere */
      drawchord(xw,phi1-xw->rad36,theta1,
         phi2-xw->rad36,theta2);
      if (phi1 + xw->rad36 > xw->rad90
         && phi2 + xw->rad36 > xw->rad90)
	 {
	 /* bypass */
	 } /* if background */
      else if (northmidphi > xw->rad90)
	 {
	 /* bypass */
	 } /* if background */
      else
	 {
         drawchord(xw,phi1+xw->rad36,theta1,
            phi2+xw->rad36,theta2);
         drawchord(xw,-phi1-xw->rad36,theta1,
            -phi2-xw->rad36,theta2);
	 } /* else foreground */
      /* southern hemisphere */
      drawchord(xw,phi1,xw->rad180-theta1,
         phi2,xw->rad180-theta2);
      drawchord(xw,-phi1,xw->rad180-theta1,
         -phi2,xw->rad180-theta2);
      if (phi1 + xw->rad72 > xw->rad90
         && phi2 + xw->rad72 > xw->rad90)
	 {
	 /* bypass */
	 } /* if background */
      else if (southmidphi > xw->rad90)
	 {
	 /* bypass */
	 } /* if background */
      else
	 {
         drawchord(xw, phi1+xw->rad72,xw->rad180-theta1,
            phi2+xw->rad72,xw->rad180-theta2);
         drawchord(xw,-phi1-xw->rad72,xw->rad180-theta1,
            -phi2-xw->rad72,xw->rad180-theta2);
	 } /* else foreground */
      /* left strut */
      phi1     = *(xw->philow  +topfromvtx);
      theta1   = *(xw->thetalow+topfromvtx);
      phi2     = *(xw->philow  +lefttovtx);
      theta2   = *(xw->thetalow+lefttovtx);
      /* northern hemisphere */
      drawchord(xw,phi1-xw->rad36,theta1,
         phi2-xw->rad36,theta2);
      drawchord(xw,phi1+xw->rad36,theta1,
         phi2+xw->rad36,theta2);
      drawchord(xw,-phi1-xw->rad36,theta1,
         -phi2-xw->rad36,theta2);
      /* southern hemisphere */
      drawchord(xw,phi1,xw->rad180-theta1,
         phi2,xw->rad180-theta2);
      drawchord(xw,-phi1,xw->rad180-theta1,
         -phi2,xw->rad180-theta2);
      if (phi1 + xw->rad72 > xw->rad90
         && phi2 + xw->rad72 > xw->rad90)
	 {
	 /* bypass */
	 } /* if background */
      else if (southmidphi > xw->rad90)
	 {
	 /* bypass */
	 } /* if background */
      else
	 {
         drawchord(xw,phi1+xw->rad72,xw->rad180-theta1,
            phi2+xw->rad72,xw->rad180-theta2);
         drawchord(xw,-phi1-xw->rad72,xw->rad180-theta1,
            -phi2-xw->rad72,xw->rad180-theta2);
	 } /* else foreground */
      /* right strut */
      phi1     = *(xw->philow  +topfromvtx);
      theta1   = *(xw->thetalow+topfromvtx);
      phi2     = *(xw->philow  +rghttovtx);
      theta2   = *(xw->thetalow+rghttovtx);
      /* northern hemisphere */
      drawchord(xw,phi1-xw->rad36,theta1,
         phi2-xw->rad36,theta2);
      if (phi1 + xw->rad36 > xw->rad90
         && phi2 + xw->rad36 > xw->rad90)
	 {
	 /* bypass */
	 } /* if background */
      else if (northmidphi > xw->rad90)
	 {
	 /* bypass */
	 } /* if background */
      else
	 {
         drawchord(xw,phi1+xw->rad36,theta1,
            phi2+xw->rad36,theta2);
         drawchord(xw,-phi1-xw->rad36,theta1,
            -phi2-xw->rad36,theta2);
	 } /* else foreground */
      /* southern hemisphere */
      drawchord(xw,phi1,xw->rad180-theta1,
         phi2,xw->rad180-theta2);
      drawchord(xw,-phi1,xw->rad180-theta1,
         -phi2,xw->rad180-theta2);
      if (phi1 + xw->rad72 > xw->rad90
         && phi2 + xw->rad72 > xw->rad90)
	 {
	 /* bypass */
	 } /* if background */
      else if (southmidphi > xw->rad90)
	 {
	 /* bypass */
	 } /* if background */
      else
	 {
         drawchord(xw,phi1+xw->rad72,xw->rad180-theta1,
            phi2+xw->rad72,xw->rad180-theta2);
         drawchord(xw,-phi1-xw->rad72,xw->rad180-theta1,
            -phi2-xw->rad72,xw->rad180-theta2);
	 } /* else foreground */
      } /* for each triangle */
   /* for each buckyball strut */
   while (xw->bball && vtxfromptr < vtxendptr)
      {
      nodefrom    = *vtxfromptr++;
      nodeto      = *vtxtoptr++;
      bbmidvtx    = *bbmidptr++;
      northmidphi = *(xw->philow+bbmidvtx) + xw->rad36;
      southmidphi = *(xw->philow+bbmidvtx) + xw->rad72;

      phi1     = *(xw->philow   + nodefrom);
      theta1   = *(xw->thetalow + nodefrom);
      phi2     = *(xw->philow   + nodeto);
      theta2   = *(xw->thetalow + nodeto);
      /* northern hemisphere */
      drawchord(xw,phi1-xw->rad36,theta1,
         phi2-xw->rad36,theta2);
      if (northmidphi > xw->rad90 + xw->rad36)
	 {
	 /* bypass */
	 } /* if background */
      else
	 {
         drawchord(xw,phi1+xw->rad36,theta1,
            phi2+xw->rad36,theta2);
         drawchord(xw,-phi1-xw->rad36,theta1,
            -phi2-xw->rad36,theta2);
	 } /* else foreground */
      /* southern hemisphere */
      drawchord(xw,phi1,xw->rad180-theta1,
         phi2,xw->rad180-theta2);
      drawchord(xw,-phi1,xw->rad180-theta1,
         -phi2,xw->rad180-theta2);
      if (southmidphi > xw->rad90)
	 {
	 /* bypass */
	 } /* if background */
      else if (phi1 > xw->rad90 + xw->rad72
         && phi2 > xw->rad90 + xw->rad72)
	 {
	 /* bypass */
	 } /* if background */
      else
	 {
         drawchord(xw, phi1+xw->rad72,xw->rad180-theta1,
            phi2+xw->rad72,xw->rad180-theta2);
         drawchord(xw,-phi1-xw->rad72,xw->rad180-theta1,
            -phi2-xw->rad72,xw->rad180-theta2);
	 } /* else foreground */
      if (phi1 + xw->rad72 + 0.0001 > xw->rad90
         &&    phi2 + xw->rad72 + 0.0001 > xw->rad90)
	 {
	 /* bypass */
	 } /* if background */
      else
	 {
         drawchord(xw, phi1+xw->rad72,xw->rad180-theta1,
            phi2+xw->rad72,xw->rad180-theta2);
         drawchord(xw,-phi1-xw->rad72,xw->rad180-theta1,
            -phi2-xw->rad72,xw->rad180-theta2);
	 } /* else foreground */
      } /* for each buckyball strut */
   } /* c2i_back_fg */
