/*
c1i_front_side.c Version 0.3.2. Class I Icosahedron
Front View, Side Triangle
Copyright (C) 2004-2005 dondalah@ripco.com (Dondalah)

Xdome is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

Xdome is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to:

	Free Software Foundation, Inc.
	51 Franklin St, Fifth Floor
	Boston, MA  02110-1301, USA
*/

#include "xdome.h"

void c1i_front_side(xw)
xwfmt *xw;
   {
   int nodefrom,nodeto;
   double phi,theta;
   double newphi,newtheta;
   double phi1,theta1,phi2,theta2;
   double phimed,thetamed;
   double diff;
   double prod1,prod2,prod3;
   double dvsr,quotient;
   int *vtxfromptr;
   int *vtxendptr;
   int *vtxtoptr;
   int *topfromptr;
   int *topfromend;
   int *lefttoptr;
   int *rghttoptr;
   int *bbmidptr;
   int basefrom;
   int baseto;
   int topfromvtx;
   int lefttovtx;
   int rghttovtx;
   int bbmidvtx;
   double leftmidphi;
   double rghttophi;
   double northmidphi;
   double southmidphi;
   double *philstptr;
   double *phiendptr;
   double *thetalstptr;
   double *philowptr;
   double *thetalowptr;
   vtxfromptr  = (int *) xw->vtxfrom;
   vtxtoptr    = (int *) xw->vtxto;
   philstptr   = (double *) xw->philst;
   phiendptr   = (double *) xw->philst + xw->totnode;
   thetalstptr = (double *) xw->thetalst;
   philowptr   = (double *) xw->philow;
   thetalowptr = (double *) xw->thetalow;
   phimed   = xw->rad36;
   thetamed = atan(xw->tau);
   /* convert top vertices to side vertices */
   while (philstptr < phiendptr)
      {
      phi   = *philstptr++;
      theta = *thetalstptr++;
      diff = phimed - phi;
      prod1 = cos(thetamed + thetamed) * cos(theta);
      prod2 = sin(thetamed + thetamed)
         * sin(theta) * cos(diff);
      newtheta = acos(prod1 + prod2);
      prod3 = sin(theta) * sin(diff);
      dvsr  = sin(newtheta);
      if (dvsr == 0.0)  /* should never happen */
         {
         fprintf(stderr,"Divide by zero\n");
         exit(1);
         } /* divide by zero */
      quotient = prod3 / dvsr;
      newphi = asin(quotient) + xw->rad36;
      *philowptr++   = newphi;
      *thetalowptr++ = newtheta;
      } /* for each vertex */
   vtxfromptr   = (int *) xw->vtxfrom;
   vtxtoptr     = (int *) xw->vtxto;
   vtxendptr    = (int *) vtxfromptr    + xw->totvtx;
   topfromptr   = (int *) xw->topfrom;
   topfromend   = (int *) xw->topfrom   + xw->tottri;
   lefttoptr    = (int *) xw->leftto;
   rghttoptr    = (int *) xw->rghtto;
   bbmidptr     = (int *) xw->bbmidpt;
   /* for each triangle */
   while (!xw->bball && topfromptr < topfromend)
      {
      topfromvtx  = *topfromptr++;
      lefttovtx   = *lefttoptr++;
      rghttovtx   = *rghttoptr++;
      basefrom    = lefttovtx;
      baseto      = rghttovtx;

      phi1        = *(xw->philow+topfromvtx);
      phi2        = *(xw->philow+lefttovtx);
      leftmidphi  = (phi1 + phi2) * 0.5;
      rghttophi   = *(xw->philow+rghttovtx);
      northmidphi = (leftmidphi + rghttophi) * 0.5;
      phi1        = *(xw->philow+topfromvtx)  + xw->rad36;
      phi2        = *(xw->philow+lefttovtx)   + xw->rad36;
      leftmidphi  = (phi1 + phi2) * 0.5;
      rghttophi   = *(xw->philow+rghttovtx)   + xw->rad36;
      southmidphi = (leftmidphi + rghttophi) * 0.5;

      /* base strut */
      phi1     = *(xw->philow  +basefrom);
      theta1   = *(xw->thetalow+basefrom);
      phi2     = *(xw->philow  +baseto);
      theta2   = *(xw->thetalow+baseto);
      /* northern hemisphere */
      drawchord(xw,phi1-xw->rad36,theta1,
         phi2-xw->rad36,theta2);
      if (phi1 + xw->rad36 > xw->rad90
         && phi2 + xw->rad36 > xw->rad90)
	 {
	 /* bypass */
	 } /* if background */
      else if (northmidphi > xw->rad90)
	 {
	 /* bypass */
	 } /* if background */
      else
	 {
         drawchord(xw,phi1+xw->rad36,theta1,
            phi2+xw->rad36,theta2);
         drawchord(xw,-phi1-xw->rad36,theta1,
            -phi2-xw->rad36,theta2);
	 } /* else foreground */
      /* southern hemisphere */
      drawchord(xw,phi1,xw->rad180-theta1,
         phi2,xw->rad180-theta2);
      drawchord(xw,-phi1,xw->rad180-theta1,
         -phi2,xw->rad180-theta2);
      if (phi1 + xw->rad72 > xw->rad90
         && phi2 + xw->rad72 > xw->rad90)
	 {
	 /* bypass */
	 } /* if background */
      else if (southmidphi > xw->rad90)
	 {
	 /* bypass */
	 } /* if background */
      else
	 {
         drawchord(xw,phi1+xw->rad72,xw->rad180-theta1,
            phi2+xw->rad72,xw->rad180-theta2);
         drawchord(xw,-phi1-xw->rad72,xw->rad180-theta1,
            -phi2-xw->rad72,xw->rad180-theta2);
	 } /* else foreground */
      /* left strut */
      phi1     = *(xw->philow+topfromvtx);
      theta1   = *(xw->thetalow+topfromvtx);
      phi2     = *(xw->philow+lefttovtx);
      theta2   = *(xw->thetalow+lefttovtx);
      /* northern hemisphere */
      drawchord(xw,phi1-xw->rad36,theta1,
         phi2-xw->rad36,theta2);
      if (phi1 + xw->rad36 > xw->rad90
         && phi2 + xw->rad36 > xw->rad90)
	 {
	 /* bypass */
	 } /* if background */
      else if (northmidphi > xw->rad90)
	 {
	 /* bypass */
	 } /* if background */
      else
	 {
         drawchord(xw,phi1+xw->rad36,theta1,
            phi2+xw->rad36,theta2);
         drawchord(xw,-phi1-xw->rad36,theta1,
            -phi2-xw->rad36,theta2);
	 } /* else foreground */
      /* southern hemisphere */
      drawchord(xw,phi1,xw->rad180-theta1,
         phi2,xw->rad180-theta2);
      drawchord(xw,-phi1,xw->rad180-theta1,
         -phi2,xw->rad180-theta2);
      if (phi1 + xw->rad72 > xw->rad90
         && phi2 + xw->rad72 > xw->rad90)
	 {
	 /* bypass */
	 } /* if background */
      else if (southmidphi > xw->rad90)
	 {
	 /* bypass */
	 } /* if background */
      else
	 {
         drawchord(xw,phi1+xw->rad72,xw->rad180-theta1,
            phi2+xw->rad72,xw->rad180-theta2);
         drawchord(xw,-phi1-xw->rad72,xw->rad180-theta1,
            -phi2-xw->rad72,xw->rad180-theta2);
	 } /* else foreground */
      /* right strut */
      phi1     = *(xw->philow  +topfromvtx);
      theta1   = *(xw->thetalow+topfromvtx);
      phi2     = *(xw->philow  +rghttovtx);
      theta2   = *(xw->thetalow+rghttovtx);
      /* northern hemisphere */
      drawchord(xw,phi1-xw->rad36,theta1,
         phi2-xw->rad36,theta2);
      if (phi1 + xw->rad36 > xw->rad90
         && phi2 + xw->rad36 > xw->rad90)
	 {
	 /* bypass */
	 } /* if background */
      else if (northmidphi > xw->rad90)
	 {
	 /* bypass */
	 } /* if background */
      else
	 {
         drawchord(xw,phi1+xw->rad36,theta1,
            phi2+xw->rad36,theta2);
         drawchord(xw,-phi1-xw->rad36,theta1,
            -phi2-xw->rad36,theta2);
	 } /* else foreground */
      /* southern hemisphere */
      drawchord(xw,phi1,xw->rad180-theta1,
         phi2,xw->rad180-theta2);
      drawchord(xw,-phi1,xw->rad180-theta1,
         -phi2,xw->rad180-theta2);
      if (phi1 + xw->rad72 > xw->rad90
         && phi2 + xw->rad72 > xw->rad90)
	 {
	 /* bypass */
	 } /* if background */
      else if (southmidphi > xw->rad90)
	 {
	 /* bypass */
	 } /* if background */
      else
	 {
         drawchord(xw,phi1+xw->rad72,xw->rad180-theta1,
            phi2+xw->rad72,xw->rad180-theta2);
         drawchord(xw,-phi1-xw->rad72,xw->rad180-theta1,
            -phi2-xw->rad72,xw->rad180-theta2);
	 } /* else foreground */
      } /* for each triangle */

   /* for each buckyball strut */
   while (xw->bball && vtxfromptr < vtxendptr)
      {
      nodefrom    = *vtxfromptr++;
      nodeto      = *vtxtoptr++;
      bbmidvtx    = *bbmidptr++;
      northmidphi = *(xw->philow+bbmidvtx) + xw->rad36;
      southmidphi = *(xw->philow+bbmidvtx) + xw->rad72;

      phi1     = *(xw->philow   + nodefrom);
      theta1   = *(xw->thetalow + nodefrom);
      phi2     = *(xw->philow   + nodeto);
      theta2   = *(xw->thetalow + nodeto);
      /* northern hemisphere */
      drawchord(xw,phi1-xw->rad36,theta1,
         phi2-xw->rad36,theta2);
      if (northmidphi > xw->rad90)
	 {
	 /* bypass */
	 } /* if background */
      else
	 {
         drawchord(xw,phi1+xw->rad36,theta1,
            phi2+xw->rad36,theta2);
         drawchord(xw,(xw->rad72-phi1)+xw->rad36,theta1,
            (xw->rad72-phi2)+xw->rad36,theta2);
         drawchord(xw,-phi1-xw->rad36,theta1,
            -phi2-xw->rad36,theta2);
         drawchord(xw,-(xw->rad72-phi1)-xw->rad36,theta1,
            -(xw->rad72-phi2)-xw->rad36,theta2);
	 } /* else foreground */

      /* southern hemisphere */
      drawchord(xw,phi1,xw->rad180-theta1,
         phi2,xw->rad180-theta2);
      drawchord(xw,-phi1,xw->rad180-theta1,
         -phi2,xw->rad180-theta2);
      if (phi1 + xw->rad72 + 0.0001 > xw->rad90
         && phi2 + xw->rad72 + 0.0001 > xw->rad90)
	 {
	 /* bypass */
	 } /* if background */
      else
	 {
         drawchord(xw,phi1+xw->rad72,xw->rad180-theta1,
            phi2+xw->rad72,xw->rad180-theta2);
         drawchord(xw,-phi1-xw->rad72,xw->rad180-theta1,
            -phi2-xw->rad72,xw->rad180-theta2);
	 } /* else foreground */
      } /* for each buckyball strut */
   } /* c1i_front_side */
