/*
verify.h Version 0.3.2. verify header file
Copyright (C) 2004-2005 dondalah@ripco.com (Dondalah)

Xdome is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

Xdome is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to:

	Free Software Foundation, Inc.
	51 Franklin St, Fifth Floor
	Boston, MA  02110-1301, USA
*/

/* to define the escape key */
/* and other special keys */
#define XK_MISCELLANY 1
#define XK_LATIN1 1

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <time.h>
#include <string.h>
#include <sys/times.h>
#include <sys/types.h>
#include <X11/Xlib.h>
#include <X11/keysymdef.h>
#include <assert.h>
#include <unistd.h>
#include <math.h>

/* Debian font */
/* This font requires the Debian xfonts-base */
/* package to be installed. */
/* #define FONT "7x13" */

#define NIL (0)
#define SCRW 620
#define SCRH 420
#define LFTMARG  10
#define IMGSZ  410
#define RADIUS 200


#define CLASS_I  0
#define CLASS_II 1
/* polyhedron */
#define ICOSA    0
#define OCTA     1
#define TETRA    2
/* view */
#define FRONT    0
#define BACK     1
#define TOP      2
/* rotation direction */
#define LEFT     0
#define RIGHT    1
#define UP       2
#define DOWN     3
#define CCLKWISE 4
#define CLKWISE  5
/* array sizes */
/* slightly larger than a frequency 32 icosahedron */
#define MAXSTR    32768

typedef struct xwfmt {
   int whiteColor;
   int blackColor;
   int runflg;
   unsigned long red;
   unsigned long blue;
   Display *dpy;
   Window w;
   GC gc;
   Font fontid;
   Screen *dfltscr;
   Colormap cmap;
   XColor scrdef;
   XColor exctdef;
   int class;
   int dometype;
   int freq;
   int view;
   int bball;
   int wtfact;
   int shift;       /* used for shift F1-F4 */
   int totstr;
   double ecc;
   double hrot;
   double vrot;
   double spin;
   double d2r;
   double r2d;
   double *phifrom;
   double *thetafrom;
   double *phito;
   double *thetato;
   double *eccx1;
   double *eccy1;
   double *eccz1;
   double *eccx2;
   double *eccy2;
   double *eccz2;
   } xwfmt;

void getkey(xwfmt *xw);

void ifkey(xwfmt *xw);

void initx(xwfmt *xw,
   char *pgm);

void vfyinit(xwfmt *xw);

void eccinit(xwfmt *xw);

void vfyfree(xwfmt *xw);

void eccfree(xwfmt *xw);

void slow(xwfmt *xw);

void slp(xwfmt *xw);

void drawspin(xwfmt *xw,
   double eccx1,
   double eccy1,
   double eccz1,
   double eccx2,
   double eccy2,
   double eccz2);

void bld(xwfmt *xw);

void bldspin(xwfmt *xw);

void bldecc(xwfmt *xw);

int getbyte();

void getecc(xwfmt *xw,
   int lnlen,
   char *ln);

void getkey(xwfmt *xw);

int getln(int *eofsw, char *ln);

void getphi(xwfmt *xw,
   int lnlen,
   char *ln);

void getpolar(xwfmt *xw,
   int lnlen,
   char *ln);

void getspec(xwfmt *xw,
   int lnlen,
   char *ln);

void parse(xwfmt *xw);

void parsecc(xwfmt *xw);

void rotate(int direction,
   double epsilon,
   double exx,
   double wyy,
   double zee,
   double *newexx,
   double *newwyy,
   double *newzee);

void shwmenu(xwfmt *xw);

void spinmenu(xwfmt *xw);
