/* spinmenu.c Version 0.3.2. Display spin menu */
/* Copyright (C) 2004-2005  dondalah@ripco.com (Dondalah) */

/* Xdome is free software; you can redistribute it and/or */
/* modify it under the terms of the GNU General Public License */
/* as published by the Free Software Foundation; either version 2 */
/* of the License, or (at your option) any later version. */

/* Xdome is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the */
/* GNU General Public License for more details. */

/* You should have received a copy of the GNU General Public License */
/* along with this program; if not, write to: */

/*       Free Software Foundation, Inc. */
/*       51 Franklin St, Fifth Floor    */
/*       Boston, MA  02110-1301, USA   */

#include "verify.h"

/*									*/
/*      SHWMENU: Display menu on right side of screen.                  */
/*									*/

void spinmenu(xwfmt *xw)
   {
   int row;
   int col;
   int incr;
   char str[128];
   char classname[64];
   char hedraname[64];
   row = 40;
   col = 440;
   incr = 15;
   XSetForeground(xw->dpy, xw->gc, xw->whiteColor);
   XFillRectangle(xw->dpy,xw->w,xw->gc,col,0,160,400);
   XSetForeground(xw->dpy, xw->gc, xw->blackColor);
   if (xw->class == CLASS_I)
      {
      strcpy(classname,"I");
      } /* if class I */
   else
      {
      strcpy(classname,"II");
      } /* if class II */
   if (xw->dometype == ICOSA)
      strcpy(hedraname,"Icosahedron");
   else if (xw->dometype == OCTA)
      strcpy(hedraname,"Octahedron");
   else if (xw->dometype == TETRA)
      strcpy(hedraname,"Tetrahedron");
   sprintf(str,"Class %s %s",
      classname, hedraname);
   XDrawImageString(xw->dpy,xw->w,xw->gc,
      col,row,str,strlen(str));
   row += incr;
   sprintf(str,"Frequency %d", xw->freq);
   XDrawImageString(xw->dpy,xw->w,xw->gc,
      col,row,str,strlen(str));
   row += incr;
   if (xw->ecc != 1.0)
      {
      sprintf(str,"Elipse %4.2f",
         xw->ecc);
      XDrawImageString(xw->dpy,xw->w,xw->gc,
         col,row,str,strlen(str));
      row += incr;
      } /* if eccentric dome */
   sprintf(str,"Rotation");
   XDrawImageString(xw->dpy,xw->w,xw->gc,
      col,row,str,strlen(str));
   row += incr;
   sprintf(str,"Horizontal %5.1f deg.",
      xw->hrot);
   XDrawImageString(xw->dpy,xw->w,xw->gc,
      col,row,str,strlen(str));
   row += incr;
   sprintf(str,"Vertical   %5.1f deg.",
      xw->vrot);
   XDrawImageString(xw->dpy,xw->w,xw->gc,
      col,row,str,strlen(str));
   row += incr;
   sprintf(str,"Spin       %5.1f deg.",
      xw->spin);
   XDrawImageString(xw->dpy,xw->w,xw->gc,
      col,row,str,strlen(str));
   row += incr;
   row += incr;
   sprintf(str,"Right) horiz. right");
   XDrawImageString(xw->dpy,xw->w,xw->gc,
      col,row,str,strlen(str));
   row += incr;
   sprintf(str,"Left)  horiz. left");
   XDrawImageString(xw->dpy,xw->w,xw->gc,
      col,row,str,strlen(str));
   row += incr;
   sprintf(str,"Up)    vert. up");
   XDrawImageString(xw->dpy,xw->w,xw->gc,
      col,row,str,strlen(str));
   row += incr;
   sprintf(str,"Down)  vert. down");
   XDrawImageString(xw->dpy,xw->w,xw->gc,
      col,row,str,strlen(str));
   row += incr;
   sprintf(str,"F1) Spin left");
   XDrawImageString(xw->dpy,xw->w,xw->gc,
      col,row,str,strlen(str));
   row += incr;
   sprintf(str,"F2) Spin right");
   XDrawImageString(xw->dpy,xw->w,xw->gc,
      col,row,str,strlen(str));
   row += incr;
   sprintf(str,"F3) Reset");
   XDrawImageString(xw->dpy,xw->w,xw->gc,
      col,row,str,strlen(str));
   row += incr;
   sprintf(str,"q) Quit");
   XDrawImageString(xw->dpy,xw->w,xw->gc,
      col,row,str,strlen(str));
   } /* spinmenu */
