/* getspec.c Version 0.3.2. Parse First Line */
/* Copyright (C) 2004-2005  dondalah@ripco.com (Dondalah) */

/* Xdome is free software; you can redistribute it and/or */
/* modify it under the terms of the GNU General Public License */
/* as published by the Free Software Foundation; either version 2 */
/* of the License, or (at your option) any later version. */

/* Xdome is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the */
/* GNU General Public License for more details. */

/* You should have received a copy of the GNU General Public License */
/* along with this program; if not, write to: */

/*       Free Software Foundation, Inc. */
/*       51 Franklin St, Fifth Floor    */
/*       Boston, MA  02110-1301, USA   */

#include "verify.h"

void getspec(xwfmt *xw, int lnlen, char *ln)
   {
   int rslt;
   int rslt1;
   int rslt2;
   int rslt3;
   int freq;
   char *p,*q,*r;
   char str[128];
   p = (char *) ln;
   q = (char *) ln + lnlen;
   r = (char *) str;
   while (p < q)
      {
      if (*p == ' ')
	 {
	 p++;
         break;
	 } /* if delimiter */
      *r++ = *p++;
      } /* Class */
   *r = '\0';
   if (p >= q)
      {
      fprintf(stderr,"%s\n", str);
      fprintf(stderr,"getspec: end of line "
         "reading class\n");
      exit(1);
      } /* if eol */
   rslt = strcmp(str,"Class");
   if (rslt)
      {
      fprintf(stderr,"%s\n", str);
      fprintf(stderr,"getspec: class missing\n");
      exit(1);
      } /* if eol */
   r = (char *) str;
   while (p < q)
      {
      if (*p == ' ')
	 {
	 p++;
         break;
	 } /* if delimiter */
      *r++ = *p++;
      } /* Class value */
   *r = '\0';
   if (p >= q)
      {
      fprintf(stderr,"%s\n", str);
      fprintf(stderr,"getspec: end of line "
         "reading class value\n");
      exit(1);
      } /* if eol */
   rslt1 = strcmp(str,"I");
   rslt2 = strcmp(str,"II");
   if (rslt1 && rslt2)
      {
      fprintf(stderr,"%s\n", str);
      fprintf(stderr,"getspec: invalid class value\n");
      exit(1);
      } /* if eol */
   if (!rslt1) xw->class = CLASS_I;
   else if (!rslt2) xw->class = CLASS_II;
   r = (char *) str;
   while (p < q)
      {
      if (*p == ' ') break;
      *r++ = *p++;
      } /* polyhedron */
   *r = '\0';
   if (p >= q)
      {
      fprintf(stderr,"%s\n", str);
      fprintf(stderr,"getspec: end of line "
         "reading polyhedron\n");
      exit(1);
      } /* if eol */
   rslt1 = strcmp(str,"Icosahedron");
   rslt2 = strcmp(str,"Octahedron");
   rslt3 = strcmp(str,"Tetrahedron");
   if (rslt1 && rslt2 && rslt3)
      {
      fprintf(stderr,"%s\n", str);
      fprintf(stderr,"getspec: invalid polyhedron\n");
      exit(1);
      } /* if eol */
   if (!rslt1) xw->dometype = ICOSA;
   else if (!rslt2) xw->dometype = OCTA;
   else if (!rslt3) xw->dometype = TETRA;
   while (p < q)
      {
      if (*p != ' ') break;
      p++;
      } /* bypass delimiter */
   r = (char *) str;
   while (p < q)
      {
      if (*p == ' ')
	 {
	 p++;
         break;
	 } /* if delimiter */
      *r++ = *p++;
      } /* Frequency */
   *r = '\0';
   if (p >= q)
      {
      fprintf(stderr,"%s\n", str);
      fprintf(stderr,"getspec: end of line "
         "reading frequency\n");
      exit(1);
      } /* if eol */
   rslt = strcmp(str,"Frequency");
   if (rslt)
      {
      fprintf(stderr,"%s\n", str);
      fprintf(stderr,"getspec: frequency missing\n");
      exit(1);
      } /* if eol */
   r = (char *) str;
   while (p < q)
      {
      if (*p == ' ') break;
      *r++ = *p++;
      } /* Frequency value */
   *r = '\0';
   if (p >= q)
      {
      fprintf(stderr,"%s\n", str);
      fprintf(stderr,"getspec: end of line "
         "reading frequency value\n");
      exit(1);
      } /* if eol */
   freq = atoi(str);
   if (freq < 1 || freq > 32)
      {
      fprintf(stderr,"%s\n", str);
      fprintf(stderr,"getspec: invalid "
	 "frequency value\n");
      exit(1);
      } /* invalid */
   xw->freq = freq;
   }  /* getspec */
