/* getecc.c Version 0.3.2. Parse Eccfrom and Eccto Lines */
/* Copyright (C) 2004-2005  dondalah@ripco.com (Dondalah) */

/* Xdome is free software; you can redistribute it and/or */
/* modify it under the terms of the GNU General Public License */
/* as published by the Free Software Foundation; either version 2 */
/* of the License, or (at your option) any later version. */

/* Xdome is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the */
/* GNU General Public License for more details. */

/* You should have received a copy of the GNU General Public License */
/* along with this program; if not, write to: */

/*       Free Software Foundation, Inc. */
/*       51 Franklin St, Fifth Floor    */
/*       Boston, MA  02110-1301, USA   */

#include "verify.h"

#define FROM 0
#define TO   1

void getecc(xwfmt *xw,
   int lnlen,
   char *ln)
   {
   int i;
   int rslt1;
   int rslt2;
   int fromto;
   double *eccx1ptr;
   double *eccy1ptr;
   double *eccz1ptr;
   double *eccx2ptr;
   double *eccy2ptr;
   double *eccz2ptr;
   double exxval;
   double wyyval;
   double zeeval;
   char *p,*q,*r;
   char str[128];
   p = (char *) ln;
   q = (char *) ln + lnlen;
   r = (char *) str;
   while (p < q)
      {
      if (*p == ' ')
	 {
	 p++;
         break;
	 } /* if delimiter */
      *r++ = *p++;
      } /* Eccfrom/Eccto */
   *r = '\0';
   if (p >= q)
      {
      fprintf(stderr,"%s\n", str);
      fprintf(stderr,"getecc: end of line "
         "reading Eccfrom and Eccto\n");
      eccfree(xw);
      exit(1);
      } /* if eol */
   rslt1 = strcmp(str,"Eccfrom");
   rslt2 = strcmp(str,"Eccto");
   /* only accept Eccfrom and Eccto lines */
   if (rslt1 && rslt2) return;
   fromto = -999;
   if (!rslt1) fromto = FROM;
   else if (!rslt2) fromto = TO;
   while (p < q)
      {
      if (*p != ' ') break;
      p++;
      } /* bypass Eccfrom/Eccto delimiter */
   /* after Eccfrom/Eccto, */
   /* bypass the following token(s) */
   /* 1 = 'xyz' */
   i = 1;
   while (i--)
      {
      while (p < q)
         {
         if (*p == ' ') break;
	 p++;
         } /* token */
      if (p >= q)
         {
         fprintf(stderr,"%s\n", str);
         fprintf(stderr,"getecc: end of line "
            "reading token to "
	    "left of x, y, & z\n");
         eccfree(xw);
         exit(1);
         } /* if eol */
      while (p < q)
         {
         if (*p != ' ') break;
	 p++;
         } /* token delimiter */
      if (p >= q)
         {
         fprintf(stderr,"%s\n", str);
         fprintf(stderr,"getecc: end of line "
            "reading token delimiter to "
	    "left of x, y, & z\n");
         eccfree(xw);
         exit(1);
         } /* if eol */
      } /* for each token & delimiter to bypass */
   /* read x value in degrees */
   r = (char *) str;
   while (p < q)
      {
      if (*p == ' ') break;
      *r++ = *p++;
      } /* x value, cartesian coordinate */
   *r = '\0';
   if (p >= q)
      {
      fprintf(stderr,"%s\n", str);
      fprintf(stderr,"getecc: end of line "
         "reading x value\n");
      eccfree(xw);
      exit(1);
      } /* if eol */
   exxval = atof(str);
   if (exxval < -1.0 || exxval > 1.0)
      {
      fprintf(stderr,"%s\n", ln);
      fprintf(stderr,"%s\n", str);
      fprintf(stderr,"getecc: invalid "
	 "x value %f\n", exxval);
      eccfree(xw);
      exit(1);
      } /* if invalid */
   while (p < q)
      {
      if (*p != ' ') break;
      p++;
      } /* token delimiter */
   if (p >= q)
      {
      fprintf(stderr,"%s\n", str);
      fprintf(stderr,"getecc: end of line "
         "reading token delimiter "
         "after x value\n");
      eccfree(xw);
      exit(1);
      } /* if eol */
   /* read y value in degrees */
   r = (char *) str;
   while (p < q)
      {
      if (*p == ' ') break;
      *r++ = *p++;
      } /* y value, cartesian coordinate */
   *r = '\0';
   if (p >= q)
      {
      fprintf(stderr,"%s\n", str);
      fprintf(stderr,"getecc: end of line "
         "reading y value\n");
      eccfree(xw);
      exit(1);
      } /* if eol */
   wyyval = atof(str);
   if (wyyval < -1.0 || wyyval > 1.0)
      {
      fprintf(stderr,"%s\n", ln);
      fprintf(stderr,"%s\n", str);
      fprintf(stderr,"getecc: invalid "
	 "y value %f\n", wyyval);
      eccfree(xw);
      exit(1);
      } /* if invalid */
   while (p < q)
      {
      if (*p != ' ') break;
      p++;
      } /* token delimiter */
   if (p >= q)
      {
      fprintf(stderr,"%s\n", str);
      fprintf(stderr,"getecc: end of line "
         "reading token delimiter "
         "after y value\n");
      eccfree(xw);
      exit(1);
      } /* if eol */
   /* read z value, cartesian coordinate */
   r = (char *) str;
   while (p < q)
      {
      if (*p == ' ') break;
      *r++ = *p++;
      } /* z value in degrees */
   *r = '\0';
   zeeval = atof(str);
   if (zeeval < -1.0 || zeeval > 1.0)
      {
      fprintf(stderr,"%s\n", ln);
      fprintf(stderr,"%s\n", str);
      fprintf(stderr,"getecc: invalid "
	 "z value %f\n", zeeval);
      eccfree(xw);
      exit(1);
      } /* if invalid */
   if (fromto == FROM)
      {
      eccx1ptr    = (double *) xw->eccx1 + xw->totstr;
      *eccx1ptr   = exxval;
      eccy1ptr    = (double *) xw->eccy1 + xw->totstr;
      *eccy1ptr   = wyyval;
      eccz1ptr    = (double *) xw->eccz1 + xw->totstr;
      *eccz1ptr   = zeeval;
      } /* if from */
   else
      {
      eccx2ptr    = (double *) xw->eccx2 + xw->totstr;
      *eccx2ptr   = exxval;
      eccy2ptr    = (double *) xw->eccy2 + xw->totstr;
      *eccy2ptr   = wyyval;
      eccz2ptr    = (double *) xw->eccz2 + xw->totstr;
      *eccz2ptr   = zeeval;
      xw->totstr++;
      } /* if to */
   }  /* getecc */
