/* bldecc.c Version 0.3.2. build eccentric dome on screen */
/* Copyright (C) 2004-2005  dondalah@ripco.com (Dondalah) */

/* Xdome is free software; you can redistribute it and/or */
/* modify it under the terms of the GNU General Public License */
/* as published by the Free Software Foundation; either version 2 */
/* of the License, or (at your option) any later version. */

/* Xdome is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the */
/* GNU General Public License for more details. */

/* You should have received a copy of the GNU General Public License */
/* along with this program; if not, write to: */

/*       Free Software Foundation, Inc. */
/*       51 Franklin St, Fifth Floor    */
/*       Boston, MA  02110-1301, USA   */

#include "verify.h"

void bldecc(xwfmt *xw)
   {
   int i;
   double *eccx1ptr;
   double *eccy1ptr;
   double *eccz1ptr;
   double *eccx2ptr;
   double *eccy2ptr;
   double *eccz2ptr;
   double eccx1,eccy1,eccz1;
   double eccx2,eccy2,eccz2;
   double epsilon;
   double spinexx1,spinwyy1,spinzee1;
   double spinexx2,spinwyy2,spinzee2;
   double vexx1,vwyy1,vzee1;
   double vexx2,vwyy2,vzee2;
   double hexx1,hwyy1,hzee1;
   double hexx2,hwyy2,hzee2;

   while (xw->runflg)
      {
      XClearWindow(xw->dpy,xw->w);
      /* Don't allow top view */
      xw->view = FRONT;
      spinmenu(xw);
      eccx1ptr   = (double *) xw->eccx1;
      eccy1ptr   = (double *) xw->eccy1;
      eccz1ptr   = (double *) xw->eccz1;
      eccx2ptr   = (double *) xw->eccx2;
      eccy2ptr   = (double *) xw->eccy2;
      eccz2ptr   = (double *) xw->eccz2;
      i = xw->totstr;
      while (i--)
         {
	 eccz1   = *eccx1ptr++;
	 eccy1   = *eccy1ptr++;
	 eccx1   = *eccz1ptr++;
	 eccz2   = *eccx2ptr++;
	 eccy2   = *eccy2ptr++;
	 eccx2   = *eccz2ptr++;
	 /* spin on axis */
	 epsilon = xw->spin * xw->d2r;
	 rotate(RIGHT,
	    epsilon,
	    eccx1,eccy1,eccz1,
	    &spinexx1, &spinwyy1, &spinzee1);
	 rotate(RIGHT,
	    epsilon,
	    eccx2,eccy2,eccz2,
	    &spinexx2, &spinwyy2, &spinzee2);
	 /* rotate vertically */
	 epsilon = xw->vrot * xw->d2r;
	 rotate(DOWN,
	    epsilon,
	    spinexx1,spinwyy1,spinzee1,
	    &vexx1, &vwyy1, &vzee1);
	 rotate(DOWN,
	    epsilon,
	    spinexx2,spinwyy2,spinzee2,
	    &vexx2, &vwyy2, &vzee2);
	 /* rotate horizontally */
	 epsilon = xw->hrot * xw->d2r;
	 rotate(RIGHT,
	    epsilon,
	    vexx1,vwyy1,vzee1,
	    &hexx1, &hwyy1, &hzee1);
	 rotate(RIGHT,
	    epsilon,
	    vexx2,vwyy2,vzee2,
	    &hexx2, &hwyy2, &hzee2);
	 if (hexx1 > -0.2
	    && hexx2 > -0.2)
	    {
            drawspin(xw,hexx1,hwyy1,hzee1,
               hexx2,hwyy2,hzee2);
	    } /* if foreground */
         } /* for each vertex in dome */
      getkey(xw);
      } /* for each rotation */
   }  /* bldecc */
