/* strlen.h Version 0.3.2. strlen header file */
/* Copyright (C) 2004-2005  dondalah@ripco.com (Dondalah) */

/* Xdome is free software; you can redistribute it and/or */
/* modify it under the terms of the GNU General Public License */
/* as published by the Free Software Foundation; either version 2 */
/* of the License, or (at your option) any later version. */

/* Xdome is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the */
/* GNU General Public License for more details. */

/* You should have received a copy of the GNU General Public License */
/* along with this program; if not, write to: */

/*       Free Software Foundation, Inc. */
/*       51 Franklin St, Fifth Floor    */
/*       Boston, MA  02110-1301, USA   */

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <math.h>

#define ESC	0x1b			/* Define the escape key	*/
#define TRUE	1			/* Define some handy constants	*/
#define FALSE	0			/* Define some handy constants	*/
#define ON	1			/* Define some handy constants	*/
#define OFF	0			/* Define some handy constants	*/

/*									*/
/*      strlen data fields                                              */
/*									*/

#define CLASS_I  0
#define CLASS_II 1
#define ICOSA 0
#define OCTA  1
#define TETRA 2
#define SPHERE 1
#define DBLPI  (M_PI + M_PI)
#define TOTNODES  1700
#define TOTSTRUTS 5100

typedef struct xwfmt {
   int class;
   int dometype;
   int freq;
   int bball;
   int spheresw;
   int totvtx;
   int totnode;
   int totstrut;
   int maxstrut;
   int *lencount;
   double *lenlst;
   double minlen,maxlen;
   double sumlen,sumlensqd;
   double ecc;
   double radius;
   double tau;
   double oneovertau;
   double d2r;
   double r2d;
   double rad12;
   double rad18;
   double rad36;
   double rad45;
   double rad54;
   double rad60;
   double rad72;
   double rad90;
   double rad108;
   double rad120;
   double rad144;
   double rad180;
   double rad216;
   double rad240;
   double rad252;
   double rad270;
   double rad288;
   double rad324;
   double rad360;
   double sin72;
   double cos36;
   double cos72;
   int *vtxfrom;
   int *vtxto;
   int *xlst;
   int *ylst;
   int *zlst;
   double *philst;
   double *thetalst;
   double *philow;
   double *thetalow;
   } xwfmt;

/* strlen routines */
void putstx(char *pgm);
void about(void);
void shwparm(xwfmt *xw);
void domemain(xwfmt *xw);
void bld(xwfmt *xw);
void calc_c1(xwfmt *xw);
void calc_c1i(xwfmt *xw);
void c1i_top(xwfmt *xw);
void c1i_side(xwfmt *xw);
void calc_c1o(xwfmt *xw);
void c1o_top(xwfmt *xw);
void calc_c1t(xwfmt *xw);
void c1t_top(xwfmt *xw);
void c1t_side(xwfmt *xw);
void calc_c2(xwfmt *xw);
void calc_c2i(xwfmt *xw);
void c2i_top(xwfmt *xw);
void c2i_side(xwfmt *xw);
void c2i_ne(xwfmt *xw);
void c2i_se(xwfmt *xw);
void c2i_nw(xwfmt *xw);
void c2i_sw(xwfmt *xw);
void calc_c2o(xwfmt *xw);
void c2o_top(xwfmt *xw);
void c2o_side(xwfmt *xw);
void c2o_east(xwfmt *xw);
void c2o_west(xwfmt *xw);
void calc_c2t(xwfmt *xw);
void c2t_top(xwfmt *xw);
void c2t_side(xwfmt *xw);
void c2t_east(xwfmt *xw);
void c2t_west(xwfmt *xw);
void putlen(xwfmt *xw,
   int nodefrom, int nodeto,
   int x1,int y1,int z1,
   int x2,int y2,int z2,
   double phi1, double theta1,
   double phi2, double theta2);
void putstat(xwfmt *xw);
