/* shwparm.c Version 0.3.2. Print parameters */
/* Copyright (C) 2004-2005  dondalah@ripco.com (Dondalah) */

/* Xdome is free software; you can redistribute it and/or */
/* modify it under the terms of the GNU General Public License */
/* as published by the Free Software Foundation; either version 2 */
/* of the License, or (at your option) any later version. */

/* Xdome is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the */
/* GNU General Public License for more details. */

/* You should have received a copy of the GNU General Public License */
/* along with this program; if not, write to: */

/*       Free Software Foundation, Inc. */
/*       51 Franklin St, Fifth Floor */
/*       Boston, MA  02110-1301, USA */

#include "strlen.h"

void shwparm(xwfmt *xw)
   {
   char classname[32];
   char hedraname[32];
   char str[128];
   strcpy(classname,"???");
   strcpy(hedraname,"???");
   if (xw->class == CLASS_I)
      sprintf(classname,"I");
   else if (xw->class == CLASS_II)
      sprintf(classname,"II");
   if (xw->dometype == ICOSA)
      sprintf(hedraname,"Icosahedron");
   else if (xw->dometype == OCTA)
      sprintf(hedraname,"Octahedron");
   else if (xw->dometype == TETRA)
      sprintf(hedraname,"Tetrahedron");
   printf("Class %s %s  Frequency %d  "
      "Radius %f  Diameter %f\n",
      classname, hedraname,
      xw->freq, xw->radius,
      xw->radius * 2.0);
   if (xw->ecc != 1.0 || xw->bball)
      {
      if (xw->ecc != 1.0)
	 {
	 sprintf(str,"Eccentricity %4.2f",
	    xw->ecc);
         if (xw->bball)
	    {
	    strcat(str,"  Buckyball");
            } /* if buckyball */
         } /* if eccentricity */
      else
         {
         strcpy(str,"Buckyball");
         } /* else only buckyball */
      printf("%s\n", str);
      } /* if eccentricity and/or buckyball */
   }  /* shwparm */










