/* putstat.c Version 0.3.2. Print statistics */
/* Copyright (C) 2004-2005  dondalah@ripco.com (Dondalah) */

/* Xdome is free software; you can redistribute it and/or */
/* modify it under the terms of the GNU General Public License */
/* as published by the Free Software Foundation; either version 2 */
/* of the License, or (at your option) any later version. */

/* Xdome is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the */
/* GNU General Public License for more details. */

/* You should have received a copy of the GNU General Public License */
/* along with this program; if not, write to: */

/*       Free Software Foundation, Inc. */
/*       51 Franklin St, Fifth Floor    */
/*       Boston, MA  02110-1301, USA   */

/*									*/
/*      PUTSTAT: Print statistics.                                      */
/*									*/

#include "strlen.h"

void putstat(xwfmt *xw)
   {
   int faces;
   int *p;
   double *a,*b;
   double sumlen_sqd;
   double diff;
   double dvsr;
   double variance;
   double stdev;
   printf("\n");
   shwparm(xw);
   printf("\n");
   printf("Minimum length %f\n",
      xw->minlen);
   printf("Maximum length %f   %f times longer\n",
      xw->maxlen, xw->maxlen / xw->minlen);
   if (xw->totstrut < 30)
      dvsr = (double) xw->totstrut;
   else
      dvsr = (double) xw->totstrut - 1.0;
   sumlen_sqd = xw->sumlen * xw->sumlen;
   diff = xw->sumlensqd - (sumlen_sqd / (double) xw->totstrut);
   variance = diff / dvsr;
   stdev = sqrt(variance);
   printf("Average length %f   Stdev %f\n",
      xw->sumlen / (double) xw->totstrut,
      stdev);
   if (xw->class == CLASS_I)
      {
      if (xw->dometype == ICOSA) faces = 20;
      else if (xw->dometype == OCTA) faces = 8;
      else faces = 4;
      } /* if class I */
   else
      {
      if (xw->dometype == ICOSA) faces = 60;
      else if (xw->dometype == OCTA) faces = 24;
      else faces = 12;
      } /* if class II */
   printf("Struts per face   %6d\n", xw->totstrut);
   printf("Total  faces      %6d\n", faces);
   printf("Struts per sphere %6d\n", xw->totstrut * faces);
   printf("Length count   %d\n",
      xw->maxstrut);
   printf("\n");
   printf("    Strut List\n");
   printf("    Count   Length\n");
   a = (double *) xw->lenlst;
   b = (double *) a + xw->maxstrut;
   p = (int *) xw->lencount;
   while (a < b)
      {
      printf("%9d   %f\n", *p++, *a++);
      } /* for each strut in list */
   } /* putstat */
