/* domemain.c Version 0.3.2. initialize global variables */
/* Copyright (C) 2004-2005  dondalah@ripco.com (Dondalah) */

/* Xdome is free software; you can redistribute it and/or */
/* modify it under the terms of the GNU General Public License */
/* as published by the Free Software Foundation; either version 2 */
/* of the License, or (at your option) any later version. */

/* Xdome is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the */
/* GNU General Public License for more details. */

/* You should have received a copy of the GNU General Public License */
/* along with this program; if not, write to: */

/*       Free Software Foundation, Inc. */
/*       51 Franklin St, Fifth Floor    */
/*       Boston, MA  02110-1301, USA   */

/*									*/
/*      DOMEMAIN: Initialize global variables and start                 */
/*      main program.                                                   */
/*									*/

#include "strlen.h"

void domemain(xwfmt *xw)
   {
   int *p,*q;
   double *a,*b;
   xw->vtxfrom = (int *) malloc(TOTNODES * sizeof(int));
   if (xw->vtxfrom == NULL)
      {
      fprintf(stderr,"strlen: out of memory "
         "allocating vtxfrom\n");
      exit(1);
      } /* out of mem */
   xw->vtxto   = (int *) malloc(TOTNODES * sizeof(int));
   if (xw->vtxto == NULL)
      {
      fprintf(stderr,"strlen: out of memory "
         "allocating vtxto\n");
      exit(1);
      } /* out of mem */
   xw->xlst    = (int *) malloc(TOTNODES * sizeof(int));
   if (xw->xlst == NULL)
      {
      fprintf(stderr,"strlen: out of memory "
         "allocating xlst\n");
      exit(1);
      } /* out of mem */
   xw->ylst    = (int *) malloc(TOTNODES * sizeof(int));
   if (xw->ylst == NULL)
      {
      fprintf(stderr,"strlen: out of memory "
         "allocating ylst\n");
      exit(1);
      } /* out of mem */
   xw->zlst    = (int *) malloc(TOTNODES * sizeof(int));
   if (xw->zlst == NULL)
      {
      fprintf(stderr,"strlen: out of memory "
         "allocating zlst\n");
      exit(1);
      } /* out of mem */
   xw->philst   = (double *) malloc(TOTNODES * sizeof(double));
   if (xw->philst == NULL)
      {
      fprintf(stderr,"strlen: out of memory "
         "allocating philst\n");
      exit(1);
      } /* out of mem */
   xw->thetalst   = (double *) malloc(TOTNODES * sizeof(double));
   if (xw->thetalst == NULL)
      {
      fprintf(stderr,"strlen: out of memory "
         "allocating thetalst\n");
      exit(1);
      } /* out of mem */
   xw->philow   = (double *) malloc(TOTNODES * sizeof(double));
   if (xw->philow == NULL)
      {
      fprintf(stderr,"strlen: out of memory "
         "allocating philow\n");
      exit(1);
      } /* out of mem */
   xw->thetalow   = (double *) malloc(TOTNODES * sizeof(double));
   if (xw->thetalow == NULL)
      {
      fprintf(stderr,"strlen: out of memory "
         "allocating thetalow\n");
      exit(1);
      } /* out of mem */
   xw->lencount = (int *) malloc(TOTSTRUTS * sizeof(int));
   if (xw->lencount == NULL)
      {
      fprintf(stderr,"strlen: out of memory "
         "allocating lencount\n");
      exit(1);
      } /* out of mem */
   xw->lenlst = (double *) malloc(TOTSTRUTS * sizeof(double));
   if (xw->lenlst == NULL)
      {
      fprintf(stderr,"strlen: out of memory "
         "allocating lenlst\n");
      exit(1);
      } /* out of mem */
   xw->tau = (sqrt(5.0) + 1.0) * 0.5;
   xw->oneovertau = 1.0 / xw->tau;
   xw->d2r = M_PI / 180.0;
   xw->r2d = 180.0 / M_PI;
   xw->rad12 = 12.0 * xw->d2r;
   xw->rad18 = 18.0 * xw->d2r;
   xw->rad36 = 36.0 * xw->d2r;
   xw->rad45 = 45.0 * xw->d2r;
   xw->rad54 = 54.0 * xw->d2r;
   xw->rad60 = 60.0 * xw->d2r;
   xw->rad72 = 72.0 * xw->d2r;
   xw->rad90 = 90.0 * xw->d2r;
   xw->rad108 = 108.0 * xw->d2r;
   xw->rad120 = 120.0 * xw->d2r;
   xw->rad144 = 144.0 * xw->d2r;
   xw->rad180 = 180.0 * xw->d2r;
   xw->rad216 = 216.0 * xw->d2r;
   xw->rad240 = 240.0 * xw->d2r;
   xw->rad252 = 252.0 * xw->d2r;
   xw->rad270 = 270.0 * xw->d2r;
   xw->rad288 = 288.0 * xw->d2r;
   xw->rad324 = 324.0 * xw->d2r;
   xw->rad360 = 360.0 * xw->d2r;
   xw->sin72 = sin(72.0 * xw->d2r);
   xw->cos36 = cos(36.0 * xw->d2r);
   xw->cos72 = cos(72.0 * xw->d2r);
   p = (int *) xw->lencount;
   q = (int *) p + TOTSTRUTS;
   while (p < q) *p++ = 0;
   a = (double *) xw->lenlst;
   b = (double *) a + TOTSTRUTS;
   while (a < b) *a++ = 1.0e32;
   xw->totstrut = xw->maxstrut = 0;
   xw->minlen = 999999999.0;
   xw->maxlen = -999999999.0;
   xw->sumlen = xw->sumlensqd = 0.0;
   bld(xw);
   } /* domemain */
