/* c2t_east.c Version 0.3.2. Class II Tetrahedron */
/* East Side Triangle */
/* Copyright (C) 2004-2005  dondalah@ripco.com (Dondalah) */

/* Xdome is free software; you can redistribute it and/or */
/* modify it under the terms of the GNU General Public License */
/* as published by the Free Software Foundation; either version 2 */
/* of the License, or (at your option) any later version. */

/* Xdome is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the */
/* GNU General Public License for more details. */

/* You should have received a copy of the GNU General Public License */
/* along with this program; if not, write to: */

/*       Free Software Foundation, Inc. */
/*       51 Franklin St, Fifth Floor    */
/*       Boston, MA  02110-1301, USA   */

/*									*/
/*      C2T_EAST: class II tetrahedron, east side triangle              */
/*									*/

#include "strlen.h"

void c2t_east(xwfmt *xw)
   {
   int nodefrom,nodeto;
   int exx1,wyy1,zee1;
   int exx2,wyy2,zee2;
   double phi,theta;
   double newphi,newtheta;
   double phi1,theta1,phi2,theta2;
   double phimed,thetamed;
   double diff;
   double prod1,prod2,prod3; 
   double dvsr,quotient;
   int *vtxfromptr;
   int *vtxtoptr;
   int *vtxendptr;
   double *philstptr;
   double *thetalstptr;
   double *philowptr;
   double *thetalowptr;
   double *phiendptr;
   vtxfromptr  = xw->vtxfrom;
   vtxtoptr    = xw->vtxto;
   philstptr   = xw->philst;
   phiendptr   = xw->philst + xw->totnode;
   thetalstptr = xw->thetalst;
   philowptr   = xw->philow;
   thetalowptr = xw->thetalow;
   /* phimed and thetamed x=3 y=3 z=0 */
   phimed   = xw->rad60;
   thetamed = acos(sqrt(3.0) / 3.0);
   while (philstptr < phiendptr)
      {
      phi   = (*philstptr++) - xw->rad120;
      theta = *thetalstptr++;
      diff = phimed - phi;
      prod1 = cos(thetamed + thetamed) * cos(theta);     
      prod2 = sin(thetamed + thetamed)                   
         * sin(theta) * cos(diff);                      
      newtheta = acos(prod1 + prod2);
      prod3 = sin(theta) * sin(diff);
      dvsr = sin(newtheta);
      if (dvsr == 0.0)
         {
         quotient = 1.0;
         } /* divide by zero */
      else quotient = prod3 / dvsr;
      if (quotient > 1.0) quotient = 1.0;
      else if (quotient < -1.0) quotient = -1.0;
      newphi = asin(quotient);
      *philowptr++   = newphi;
      *thetalowptr++ = newtheta;
      } /* for each vertex */
   vtxfromptr  = xw->vtxfrom;
   vtxtoptr    = xw->vtxto;
   vtxendptr   = xw->vtxfrom + xw->totvtx;
   printf("Side triangles, east\n");
   while (vtxfromptr < vtxendptr)
      {
      nodefrom = *vtxfromptr++;
      nodeto   = *vtxtoptr++;
      phi1   = *(xw->philow+nodefrom);
      theta1 = *(xw->thetalow+nodefrom);
      phi2   = *(xw->philow+nodeto);
      theta2 = *(xw->thetalow+nodeto);
      exx1   = *(xw->xlst+nodefrom);
      wyy1   = *(xw->ylst+nodefrom);
      zee1   = *(xw->zlst+nodefrom);
      exx2   = *(xw->xlst+nodeto);
      wyy2   = *(xw->ylst+nodeto);
      zee2   = *(xw->zlst+nodeto);
      putlen(xw,nodefrom,nodeto,
         exx1,wyy1,zee1,
         exx2,wyy2,zee2,
         phi1+xw->rad60,theta1,
         phi2+xw->rad60,theta2);
      putlen(xw,nodefrom,nodeto,
         exx1,wyy1,zee1,
         exx2,wyy2,zee2,
         phi1+xw->rad60+xw->rad120,theta1,
         phi2+xw->rad60+xw->rad120,theta2);
      putlen(xw,nodefrom,nodeto,
         exx1,wyy1,zee1,
         exx2,wyy2,zee2,
         phi1+xw->rad60+xw->rad240,theta1,
         phi2+xw->rad60+xw->rad240,theta2);
      } /* for each node */
   } /* c2t_east */
