#!/usr/bin/perl

#
# StarChart installation script.
#

$CP = "/bin/cp" ;

$DOC_SRC = "starchartX.hlp" ;
$DOC_TGT = $DOC_SRC ;
$DOC_DIR = "/usr/doc/starchart" ;

$EXE_SRC = "starchart" ;
$EXE_TGT = $EXE_SRC ;
$EXE_DIR = "/usr/local/bin" ;

$APP_SRC = "Starchart.app-defaults" ;
$APP_TGT = "Starchart" ;
$APP_DIR = "/usr/lib/X11/app-defaults" ;

$MAN_SRC = "starchart.1" ;
$MAN_TGT = $MAN_SRC ;
$MAN_DIR = "/usr/man/man1" ;

################################################################################
################################################################################

print STDOUT "\nThanks for choosing StarChart from StarWorx Software!\n";
print STDOUT "Please confirm the following choices for installation of \n" ;
print STDOUT "the StarChart system:\n\n";

inloop: do {

    print STDOUT "Executable Location [$EXE_DIR] : ";
    chop ($choice = <>) ;
    $EXE_DIR = $choice if (length $choice) ;
    &checkdir($EXE_DIR) ;
    #print STDOUT "\n" ;

    print STDOUT "StarChart Help File Location [$DOC_DIR] : ";
    chop ($choice = <>) ;
    $DOC_DIR = $choice if (length $choice) ;
    &checkdir($DOC_DIR) ;
    #print STDOUT "\n" ;

    print STDOUT "X Application Defaults Directory [$APP_DIR] : ";
    chop ($choice = <>) ;
    $APP_DIR = $choice if (length $choice) ;
    &checkdir($APP_DIR) ;
    #print STDOUT "\n" ;

    print STDOUT "Man Page Location [$MAN_DIR] : ";
    chop ($choice = <>) ;
    $MAN_DIR = $choice if (length $choice) ;
    &checkdir($MAN_DIR) ;
    print STDOUT "\n" ;

    print STDOUT "Please confirm your choices :\n" ;
    print STDOUT "\tExecutable Location   : $EXE_DIR\n" ;
    print STDOUT "\tHelp File Location    : $DOC_DIR\n" ;
    print STDOUT "\tApp Defaults Location : $APP_DIR\n" ;
    print STDOUT "\tMan Page Location     : $MAN_DIR\n" ;
    print STDOUT "\n" ;
    print STDOUT "Is this correct? Y/Q/[N] : ";
    chop($choice = <>) ;
    print STDOUT "\n\n\n" ;

    if ($choice =~ /[qQ]/) {
	#last inloop ;
	goto out;
	}

    } while (!($choice =~ /[Yy]/)) ;

out:

    if (!($choice =~ /[Yy]/)) {
	print STDOUT "...exiting.\n" ;
	exit 1 ;
	}

    print STDOUT "Installing executable $EXE_SRC to $EXE_DIR/$EXE_TGT\n" ;
    if (!-d $EXE_DIR) {
	&mkpath($EXE_DIR);
	}
    if ($err=system("$CP $EXE_TGT $EXE_DIR/$EXE_TGT")) {
	$! = $err/256 ;
	print STDERR "ERROR: $CP failure; $!\n";
	exit 2 ;
	}

    print STDOUT "Installing documentation $DOC_SRC to $DOC_DIR/$DOC_TGT\n" ;
    if (!-d $DOC_DIR) {
	&mkpath($DOC_DIR);
	}
    if ($err=system("$CP $DOC_TGT $DOC_DIR/$DOC_TGT")) {
	$! = $err/256 ;
	print STDERR "ERROR: $CP failure; $!\n";
	exit 2 ;
	}

    print STDOUT "Installing app-defaults $APP_SRC to $APP_DIR/$APP_TGT\n" ;
    if (!-d $APP_DIR) {
	&mkpath($APP_DIR);
	}
    if ($err=system("$CP $APP_SRC $APP_DIR/$APP_TGT")) {
	$! = $err/256 ;
	print STDERR "ERROR: $CP failure; $!\n";
	exit 2 ;
	}


    print STDOUT "Installing man page $MAN_SRC to $MAN_DIR/$MAN_TGT\n" ;
    if (!-d $MAN_DIR) {
	&mkpath($MAN_DIR);
	}
    if ($err=system("$CP $MAN_TGT $MAN_DIR/$MAN_TGT")) {
	$! = $err/256 ;
	print STDERR "ERROR: $CP failure; $!\n";
	exit 2 ;
	}

    &summary();

    print STDOUT "Would you care to view the README? [Y]/N ";
    chop($choice = <>) ;
    if (!($choice =~ /[Nn]/)) {
	$pager = $ENV{'PAGER'} ;
	$pager = "/bin/more" if !$pager ;
	system("$pager README") ;
	}

    exit 0 ;


sub checkdir {

    ($dir) = @_ ;

    if (!-d $dir) {
	print STDERR "Warning: Directory $dir Does Not Exist.\n";
	print STDERR "         This directory will be created\n" ;
	print STDERR "         if you continue with the installation.\n" ;
	print STDERR "\n" ;
	return 1 ;
	}

    return 0 ;

    }    

sub mkpath {
    ($dir) = @_ ;

    @entries = split('\/', $dir) ;
    $path = '/' ;
    for ($i=1; $i < @entries; $i++) {
	$path .= $entries[$i] ;
	if (!-e "$path") {
	    if (!mkdir($path, 0755)) {
		print STDERR "ERROR: Creating path $path; $!\n" ;
		exit 9;
		}
	    print STDERR "Create $path\n" ;
	    }
	$path .= '/' ;
	}

    return 0 ;
    }


sub summary {

    print STDOUT "\n" ;
    print STDOUT "Thanks again for choosing StarChart.\n" ;
    print STDOUT "For questions, or to register your copy of StarChart,\n" ;
    print STDOUT "please send e-mail to macphee@airmail.net.\n\n" ;
    print STDOUT "Your USD \$25 registration can be paid by sending check\n" ;
    print STDOUT "or money order to:\n" ;
    print STDOUT "\tStarWorx Software\n";
    print STDOUT "\tc/o Scott C. Mac Phee\n" ;
    print STDOUT "\t7608 Clark Springs\n" ;
    print STDOUT "\tPlano, TX 75025\n" ;
    print STDOUT "\tUSA\n\n" ;
    print STDOUT "In return, StarWorx will provide you with the fully\n";
    print STDOUT "functional current release of StarChart and provide\n";
    print STDOUT "e-mail support via the 'FeedBack' utility provided\n" ;
    print STDOUT "with StarChart.\n" ;
    print STDOUT "\n" ;

    return 0 ;

    }
