/*
 * sortdemo.c
 *
 * sortdemo - version 0.2
 *
 * Anuradha Ratnaweera
 *
 * Dept. of Computer Sciences
 * Faculty of Engineering
 * University of Peradeniya
 * Peradeniya 20400
 * Sri Lanka
 *
 * anuradha@cs.pdn.ac.lk
 *
 * http://www.lklug.pdn.ac.lk/software/sortdemo/
 *
 * 06 April 2000
 *
 */

#include "sortdemo.h"
#include "config.h"

int main(int argc, char *argv[])
{
  int a[N];
  int sorttype;
  int listtype;
  int n;
  
  /* check for 3 command line arguments */

  if (argc < 4){
    syntax();
    return 1;
  }

  /* determine the sort type from the first argument */
  
  if ((strncmp(argv[1], "q", 1) == 0) ||
      (strncmp(argv[1], "quick", 5) == 0))
    sorttype = QUICK;
  else if ((strncmp(argv[1], "b1", 2) == 0) || 
           (strncmp(argv[1], "bubble1", 7) == 0))
    sorttype = BUBBLE1;
  else if ((strncmp(argv[1], "b2", 2) == 0) ||
           (strncmp(argv[1], "bubble2", 7) == 0))
    sorttype = BUBBLE2;
  else if ((strncmp(argv[1], "b3", 2) == 0) ||
           (strncmp(argv[1], "bubble3", 7) == 0))
    sorttype = BUBBLE3;
  else if ((strncmp(argv[1], "b4", 2) == 0) ||
           (strncmp(argv[1], "bubble4", 7) == 0))
    sorttype = BUBBLE4;
  else if ((strncmp(argv[1], "s", 1) == 0) ||
           (strncmp(argv[1], "selection", 9) == 0))
    sorttype = SELECTION;
  else if ((strncmp(argv[1], "i", 1) == 0) ||
           (strncmp(argv[1], "insertion", 9) == 0))
    sorttype = INSERTION;
  else{
    fprintf(stderr, "\nIllegal sort type\n");
    syntax();
    return 2;
  }

  /* determine the nature of the list from the second argument */

  if ((strncmp(argv[2], "s", 1) == 0) ||
      (strncmp(argv[2], "sorted", 6) == 0))
    listtype = SORTED;
  else if ((strncmp(argv[2], "re", 2) == 0) ||
           (strncmp(argv[2], "reverse", 7) == 0))
    listtype = REVERSE;
  else if ((strncmp(argv[2], "ra", 2) == 0) ||
           (strncmp(argv[2], "random", 6) == 0))
    listtype = RANDOM;
  else if ((strncmp(argv[2], "as", 2) == 0) ||
           (strncmp(argv[2], "almost-sorted", 13) == 0))
    listtype = ALMOSTSORTED;
  else if ((strncmp(argv[2], "ar", 2) == 0) ||
           (strncmp(argv[2], "almost-reverse", 14) == 0))
    listtype = ALMOSTREVERSE;
  else{
    fprintf(stderr, "\nIllegal data type\n");
    syntax();
    return 2;
  }

  /* set the size of the array from the third argument */

  n = atoi(argv[3]);
  if (n <= 0){
    fprintf(stderr, "\nThe array size should be greater than zero\n\n");
    return 3;
  }
  else if (n > N){
    fprintf(stderr, "\nThe array size should not be greater than %d\n\n", N);
    return 3;
  }

  /* initialize the list */

  initlist(a, listtype, n);

  /* write the unsorted list to a file for verifying the sort */

  writetofile(UNSORTEDFILE, a, n);

  /* call the sorting routine */

  switch (sorttype){
    case QUICK:
      qs(a, n);
      break;
    case BUBBLE1:
      bubble1sort(a, n);
      break;
    case BUBBLE2:
      bubble2sort(a, n);
      break;
    case BUBBLE3:
      bubble3sort(a, n);
      break;
    case BUBBLE4:
      bubble4sort(a, n);
      break;
    case SELECTION:
      selectionsort(a, n);
      break;
    case INSERTION:
      insertionsort(a, n);
      break;
  }

  /* write the sorted list to a file for verifying the sort */

  writetofile(SORTEDFILE, a, n);

  return 0;
}

void syntax()
/* prints the syntax of the program */
{
  fprintf(stderr, "\n");
  fprintf(stderr, "usage: %s type data size\n", PROGNAME);
  fprintf(stderr, "\n");
  fprintf(stderr, "type:\n");
  fprintf(stderr, "  s, selection        selection sort\n");
  fprintf(stderr, "  i, insertion        insertion sort\n");
  fprintf(stderr, "  b1, bubble1         bubble sort\n");
  fprintf(stderr, "  b2, bubble2         bubble sort with a flag\n");
  fprintf(stderr, "  b3, bubble3         two way bubble sort (shaker sort) with a flag\n");
  fprintf(stderr, "  b4, bubble4         enhanced two way bubble sort with a flag\n");
  fprintf(stderr, "  q, quick            quick sort\n");
  fprintf(stderr, "\n");

  fprintf(stderr, "data:\n");
  fprintf(stderr, "  s, sorted           sorted\n");
  fprintf(stderr, "  re, reverse         reverse\n");
  fprintf(stderr, "  ra, random          random\n");
  fprintf(stderr, "  as, almost-sorted   almost sorted\n");
  fprintf(stderr, "  ar, almost-reverse  almost reverse\n");
  fprintf(stderr, "\n");
  fprintf(stderr, "size:\n");
  fprintf(stderr, "  size of the list\n");
  fprintf(stderr, "\n");
}

void initlist(int *a, int type, int n)
/* initializes the list */
/* Use of random number generator is not done in the best possible   */
/* way. See numerical recipes in C - for more details.  However, for */
/* the lists generated in this program, this is not a big issue.     */
{
  int i, i1, i2, tmp;

  srand((unsigned int)time(NULL));

  switch (type) {
    case SORTED:
    case ALMOSTSORTED:
      for (i = 0; i < n; i++)
	a[i] = i + DATAMIN;
      if (type == SORTED) break;
      for (i = 1; i <= OFFITEMS; i++){
	i1 = rand() % n;
	i2 = i1;
	while (i1 == i2) i2 = rand() % n;
        SWAP(a[i1], a[i2])
      }
      break;
    case REVERSE:
    case ALMOSTREVERSE:
      for (i = 0; i < n; i++)
	a[i] = n - i + DATAMIN - 1;
      if (type == REVERSE) break;
      for (i = 1; i <= OFFITEMS; i++){
	i1 = rand() % n;
	i2 = i1;
	while (i1 == i2) i2 = rand() % n;
        SWAP(a[i1], a[i2])
      }
      break;
    case RANDOM:
      for (i = 0; i < n; i++)
	a[i] = rand() % (DATAMAX - DATAMIN) + DATAMIN;
      break;
  }
}

void writeimage(int *a, int n, int n1, int n2, int n3, int n4, int swapping)
/* writes the current list to a image file graphically and increases the  */
/* image counter. The items n1 and n2 are given special colours depending */
/* on the flag swapping. If n1 and n2 are being swapped this flag is      */
/* nonzero and if they are being tested or about to swap it is zero.      */
/* Also the items outside n3 and n4 are coloured differently - used to    */
/* de-highlight the items not in the current list in the quick sort.      */
/* Also this feature is used to show the shifting of the part of the list */
/* in the insertion sort                                                  */
/* If the file cannot be opened, the routine returns without writing      */
{
  FILE *imagefile;
  static int imgcount = 0;
  char fname[20];
  int i, ii, j;
  gdImagePtr img;
  int bgcolor, color, workcolor, swapcolor, outcolor, col;

  img = gdImageCreate(n * BARSTEP + 1, IMAGEHEIGHT);
  bgcolor = gdImageColorAllocate(img, 210, 210, 255);
  color = gdImageColorAllocate(img, 0, 0, 0);
  workcolor = gdImageColorAllocate(img, 50, 150, 50);
  swapcolor = gdImageColorAllocate(img, 200, 50, 50);
  outcolor = gdImageColorAllocate(img, 160, 160, 160);

  for (i = 0; i < n; i++){
    if ((i == n1) || (i == n2)){
      if (swapping){
	col = swapcolor;
      }
      else{
	col = workcolor;
      }
    }
    else{
      if ((i >= n3) && (i <= n4)){
	col = color;
      }
      else{
        col = outcolor;
      }
    }
    ii = i * BARSTEP;
    gdImageFilledRectangle(img, ii + 1, IMAGEHEIGHT - MARGIN - a[i],
		                   ii + BARSTEP - 1, IMAGEHEIGHT - MARGIN, col);
  }

#ifdef HAVE_GDIMAGEGIF
  sprintf(fname, "sort%05d.gif", imgcount);
#else
  sprintf(fname, "sort%05d.png", imgcount);
#endif

  if ((imagefile = fopen(fname, "wb")) == NULL){
    gdImageDestroy(img);
    return;
  }

#ifdef HAVE_GDIMAGEGIF
  gdImageGif(img, imagefile);
#else
  gdImagePng(img, imagefile);
#endif

  fclose(imagefile);
  gdImageDestroy(img);
  
  imgcount++;
}

void qs(int a[], int n)
/* The quick sort routine */
{
  /* call the recursive sort routine on the whole array */
  quicksort(a, 0, n - 1, n);
}

void quicksort(int a[], int n1, int n2, int n)
/* recursive quick sort routine */
{
  int i, last, tmp;
  
  if (n1 >= n2) return;

  /* select the middle item and move it to the beginning */
  SWAP(a[n1], a[(n1+n2)/2])
  last = n1;
  for (i = n1 + 1; i <= n2; i++){
    writeimage(a, n, i, last, n1, n2, 0);
    if (a[i] < a[last]){
      SWAP(a[last], a[i])
      writeimage(a, n, last, i, n1, n2, 1);
      if (i != last+1){
        SWAP(a[i], a[last+1])
        writeimage(a, n, i, last+1, n1, n2, 1);
      }
      last++;
    }
  }

  /* now the selected item is the position "last" */
  /* all the items to the left of it are smaller and to the right */
  /* are larger, so we sort the two sub-lists seperately */

  quicksort(a, n1, last - 1, n);
  quicksort(a, last + 1, n2, n);
}

void bubble1sort(int a[], int n)
/* bubble sort - the most premitive */
{
  int i, j, jj, tmp;

  for (i = n - 1; i >= 0; i--){
    for (j = 0, jj = 1; j < i; j++, jj++){
      writeimage(a, n, j, jj, 0, n, 0);
      if (a[j] > a[jj]){
	SWAP(a[j], a[jj])
        writeimage(a, n, j, jj, 0, n, 1);
      }
    }
  }
}

void bubble2sort(int a[], int n)
/* bubble sort with a flag */
{
  int i, j, jj, tmp, sorted = 0;

  for (i = n - 1; (i >= 0) && (sorted == 0); i--){
    sorted = 1;
    for (j = 0, jj = 1; j < i; j++, jj++){
      writeimage(a, n, j, jj, 0, n, 0);
      if (a[j] > a[jj]){
	sorted = 0;
	SWAP(a[j], a[jj])
        writeimage(a, n, j, jj, 0, n, 1);
      }
    }
  }
}

void bubble3sort(int a[], int n)
/* two way bubble sort with flag (shake sort) */
{
  int i1 = 0, i2 = n - 1, i, ii, tmp, sorted = 0, count = 1;

  while (sorted == 0) {
    sorted = 1;
    if (count % 2){
      for (i = i1, ii = i1 + 1; i < i2; i++, ii++){
        writeimage(a, n, i, ii, 0, n, 0);
        if (a[i] > a[ii]){
	  sorted = 0;
	  SWAP(a[i], a[ii])
          writeimage(a, n, i, ii, 0, n, 1);
	}
      }
      i2--;
    }
    else{
      for (i = i2 - 1, ii = i2; i >= i1; i--, ii--){
        writeimage(a, n, i, ii, 0, n, 0);
        if (a[i] > a[ii]){
	  sorted = 0;
	  SWAP(a[i], a[ii])
          writeimage(a, n, i, ii, 0, n, 1);
	}
      }
      i1++;
    }
    count++;
  }
}

void bubble4sort(int a[], int n)
/* enhanced two way bubble sort with flag (shake sort) */
{
  int i1 = 0, i2 = n - 2, i, ii, tmp, sorted = 0, count = 1, ifirst, ilast;

  while (sorted == 0) {
    sorted = 1;
    if (count % 2){
      ilast = i1;
      for (i = i1, ii = i1 + 1; i <= i2; i++, ii++){
        writeimage(a, n, i, ii, 0, n, 0);
        if (a[i] > a[ii]){
          ilast = i;
	  sorted = 0;
	  SWAP(a[i], a[ii])
          writeimage(a, n, i, ii, 0, n, 1);
	}
      }
      i2 = ilast - 1;
    }
    else{
      ifirst = i2;
      for (i = i2, ii = i2 + 1; i >= i1; i--, ii--){
        writeimage(a, n, i, ii, 0, n, 0);
        if (a[i] > a[ii]){
	  ifirst = i;
	  sorted = 0;
	  SWAP(a[i], a[ii])
          writeimage(a, n, i, ii, 0, n, 1);
	}
      }
      i1 = ifirst + 1;;
    }
    count++;
  }
}

void insertionsort(int a[], int n)
/* straight insertion sort */
{
  int i, j, k;
  int tmp;

  for (i = 1; i < n; i++){
    j = i - 1;
    while ((a[j] > a[i]) && (j >= 0)){
      writeimage(a, n, i, j, 0, n, 0);
      j--;
    }
    j++;
    if (i != j){
      writeimage(a, n, i, i, j, i, 0);
      for (k = i - 1; k >= j; k--){
	SWAP(a[k], a[k + 1])
      }
      writeimage(a, n, j, j, j, i, 1);
    }
  }
}

void selectionsort(int a[], int n)
/* straight selection sort */
{
  int i, j, k;
  int tmp;

  for (i = 0; i < n; i++) {
    k = i;
    for (j = i + 1; j < n; j++) {
      writeimage(a, n, j, k, 0, n, 0);
      if (a[j] < a[k]) {
        k = j;
      }
    }
    if (i != k){
      writeimage(a, n, i, k, 0, n, 0);
      SWAP(a[i], a[k])
      writeimage(a, n, i, k, 0, n, 1);
    }
  }
}

int writetofile(char* fname, int *a, int n)
/* write the current list to the file given by fname */
{
  int i;
  FILE *outfile;

  outfile = fopen(fname, "wt");
  for (i = 0; i < n; i++){
    fprintf(outfile, "%d\n", a[i]);
  }
  fclose(outfile);
  
  return 0;
}
