/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __SG_WORKSHEET_H__
#define __SG_WORKSHEET_H__

typedef struct _SGworksheet SGworksheet;
typedef struct _SGcolumn SGcolumn;
typedef struct _SGhiddencell SGhiddencell;
typedef union _SGcellvalue SGcellvalue;

typedef enum
{
  SG_TYPE_NUMBER,
  SG_TYPE_TEXT,
  SG_TYPE_DATE,
  SG_TYPE_TIME,

} SGcolumntype;

typedef enum
{
  SG_FORMAT_DECIMAL,
  SG_FORMAT_SCIENTIFIC,
} SGcolumnformat;

typedef enum
{
  SG_INTERNAL_INTEGER,
  SG_INTERNAL_DOUBLE,
} SGcolumninternal;


union _SGcellvalue {
   glong val_long;
   gdouble val_double;
   gfloat val_float;
   gchar *val_char; /* No need for three different char * types */
};



struct _SGcolumn
{
  SGcolumntype type;
  SGcolumnformat format;
  SGcolumninternal internal;

  gint precision;

  gchar *exp;
};

struct _SGhiddencell
{
  gchar *formula;
  gboolean updated;

  SGcellvalue value;

  SGcolumntype type;
  SGcolumnformat format;
  SGcolumninternal internal;
  gint precision;
};


struct _SGworksheet 
{
  gchar *name, *cell_save;
  gint last_column;
  gint x, y, width, height;

  gint begin, end;

  gboolean is_mapped;

  GtkWidget *sheet;
  GtkWidget *sw;
  GtkWidget *window;
  GtkWidget *label;
  GtkIconList *iconlist;
  GtkIconListItem *icon;

  SGcolumn *column;
};

SGworksheet 	*sg_worksheet_new		(gchar *name, 
                                                 gint nrows, gint ncols);

void		sg_worksheet_open		(SGworksheet *worksheet); 
void		sg_worksheet_hide		(SGworksheet *worksheet); 
gint 		sg_worksheet_rename		(SGworksheet *worksheet,
						 gchar *name); 
void		sg_worksheet_set_begin		(SGworksheet *worksheet,
						 gint row); 
void		sg_worksheet_set_end		(SGworksheet *worksheet,
						 gint row); 
void		sg_worksheet_reset		(SGworksheet *worksheet);
void		sg_worksheet_remove		(SGworksheet *worksheet);
void		sg_worksheet_set_column_name	(SGworksheet *worksheet,
						 gint column,
						 gchar *text);
void		sg_worksheet_add_columns	(SGworksheet *worksheet,
						 gint n);
void		sg_worksheet_add_rows		(SGworksheet *worksheet,
						 gint n);
void		sg_worksheet_insert_columns	(SGworksheet *worksheet,
						 gint col,
						 gint n);
void		sg_worksheet_insert_rows	(SGworksheet *worksheet,
						 gint row,
						 gint n);
void		sg_worksheet_delete_columns	(SGworksheet *worksheet,
						 gint col,
						 gint n);
void		sg_worksheet_delete_rows	(SGworksheet *worksheet,
						 gint row,
						 gint n);
gint 		sg_worksheet_get_column		(SGworksheet *worksheet,
						 gchar *col_name);
void 		sg_worksheet_column_set_format	(SGworksheet *worksheet,
                               			 gint column, 
                               			 SGcolumntype type,
                               			 SGcolumnformat format,
                               			 SGcolumninternal internal,
                               			 gint precision);
void 		sg_worksheet_column_set_exp	(SGworksheet *worksheet,
                               			 gint column, 
                               			 gchar *exp); 
void            sg_worksheet_cell_clear       (SGworksheet *worksheet, 
                                               gint row, gint col);

void 		sg_worksheet_cell_set		(SGworksheet *worksheet,
						 gint row, gint col, 
                                                 gchar *text,
                                                 gboolean formula,
                                                 gboolean eval);

char            *sg_worksheet_cell_get_text     (SGworksheet *worksheet,
                                                 gint row, gint col);
void            sg_worksheet_cell_set_text	  (SGworksheet *worksheet, 
                                                gint row, gint col,gchar *text);

char            *sg_worksheet_cell_get_formula  (SGworksheet *worksheet,
                                                 gint row, gint col);
double 		sg_worksheet_cell_get_double    (SGworksheet *worksheet,
                                                 gint row, gint col, 
						 gboolean *error);
gint 		sg_worksheet_cell_get_int       (SGworksheet *worksheet,
                                                 gint row, gint col, 
						 gboolean *error);
gboolean	sg_worksheet_cell_update_format(SGworksheet *worksheet,
						 gint row, gint col);
void 		sg_worksheet_update_column_exp 	(SGworksheet *worksheet,
                                      		 gchar *exp, gint column,
                                       		 gint from, gint to);
gint            sg_worksheet_unupdate_all      (SGworksheet *worksheet);
gint            sg_worksheet_unupdate_exp_range(SGworksheet *worksheet, 
                                              gint row0, gint rowi,
                                              gint col0, gint coli);

gint            sg_worksheet_update_exp_all  (SGworksheet *worksheet);
gint            sg_worksheet_update_exp_range(SGworksheet *worksheet, 
                                              gint row0, gint rowi,
                                              gint col0, gint coli);




#endif /* __SG_WORKSHEET_H__ */

