/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdlib.h>
#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>
#include "main.h"
#include <Python.h>
#include "python/python_main.h"


void label_pos_apply(GtkWidget *widget);
void label_pos_init(GtkWidget *widget);

void label_width_apply(GtkWidget *widget);
void label_width_init(GtkWidget *widget);

void autosave_apply(GtkWidget *widget);
void autosave_init(GtkWidget *widget);

void compress_apply(GtkWidget *widget);
void compress_init(GtkWidget *widget);



static gchar *label_pos[] = {"Right",
                             "Bottom",
                             NULL
};

sg_menu_info label_pos_info={label_pos,&label_pos_init,&label_pos_apply};
sg_bound_int_info label_width_info={30,120,&label_width_init,&label_width_apply},
                  autosave_info={30,1200,&autosave_init,&autosave_apply},
                  compression_info={0,9,&compress_init,&compress_apply};

sg_config_info gen_var_info[]={
        { DIALOG_SEP,-1,NULL,NULL,"Preferences"},
        { NOTEBOOK_START,-1,NULL,NULL,NULL},
        { PAGE_SEP,-1,NULL,NULL,"Icon lists"},
        { FRAME_START,-1,NULL,NULL,NULL},
        { DICT_MENU,SG_SAFE_SYS_N,(gpointer)&label_pos_info,NULL,"Label position"},
        { DICT_INT_BOUND,SG_SAFE_SYS_N,(gpointer)&label_width_info,NULL,"Label width (pixels)"},
        { PAGE_SEP,-1,NULL,NULL,"Files"},
        { FRAME_START,-1,NULL,NULL,NULL},
        { DICT_INT_BOUND,SG_SAVE_N,(gpointer)&autosave_info,NULL,"Autosave frequency (seconds)"},
        { DICT_INT_BOUND,SG_COMPRESS_N,(gpointer)&compression_info,NULL,"Compression level (0=none, 1=low, .. , 9=high)"},
        { NOTEBOOK_END,-1,NULL,NULL,NULL},
        { END_CONFIG,-1,NULL,NULL,NULL}
};


void label_pos_init(GtkWidget *widget)
{
  gtk_list_select_item(GTK_LIST(GTK_COMBO(widget)->list),
                            sg_canvas_label_pos);

}

void label_pos_apply(GtkWidget *widget)
{
  GtkWidget *child;
  gint mode;


  child = GTK_LIST(GTK_COMBO(widget)->list)->selection->data;
  mode = gtk_list_child_position(GTK_LIST(GTK_COMBO(widget)->list),
                                 child);

  sg_canvas_label_pos=mode;
  PyDict_SetItemString(SG_CANVAS_LABELS_POS, "Pos",PyInt_FromLong ((long) sg_canvas_label_pos));

  gtk_icon_list_freeze(GTK_ICON_LIST(iconlist1));
  gtk_icon_list_set_mode(GTK_ICON_LIST(iconlist1), mode + 1);
  gtk_icon_list_thaw(GTK_ICON_LIST(iconlist1));
  gtk_icon_list_freeze(GTK_ICON_LIST(iconlist2));
  gtk_icon_list_set_mode(GTK_ICON_LIST(iconlist2), mode + 1);
  gtk_icon_list_thaw(GTK_ICON_LIST(iconlist2));

}

void label_width_init(GtkWidget *widget)
{
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(widget),
                            sg_canvas_label_width);
}

void label_width_apply(GtkWidget *widget)
{
  gint space;

  space = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(widget));
  sg_canvas_label_width = space;
  PyDict_SetItemString(SG_CANVAS_LABELS_WIDTH, "Width",PyInt_FromLong ((long) sg_canvas_label_width));

  gtk_icon_list_freeze(GTK_ICON_LIST(iconlist1));
  gtk_icon_list_set_text_space(GTK_ICON_LIST(iconlist1), space);
  gtk_icon_list_thaw(GTK_ICON_LIST(iconlist1));

  gtk_icon_list_freeze(GTK_ICON_LIST(iconlist2));
  gtk_icon_list_set_text_space(GTK_ICON_LIST(iconlist2), space);
  gtk_icon_list_thaw(GTK_ICON_LIST(iconlist2));

}

void autosave_init(GtkWidget *widget)
{
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(widget),
                            sg_autosave_int);
}

void autosave_apply(GtkWidget *widget)
{
  gint seconds;

  seconds = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(widget));
  sg_autosave_int = seconds;
  PyDict_SetItemString(SG_SAVE, "Int",PyInt_FromLong ((long) sg_autosave_int));

}

void compress_init(GtkWidget *widget)
{
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(widget),
                            sg_compress_level);
}


void compress_apply(GtkWidget *widget)
{
  gint level;

  level = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(widget));
  sg_compress_level = level;
  PyDict_SetItemString(SG_COMPRESS, "Level",PyInt_FromLong ((long) sg_compress_level));

}


void general_config_dialog(GtkWidget *widget, gpointer data)
{
    sg_create_config_dialog(gen_var_info, &config_apply, &config_ok);
}

