/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <math.h>
#include <stdio.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>
#include "main.h"
#include "sg_text_dialog.h"

static gpointer sg_menu_fit_page		(SGplugin *plugin);
static gpointer sg_menu_fit_page_h		(SGplugin *plugin);
static gpointer sg_menu_fit_page_v		(SGplugin *plugin);
static gpointer sg_menu_export			(SGplugin *plugin);
static gpointer sg_menu_import			(SGplugin *plugin);
static gpointer sg_menu_new_layer		(SGplugin *plugin);
static gpointer sg_menu_new_layer_3d		(SGplugin *plugin);
static gpointer sg_menu_new_layer_polar		(SGplugin *plugin);
static gpointer sg_menu_remove_layer		(SGplugin *plugin);
static gpointer sg_menu_arrange			(SGplugin *plugin);
static gpointer sg_menu_layer_control		(SGplugin *plugin);
static gpointer sg_menu_copy_page		(SGplugin *plugin);
static gpointer sg_menu_paste			(SGplugin *plugin);
static gpointer sg_menu_image			(SGplugin *plugin);

void
sg_plot_menu_show(GtkWidget *widget, GdkEventButton *event)
{
  GList *w;
  SGplot *plot = NULL;
  GtkWidget *data;
  GdkModifierType mods;

  w = plots;
  while(w){
    plot = (SGplot *)w->data;
    data = plot->real_canvas;
    if(data && data == widget) break;
    w = w->next;
  }

  active_plot = plot;

  gdk_window_get_pointer(widget->window, NULL, NULL, &mods);
  if(!(mods & GDK_BUTTON3_MASK)) return;

  gtk_menu_popup(GTK_MENU(plot_menu), NULL, NULL, NULL, NULL,
                 event->button, event->time);
}

void
sg_plot_build_menu()
{
  /* FILE */

  sg_plugin_group_new("Plot:File:");
  sg_plugin_new_c("Export", "Plot:File:", sg_menu_export);
  sg_plugin_new_c("Import", "Plot:File:", sg_menu_import);

  /* EDIT */

  sg_plugin_group_new("Plot:Edit:");
  sg_plugin_new_c("Copy page", "Plot:Edit:", sg_menu_copy_page);
  sg_plugin_new_c("Paste", "Plot:Edit:", sg_menu_paste);

  /* LAYER */

  sg_plugin_group_new("Plot:Layer:");
  sg_plugin_group_new("Plot:Layer:New layer:");
  sg_plugin_new_c("2D", "Plot:Layer:New layer:", sg_menu_new_layer);
  sg_plugin_new_c("3D", "Plot:Layer:New layer:", sg_menu_new_layer_3d);
  sg_plugin_new_c("Polar", "Plot:Layer:New layer:", sg_menu_new_layer_polar);
  sg_plugin_new_c("Remove layer", "Plot:Layer:", sg_menu_remove_layer);
  sg_plugin_new_c("Layer control", "Plot:Layer:", sg_menu_layer_control);

  /* PAGE */

  sg_plugin_group_new("Plot:Page:");
  sg_plugin_new_c("Show whole page", "Plot:Page:", sg_menu_fit_page);
  sg_plugin_new_c("Fit page to window width", "Plot:Page:", sg_menu_fit_page_h);
  sg_plugin_new_c("Fit page to window height", "Plot:Page:", sg_menu_fit_page_v);
  sg_plugin_new_c("Arrange all layers", "Plot:Page:", sg_menu_arrange);

  /* INSERT */

  sg_plugin_group_new("Plot:Insert:");
  sg_plugin_new_c("Image from file", "Plot:Insert:", sg_menu_image);

  /* PLUG-INS */

/*
  sg_plugin_group_new("Plot:Plugins:");
*/
}

static gpointer
sg_menu_fit_page(SGplugin *plugin)
{
  sg_plot_fit_page(active_plot);
}

static gpointer
sg_menu_fit_page_h(SGplugin *plugin)
{
  sg_plot_fit_page_h(active_plot);
}

static gpointer
sg_menu_fit_page_v(SGplugin *plugin)
{
  sg_plot_fit_page_v(active_plot);
}


static gpointer
sg_menu_arrange(SGplugin *plugin)
{
  sg_arrange_dialog(GTK_PLOT_CANVAS(active_plot->real_canvas));
}

static gpointer
sg_menu_new_layer(SGplugin *plugin)
{
  SGlayer *layer;

  layer = sg_layer_new(SG_PLOT_2D, .65, .45);
  sg_plot_add_layer(active_plot, layer, .175, .15);

  gtk_plot_canvas_paint(GTK_PLOT_CANVAS(active_plot->real_canvas));
  gtk_plot_canvas_refresh(GTK_PLOT_CANVAS(active_plot->real_canvas));
}

static gpointer
sg_menu_new_layer_3d(SGplugin *plugin)
{
  SGlayer *layer;

  layer = sg_layer_new(SG_PLOT_3D, .65, .45);
  sg_plot_add_layer(active_plot, layer, .175, .15);

  gtk_plot_canvas_paint(GTK_PLOT_CANVAS(active_plot->real_canvas));
  gtk_plot_canvas_refresh(GTK_PLOT_CANVAS(active_plot->real_canvas));
}

static gpointer
sg_menu_new_layer_polar(SGplugin *plugin)
{
  SGlayer *layer;

  layer = sg_layer_new(SG_PLOT_POLAR, .75, .45);
  sg_plot_add_layer(active_plot, layer, .175, .15);

  gtk_plot_canvas_paint(GTK_PLOT_CANVAS(active_plot->real_canvas));
  gtk_plot_canvas_refresh(GTK_PLOT_CANVAS(active_plot->real_canvas));
}

static gpointer
sg_menu_remove_layer(SGplugin *plugin)
{
  SGlayer *layer;

  layer = active_plot->active_layer;

  if(active_plot->nlayers > 1 && sg_accept_dialog("Remove the selected layer?", 1) == YES_CLICKED)
       sg_plot_remove_layer(active_plot, layer);

  sg_plot_set_active_layer(active_plot, (SGlayer *)active_plot->layers->data); 
}

static gpointer
sg_menu_layer_control(SGplugin *plugin)
{
  sg_layer_control(NULL);
}

static gpointer
sg_menu_import(SGplugin *plugin)
{
/*
  sg_message_dialog("Sorry, this feature is not implemented", 2);
*/
  sg_plot_import();
}

static gpointer
sg_menu_export(SGplugin *plugin)
{
  sg_plot_export();
}

static gpointer
sg_menu_copy_page(SGplugin *plugin)
{
  sg_clipboard_copy_pixmap(active_plot);
}

static gpointer
sg_menu_paste(SGplugin *plugin)
{
  sg_clipboard_paste_pixmap(active_plot, 0., 0.);
}

static gpointer
sg_menu_image(SGplugin *plugin)
{
  GdkPixmap *pixmap;

  pixmap = sg_image_import();
  if(pixmap) sg_plot_put_pixmap(active_plot, pixmap);
}
