/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdlib.h>
#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>
#include "../pixmaps/logo.xpm"
#include "main.h"

static guint32 timer;

static gboolean
mw_destroy(GtkWidget *widget)
{
  sg_dialog_kill(widget);

  /* This is needed to get out of gtk_main */
  gtk_main_quit ();

  return FALSE;
}

static gboolean
presentation_destroy(GtkWidget *widget)
{
  gtk_timeout_remove(timer);

  return FALSE;
}


static gboolean
timeout_end(gpointer data)
{
  gtk_timeout_remove(timer);

  gtk_widget_destroy(GTK_WIDGET(data));

  return FALSE;
}


#ifdef WITH_GNOME

const gchar *authors[] = {
  "Adrian E. Feiguin <feiguin@magnet.fsu.edu>",
  "Conrad Steenberg <conrad@hep.caltech.edu>",
  NULL
};


void
sg_about_dialog (GtkWidget *widget, void *data)
 {
    GtkWidget *about;

    about = gnome_about_new ("SciGraphica", VERSION,
                             "(C) 2000 Adrian E. Feiguin",
                             authors,
                             "Scientific Graphics",
			     "sg/logo.xpm");

    gtk_window_set_modal (GTK_WINDOW (about), TRUE);

    gtk_widget_show (about);
 }

#else

void
sg_about_dialog (GtkWidget *widget, gpointer data)
{
  GtkWidget *window;
  GtkWidget *main_box;
  GtkWidget *frame;
  GtkWidget *label;
  GtkWidget *table;
  GtkWidget *tpixmap;
  GtkWidget *ok_button;
  GtkWidget *action_area;
  GdkPixmap *pixmap;
  GdkBitmap *mask;
  GdkColormap *colormap;
  gchar text[1000];

  colormap = gdk_colormap_get_system();

  window=gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_policy(GTK_WINDOW(window), FALSE, FALSE, FALSE);
  gtk_window_set_title (GTK_WINDOW(window), "About SciGraphica");
  gtk_window_set_position (GTK_WINDOW(window), GTK_WIN_POS_CENTER);

  gtk_window_set_modal (GTK_WINDOW(window),TRUE);

  sg_dialog_new(window);


  /* Create widgets */
  main_box = gtk_vbox_new (FALSE,5);
  gtk_container_set_border_width(GTK_CONTAINER(main_box), 10);
  gtk_container_add (GTK_CONTAINER (window), main_box);

  table = gtk_table_new(3, 1, FALSE);
  gtk_table_set_row_spacings(GTK_TABLE(table), 10);
  gtk_table_set_col_spacings(GTK_TABLE(table), 5);
  gtk_box_pack_start (GTK_BOX (main_box), table, FALSE, FALSE, 0);

  frame = gtk_frame_new(NULL);
  gtk_frame_set_shadow_type(GTK_FRAME(frame), GTK_SHADOW_OUT);
  gtk_table_attach_defaults(GTK_TABLE(table), 
                            frame,
                            0, 1, 0, 1);

  pixmap = gdk_pixmap_colormap_create_from_xpm_d(NULL, colormap, &mask, NULL,
                                                 logo_xpm);
  tpixmap = gtk_pixmap_new(pixmap, mask);
  gtk_container_add(GTK_CONTAINER(frame), tpixmap);

  sprintf(text, "SciGraphica-%s\nScientific Graphics\n\n(C) 2000 Adrian E. Feiguin\n\nhttp://scigraphica.sourceforge.net\n\nAuthors\nAdrian E. Feiguin <feiguin@magnet.fsu.edu>\nConrad Steenberg <conrad@srl.caltech.edu>", VERSION);

  label =  gtk_label_new(text);
  gtk_misc_set_alignment(GTK_MISC(label), .5, .5);

  gtk_table_attach_defaults(GTK_TABLE(table), label, 0, 1, 1, 2);

  /* Action Area */
  action_area = gtk_hbutton_box_new ();
  gtk_button_box_set_layout(GTK_BUTTON_BOX(action_area), GTK_BUTTONBOX_SPREAD);
  gtk_button_box_set_spacing(GTK_BUTTON_BOX(action_area), 5);
  gtk_box_pack_end (GTK_BOX (main_box), action_area, FALSE, FALSE, 0);
  gtk_widget_show (action_area);

  ok_button = gtk_button_new_with_label ("Accept");
  GTK_WIDGET_SET_FLAGS (ok_button, GTK_CAN_DEFAULT);
  gtk_box_pack_start (GTK_BOX (action_area), ok_button, TRUE, TRUE, 0);
  gtk_widget_grab_default (ok_button);
  gtk_widget_show (ok_button);

  /* connect signals */
  gtk_signal_connect_object (GTK_OBJECT (ok_button), "clicked",
                             GTK_SIGNAL_FUNC (gtk_widget_destroy),
                             GTK_OBJECT (window));

  gtk_signal_connect (GTK_OBJECT (window), "destroy",
                      GTK_SIGNAL_FUNC (mw_destroy),NULL);

  /* Show widgets */

  gtk_widget_show_all (window);

  /* wait until dialog get destroyed */
  gtk_main();

  return;
}

#endif

void
sg_presentation_dialog ()
{
  GtkWidget *window;
  GtkWidget *main_box;
  GtkWidget *frame;
  GtkWidget *label;
  GtkWidget *table;
  GtkWidget *tpixmap;
  GdkPixmap *pixmap;
  GdkBitmap *mask;
  GdkColormap *colormap;
  gchar text[1000];

  colormap = gdk_colormap_get_system();

  window=gtk_window_new (GTK_WINDOW_POPUP);
  gtk_window_set_policy(GTK_WINDOW(window), FALSE, FALSE, FALSE);
  gtk_window_set_title (GTK_WINDOW(window), "SciGraphica");
  gtk_window_set_position (GTK_WINDOW(window), GTK_WIN_POS_CENTER);

  gtk_window_set_modal (GTK_WINDOW(window),TRUE);

  /* Create widgets */
  frame = gtk_frame_new(NULL);
  gtk_frame_set_shadow_type(GTK_FRAME(frame), GTK_SHADOW_OUT);
  gtk_container_add (GTK_CONTAINER (window), frame);


  main_box = gtk_vbox_new (FALSE,5);
  gtk_container_set_border_width(GTK_CONTAINER(main_box), 5);
  gtk_container_add (GTK_CONTAINER (frame), main_box);

  table = gtk_table_new(3, 1, FALSE);
  gtk_table_set_row_spacings(GTK_TABLE(table), 10);
  gtk_table_set_col_spacings(GTK_TABLE(table), 5);
  gtk_box_pack_start (GTK_BOX (main_box), table, FALSE, FALSE, 0);

  frame = gtk_frame_new(NULL);
  gtk_frame_set_shadow_type(GTK_FRAME(frame), GTK_SHADOW_OUT);
  gtk_table_attach_defaults(GTK_TABLE(table), 
                            frame,
                            0, 1, 0, 1);

  pixmap = gdk_pixmap_colormap_create_from_xpm_d(NULL, colormap, &mask, NULL,
                                                 logo_xpm);
  tpixmap = gtk_pixmap_new(pixmap, mask);
  gtk_container_add(GTK_CONTAINER(frame), tpixmap);

  sprintf(text, "SciGraphica-%s\nScientific Graphics\n\n(C) 2000 Adrian E. Feiguin\n\nhttp://scigraphica.sourceforge.net", VERSION);

  label =  gtk_label_new(text);
  gtk_misc_set_alignment(GTK_MISC(label), .5, .5);

  gtk_table_attach_defaults(GTK_TABLE(table), label, 0, 1, 1, 2);

  /* connect signals */

  gtk_signal_connect (GTK_OBJECT (window), "destroy",
                      GTK_SIGNAL_FUNC (presentation_destroy),NULL);

  gtk_signal_connect (GTK_OBJECT (window), "destroy",
                      GTK_SIGNAL_FUNC (mw_destroy),NULL);

  /* Show widgets */

  gtk_widget_show_all (window);

  timer = gtk_timeout_add(1200, timeout_end, window); 

  gtk_main();

  return;
}


