/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>
#include "main.h"

#define DATASET_NAME_LENGTH 100

static GtkWidget *functions_dialog = NULL;

static GtkWidget *functions_list;
static GtkWidget *label;

static gchar *titles1[] = {"  Functions   ", NULL };

static gboolean
mw_destroy(GtkWidget *widget)
{
  /* This is needed to get out of gtk_main */
  sg_dialog_kill(widget);

/*
  gtk_main_quit ();
*/

  functions_dialog = NULL;

  return FALSE;
}

static void
update_label(gint row)
{
  SGdataset *aux_data;
  GList *list;
  gchar *ctext[1];
  gchar text[1000];

  gtk_clist_get_text(GTK_CLIST(functions_list), row, 0, &ctext[0]);

  list = functions;
  while(list){
    aux_data = (SGdataset *)list->data;

    if(strcmp(((GtkPlotData *)aux_data->real_data)->name, ctext[0]) == 0) break;
       
    list = list->next;
  } 

  sprintf(text, "%s = %s",ctext[0], aux_data->exp);
  gtk_label_set_text(GTK_LABEL(label), text);
}

static void
select_row(GtkCList *clist, gint row, gint col, GdkEvent *event)
{
  update_label(row);
}

static gint
new_function(GtkWidget *widget, gpointer data)
{
  SGdataset *aux_data = NULL;
  gchar text[1000];
  gchar *ctext[1];
  gboolean new_function;

  aux_data = sg_dataset_new_function(NULL);
  sprintf(text, "f%d(x)", last_function+1);
  sg_dataset_set_name(aux_data, text);

  new_function = sg_edit_function_dialog(aux_data);

  if(new_function){
    sg_project_add_function(aux_data);
    ctext[0] = aux_data->real_data->name;
    gtk_clist_append(GTK_CLIST(functions_list), ctext);
    sprintf(text, "%s = %s", text, aux_data->exp);
    gtk_label_set_text(GTK_LABEL(label), text);
  }
  else
    sg_dataset_destroy(aux_data);

  return TRUE;
}

static gint
edit_function(GtkWidget *widget, gpointer data)
{
  SGdataset *aux_data = NULL;
  SGdataset *new_data = NULL;
  gchar *ctext[1];
  gboolean new_function;
  GList *selection;
  GList *list;
  gint row;
  gchar text[1000];

  selection = GTK_CLIST(functions_list)->selection;
  if(!selection) return TRUE;

  row = GPOINTER_TO_INT(selection->data);

  gtk_clist_get_text(GTK_CLIST(functions_list), row, 0, &ctext[0]);

  list = functions;
  while(list){
    aux_data = (SGdataset *)list->data;

    if(strcmp(((GtkPlotData *)aux_data->real_data)->name, ctext[0]) == 0) break;
       
    list = list->next;
  } 

  new_data = sg_dataset_new_function(aux_data->exp);
  sg_dataset_set_name(new_data, ((GtkPlotData *)aux_data->real_data)->name);

  new_function = sg_edit_function_dialog(new_data);

  if(new_function){
    sg_dataset_set_exp(aux_data, new_data->exp);
    sprintf(text, "%s = %s", ctext[0], aux_data->exp);
    gtk_label_set_text(GTK_LABEL(label), text);
  }

  sg_dataset_destroy(new_data);

  return TRUE;
}


static gint
delete_function(GtkWidget *widget, gpointer data)
{
  GList *selection;
  gint row;

  selection = GTK_CLIST(functions_list)->selection;
  if(!selection) return TRUE;

  row = GPOINTER_TO_INT(selection->data);
  gtk_clist_remove(GTK_CLIST(functions_list), row);

  gtk_label_set_text(GTK_LABEL(label), "");

  return TRUE;
}

void
sg_function_dialog_new ()
{
  GtkWidget *window;
  GtkWidget *frame;
  GtkWidget *main_box;
  GtkWidget *sw;
  GtkWidget *action_area;
  GtkWidget *new_button, *delete_button, *edit_button, *close_button;
  GList *list;
  SGdataset *dataset;
  gchar *text[1];

  if(functions_dialog){
      gdk_window_raise(functions_dialog->window);
      return;
  }

  /* Create widgets */
  functions_dialog = window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_policy(GTK_WINDOW(window), FALSE, FALSE, FALSE);
  gtk_window_set_title (GTK_WINDOW(window),"Function Datasets");

  sg_dialog_new(window);
/*
  gtk_window_set_modal (GTK_WINDOW(window),TRUE);
*/

  main_box = gtk_vbox_new (FALSE,5);
  gtk_container_set_border_width(GTK_CONTAINER(main_box), 10);
  gtk_container_add (GTK_CONTAINER (window), main_box);

  action_area = gtk_hbutton_box_new ();
  gtk_button_box_set_layout(GTK_BUTTON_BOX(action_area), GTK_BUTTONBOX_END);
  gtk_button_box_set_spacing(GTK_BUTTON_BOX(action_area), 5);
  gtk_box_pack_start (GTK_BOX (main_box), action_area, FALSE, FALSE, 0);

  close_button = gtk_button_new_with_label (" OK ");
  gtk_box_pack_start (GTK_BOX (action_area), close_button, TRUE, TRUE, 0);
  gtk_widget_show (close_button);

/********************************************************************/
  frame = gtk_frame_new(NULL);
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_IN);
  gtk_box_pack_start (GTK_BOX (main_box), frame, FALSE, FALSE, 0);

  sw = gtk_scrolled_window_new(NULL, NULL);
  gtk_container_set_border_width(GTK_CONTAINER(sw), 5);
  gtk_widget_set_usize(sw, 120, 160);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(sw),
                                 GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  gtk_container_add(GTK_CONTAINER(frame), sw);
  functions_list = gtk_clist_new_with_titles(1, titles1);
  gtk_container_add(GTK_CONTAINER(sw), functions_list);

  label = gtk_label_new("");
  gtk_misc_set_alignment(GTK_MISC(label), 0., .5);
  gtk_box_pack_start (GTK_BOX (main_box), label, FALSE, FALSE, 0);
/**************************************************************/  
  action_area = gtk_hbutton_box_new ();
  gtk_button_box_set_layout(GTK_BUTTON_BOX(action_area), GTK_BUTTONBOX_START);
  gtk_button_box_set_spacing(GTK_BUTTON_BOX(action_area), 5);
  gtk_box_pack_start (GTK_BOX (main_box), action_area, FALSE, FALSE, 0);

  new_button = gtk_button_new_with_label ("New");
  gtk_box_pack_start (GTK_BOX (action_area), new_button, TRUE, TRUE, 0);
  gtk_widget_show (new_button);

  delete_button = gtk_button_new_with_label ("Delete");
  gtk_box_pack_start (GTK_BOX (action_area), delete_button, TRUE, TRUE, 0);
  gtk_widget_show (delete_button);

  edit_button = gtk_button_new_with_label ("Edit");
  gtk_box_pack_start (GTK_BOX (action_area), edit_button, TRUE, TRUE, 0);
  gtk_widget_show (edit_button);

  /* connect signals */

  gtk_signal_connect(GTK_OBJECT(new_button), "clicked",
                     (GtkSignalFunc) new_function, NULL);

  gtk_signal_connect(GTK_OBJECT(delete_button), "clicked",
                     (GtkSignalFunc) delete_function, NULL);

  gtk_signal_connect(GTK_OBJECT(edit_button), "clicked",
                     (GtkSignalFunc) edit_function, NULL);

  gtk_signal_connect (GTK_OBJECT (window), "destroy",
                      GTK_SIGNAL_FUNC (mw_destroy),NULL);

  gtk_signal_connect (GTK_OBJECT (functions_list), "select_row",
                      GTK_SIGNAL_FUNC (select_row),NULL);

  gtk_signal_connect_object (GTK_OBJECT (close_button), "clicked",
                      GTK_SIGNAL_FUNC (gtk_widget_destroy), GTK_OBJECT(window));

  /* show widgets */

  list = functions;
  while(list){

    dataset = (SGdataset *)list->data;
    if(dataset->real_data->is_function){
        text[0] = dataset->real_data->name;
        gtk_clist_append(GTK_CLIST(functions_list), text);
    }

    list = list->next;
  }

  gtk_widget_show_all(window);

  /* wait until dialog get destroyed */
/*
  gtk_main();
*/
  return;
}

