/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#ifndef __SG_DIALOGS_H__
#define __SG_DIALOGS_H__

enum {	YES_CLICKED = TRUE,
	NO_CLICKED  = FALSE,
	CANCEL_CLICKED = 2,
};

void		sg_dialog_new			(GtkWidget *widget);
void		sg_dialog_kill			(GtkWidget *widget);
void		sg_dialogs_init			();
void		sg_dialogs_destroy		();

GtkWidget  	*sg_planes_dialog_new		(SGlayer *layer);
void		sg_planes_dialog_update_plot	(GtkWidget *dialog);

GtkWidget  	*sg_axis_dialog_new		(SGlayer *layer);
void		sg_axis_dialog_update_plot	(GtkWidget *dialog);

GtkWidget  	*sg_data_dialog_new		(SGlayer *layer);
void		sg_data_dialog_update_plot	(GtkWidget *dialog);

GtkWidget 	*sg_title_dialog_new		(SGlayer *layer);
void		sg_title_dialog_update_plot	(GtkWidget *dialog);

GtkWidget  	*sg_style_dialog_new		(SGlayer *layer);
void		sg_style_dialog_update_plot	(GtkWidget *dialog);

GtkWidget  	*sg_grids_dialog_new		(SGlayer *layer);
void		sg_grids_dialog_update_plot	(GtkWidget *dialog);

GtkWidget  	*sg_frame_dialog_new		(SGlayer *layer);
void		sg_frame_dialog_update_plot	(GtkWidget *dialog);

GtkWidget  	*sg_layer_dialog_new		(SGlayer *layer);
void		sg_layer_dialog_update_plot	(GtkWidget *dialog);

GtkWidget  	*sg_labels_dialog_new		(SGlayer *layer);
void		sg_labels_dialog_update_plot	(GtkWidget *dialog);

GtkWidget  	*sg_legends_dialog_new		(SGlayer *layer);
void		sg_legends_dialog_update_plot	(GtkWidget *dialog);

GtkWidget  	*sg_page_dialog_new		(SGplot *plot);
void		sg_page_dialog_update_plot	(GtkWidget *dialog);

void		sg_function_dialog_new		();

void		sg_text_dialog_update_plot	(GtkWidget *dialog);
void		sg_line_dialog			(GtkPlotCanvas *canvas,
                                                 GtkPlotCanvasLine * line);
void		sg_rectangle_dialog		(GtkPlotCanvas *canvas,
                                                 GtkPlotCanvasRectangle *rectangle);
void		sg_ellipse_dialog		(GtkPlotCanvas *canvas,
                                                 GtkPlotCanvasEllipse *ellipse);
void		sg_arrange_dialog		(GtkPlotCanvas *canvas);

void 		sg_append_dialog 		(SGworksheet *worksheet,
						 gint orientation);
void		sg_column_dialog 		(SGworksheet *worksheet,
						 gint column);
void		sg_formula_dialog 		(SGworksheet *worksheet,
						 gint column);
gboolean	sg_edit_function_dialog 	(SGdataset *dataset);
gchar *		sg_text_dialog			(gchar *msg, gint type);
void		sg_message_dialog		(gchar *msg, gint type);
gint		sg_accept_dialog		(gchar *msg, gint type);
#ifdef WITH_GNOME
GtkWidget       *sg_message_dialog_loop         (gchar *msg, gint type);
GtkWidget       *sg_accept_dialog_loop          (gchar *msg, gint type);
#endif
void		sg_about_dialog			(GtkWidget *widget,
						 gpointer data);
void		sg_presentation_dialog		();
void            sg_import_dialog                (gchar *full_path,
                                                 gchar *file_name);

void 		sg_layer_control		(gchar *path);
void 		sg_layer_control_refresh	(gchar *path);
void 		sg_layer_control_destroy	();
SGdataset *     sg_edit_data_dialog              (SGlayer *layer);
void		sg_preferences_dialog		();

#endif

