/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __SG_DATASET_H__
#define __SG_DATASET_H__

enum {
	SG_DATA_PYTHON,
	SG_DATA_FUNCTION,
	SG_DATA_LPOINTS,  /* Regular XY dataset */
	SG_DATA_VBARS,     /* Vertical GtkPlotBar */
	SG_DATA_HBARS,     /* Horizontal GtkPlotBar */
	SG_DATA_VBOXES,    /* Vertical GtkPlotBox */
	SG_DATA_HBOXES,    /* Horizontal GtkPlotBox */
	SG_DATA_BUBBLES,  /* GtkPlotBubble */
	SG_DATA_FLUX,     /* GtkPlotFux */
	SG_DATA_COLORS,     /* colored symbols */
	SG_DATA_DMAP,     /* GtkPlotDMap */
	SG_DATA_CONTOUR,  /* GtkPlotCSurface? */
	SG_DATA_CSURFACE,  /* GtkPlotCSurface */
	SG_DATA_SURFACE,  /* GtkPlotSurface */
};

typedef struct _SGdataset SGdataset;


struct _SGdataset 
{
  SGworksheet *worksheet;
  gint x;
  gint y;
  gint z;
  gint a;
  gint dx;
  gint dy;
  gint dz;
  gint da;
  gint l;

  GtkPlotData *real_data;

  gint type;

  gchar *exp;

  gchar *p_exp[9];
};

SGdataset*	sg_dataset_new			(gint type); 
SGdataset*	sg_dataset_new_with_worksheet	(gint type,
                                                 SGworksheet *worksheet, 
				 	 	 gint col_x,
					 	 gint col_y,
					 	 gint col_z,
					 	 gint col_a,
					 	 gint col_ex,
					 	 gint col_ey,
					 	 gint col_ez,
					 	 gint col_ea,
					 	 gint col_l);
SGdataset*      sg_dataset_new_function         (gchar *exp);
SGdataset *     sg_dataset_new_python           (gint type, gchar *p_exp[9]);
void		sg_dataset_set_worksheet	(SGdataset *dataset,
						 SGworksheet *worksheet, 
				 	 	 gint col_x,
					 	 gint col_y,
					 	 gint col_z,
					 	 gint col_a,
					 	 gint col_ex,
					 	 gint col_ey,
					 	 gint col_ez,
					 	 gint col_ea,
					 	 gint col_l);
void            sg_dataset_set_python           (SGdataset *dataset,
                                                 gchar *p_exp[9]);
void		sg_dataset_add_point		(SGdataset *dataset,
						 gdouble *x,
						 gdouble *y,
						 gdouble *z,
						 gdouble *a,
						 gdouble *ex,
						 gdouble *ey,
						 gdouble *ez,
						 gdouble *ea,
						 gchar *label); 
void		sg_dataset_refresh		(SGdataset *dataset); 
void		sg_dataset_free_points		(SGdataset *dataset); 
void		sg_dataset_destroy		(SGdataset *dataset); 
void		sg_dataset_set_name		(SGdataset *dataset,
						 gchar *name); 
void		sg_dataset_refresh_name		(SGdataset *dataset);
void            sg_dataset_set_exp              (SGdataset *dataset,
                                                 gchar *exp);



#endif /* __SG_DATASET_H__ */

