#include <sys/types.h>
#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>
#include <Python.h>
#include <grammar.h>
#include <node.h>
#include <parsetok.h>
#include <errcode.h>
#include <compile.h>
#include <eval.h>
#include <marshal.h>
#include "../main.h"
#include "python_main.h"

extern PyObject *main_o, *main_dict, *sg_o, *sg_dict;

extern gint stdout_pipe[2];
gint py_status=0; /* 0=normal, 1=old line waiting */
extern grammar _PyParser_Grammar; /* From Python/graminit.c */
extern FILE *stdout_fp;
extern pid_t child_pid;
GString *com_buffer;

#ifndef Py_eval_input
#include <graminit.h>
#define Py_eval_input eval_input
#endif /* Py_eval_input */

int sg_eval_func(gchar *func_def, gdouble x_value, gdouble *y_value)
{ PyObject *object=NULL;
  gint len;

  object=Py_BuildValue("d",x_value);
  if (!object) return FALSE;
  PyDict_SetItemString (sg_dict, "x", object);

  object=PyRun_String (func_def, Py_eval_input, sg_dict, sg_dict);
  if (!object)
   { if (PyErr_Occurred()) python_error_report(object);
     return FALSE;
   }

  *y_value=PyFloat_AsDouble (object);

  return TRUE;
}

int sg_eval_quiet(gchar *func_def)
{ PyObject *object=NULL;
  gint len;

  object=PyRun_String (func_def, Py_eval_input, sg_dict, sg_dict);
  if (!object)
   { if (PyErr_Occurred())  PyErr_Clear();
     return FALSE;
   }
  Py_XDECREF(object);
  return TRUE;
}


/* Evalutes an expression and sends back an array of doubles */
gdouble *sg_eval_expr_double(gchar *expr, gint *num, gint expect)
{ PyObject *object=NULL,*seq_obj;
  PyArrayObject *parray;
  gpointer apt;
  GArray *array;
  double *retarray,val;
  gint i,j,len;

  *num=0;

  array=g_array_new (FALSE, FALSE, sizeof (gdouble));
  object=PyRun_String (expr, Py_eval_input, main_dict, sg_dict);
  if (!object)
   { if (PyErr_Occurred()) { PyErr_Print(); PyErr_Clear();}
     *num=0;
   }

#ifdef WITH_NUMERIC_PYTHON
  else {
  if (PyArray_Check(object) && ((PyArrayObject *)object)->nd==1)
  {    parray=(PyArrayObject *)object;
       for (i=0;i<parray->dimensions[0];i++)
          { apt=parray->data+i*parray->strides[0];
            switch (parray->descr->type_num)
             { case PyArray_CHAR:
               case PyArray_UBYTE:
               case PyArray_SBYTE:
                val=(double)(*(char *)(apt));
                g_array_append_val( array,val);
                break;
               case PyArray_SHORT:
                val=(double)(*(short int *)(apt));
                g_array_append_val( array,val);
                break;
               case PyArray_INT:
                val=(double)(*(int *)(apt));
                g_array_append_val( array,val);
                break;
               case PyArray_LONG:
                val=(double)(*(long *)(apt));
                g_array_append_val( array,val);
                break;
               case PyArray_FLOAT:
                val=(double)(*(float *)(apt));
                g_array_append_val( array,val);
                break;
               case PyArray_DOUBLE:
                val=*(double *)(apt);
                g_array_append_val( array,val);
                break;
               case PyArray_CFLOAT:
               case PyArray_CDOUBLE:
                val=(double)(*(long double*)(apt));
                g_array_append_val( array,val);
                break;
               case PyArray_OBJECT:
                break;
             }
          }
  }
  else
#endif
  if (PySequence_Check(object) && !PyString_Check(object))
  {   len=PySequence_Length(object);
      for (i=0;i<len;i++)
       { seq_obj=PySequence_GetItem(object,i);
         Py_INCREF(seq_obj);
         if (PyFloat_Check (seq_obj))
         {
             val=PyFloat_AsDouble(seq_obj);
             g_array_append_val( array, val);
         }
         else if (PyInt_Check (seq_obj))
         {
             val=(double)PyInt_AsLong(seq_obj);
             g_array_append_val( array, val);
         }
       }
  }
  else if (PyFloat_Check (object))
  {
      val=PyFloat_AsDouble(object);
      g_array_append_val( array, val);
  }
  else if (PyInt_Check (object))
  {
      val=(double)PyInt_AsLong(object);
      g_array_append_val( array, val);
  }
 } 
 len=expect-array->len;
 if (expect>0 && array->len<expect)
    for (i=0;i<len;i++)
    { val=0;
      g_array_append_val(array,val);
    }
 retarray=(double *)(array->data);
 *num=array->len;
 g_array_free(array,FALSE); /* Delete structure, but NOT the data */

 return retarray;
}

/* Evalutes an expression and sends back an array of strings */
gchar **sg_eval_expr_string(gchar *expr, gint *num)
{ PyObject *object=NULL,*seq_obj;
  GArray *array;
  gchar **retarray,*val;
  gint i,j,len;

  *num=0;

  object=PyRun_String (expr, Py_eval_input, main_dict, sg_dict);
  if (!object)
   { if (PyErr_Occurred()) { PyErr_Print(); PyErr_Clear();}
     return NULL;
   }

  array=g_array_new (FALSE, FALSE, sizeof (gchar *));
  if (PySequence_Check(object) && !PyString_Check(object))
  {   len=PySequence_Length(object);
      for (i=0;i<len;i++)
       { seq_obj=PySequence_GetItem(object,i);
         Py_INCREF(seq_obj);
         if (PyString_Check (seq_obj))
         {
             val=strdup(PyString_AsString(seq_obj));
             g_array_append_val( array,  val);
         }
         else
         {
             val=strdup(PyString_AsString( PyObject_Repr(seq_obj)));
             g_array_append_val( array, val);
         }
       }
  }
  else if (PyString_Check (object))
  {
      val=strdup(PyString_AsString(object));
      g_array_append_val( array, val);
  }
  else
  {
      val=strdup(PyString_AsString( PyObject_Repr(object)));
      g_array_append_val( array,  val);
  }

  retarray=(gchar  **)(array->data);
  *num=array->len;
  g_array_free(array,FALSE); /* Delete structure, but NOT the data */

  return retarray;
}



int python_simple(gchar *command,gint count)
{ int retval,len;
  static PyObject *object=NULL;
  gchar *print_string,fn[]=PACKAGE,*s_str;
  gchar eol='\n';
  node *parse_node;
  perrdetail perr;

  if (0==count) return(0);
  if (!command) return(0);

  /* User entered a blank line at the top level prompt, skip */
  if ((0==py_status)&&(eol==command[0]))
  {
      return (1);
  }

  /*  Make sure the command ends with a newline and the string ends
   *  with a NULL */
  if (0!=command[count-1])
  {
      if (eol!=command[count-1])
      {
          command[count++]=eol;
      }
      command[count++]=0;
  }

  if (py_status==0)
  {
      /* Top level command */
      com_buffer=g_string_new(command);
  }
  else
  {
      /* Continued command block (until blank line) */
      if ((1==py_status)&&(eol!=command[0]))
      {
          g_string_append(com_buffer,command);
          return(2);
      }
  }

  parse_node = PyParser_ParseString(com_buffer->str, &_PyParser_Grammar,
                                    Py_file_input,&perr);
  switch (perr.error)
  { 
      case  E_EOF:
          /* User has started a command block,
           * probably with a def or class command */
          py_status=1;
          return(2);
      case  E_DONE:
          /* A complete command was found when parsing */
          /*FALL THROUGH*/
      default:
          py_status=0;
          if (parse_node) PyNode_Free(parse_node);
  }

  object=PyRun_String (com_buffer->str, Py_single_input, main_dict, sg_dict);

  if (!object){
      PyErr_Print();
      if (Py_FlushLine())
          PyErr_Clear(); 
      g_string_free(com_buffer,TRUE);
      return(0); 
  }
   
  Py_DECREF(object);
  g_string_free(com_buffer,TRUE);
  return(1);
}

int sg_eval_script(gchar *fname)
{ PyObject *object;
  FILE *fp;

  fp=fopen(fname,"r");
  if (!fp)
  {  sg_message_dialog("File not found", 0);
     return 0;
  }

  object=PyRun_File (fp,fname, Py_file_input, main_dict, main_dict);

  fclose(fp);

  if (python_error_report(object))
        return 0;

  return 1;
}
