/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __SG_MAIN_H__
#define __SG_MAIN_H__

#define NUM_SYMBOLS 10
#define NUM_SYMBOL_STYLES 3
#define NUM_LINE_STYLES 7
#define NUM_CONNECTORS 6


#include "config.h"
#include "sg_misc.h"
#include "sg_worksheet.h"
#include "sg_worksheet_file.h"
#include "sg_worksheet_file_html.h"
#include "sg_worksheet_file_ascii.h"
#include "sg_worksheet_file_tex.h"
#include "sg_worksheet_file_xml.h"
#include "sg_plot_file.h"
#include "sg_plot_file_xml.h"
#include "sg_clipboard.h"
#include "sg_dataset.h"
#include "sg_layer.h"
#include "sg_plot.h"
#include "sg_entry.h"
#include "sg_dialogs.h"
#include "sg_text_dialog.h"
#include "sg_toolbox.h"
#include "sg_plot_tools.h"
#include "sg_preferences_dialog.h"
#include "sg_toggle_combos.h"
#include "sg_menus.h"
#include "sg_file.h"
#include "sg_plugin.h"
#include "sg_project.h"
#include "sg_project_file_xml.h"
#include "sg_project_file_sax.h"

#ifdef WITH_GNOME
#include <gnome.h>
#endif

GtkWidget *main_window;
GtkWidget *gui_notebook;
GtkWidget *scrollw1;
GtkWidget *scrollw2;
GtkWidget *iconlist1;
GtkWidget *iconlist2;
GtkIconListItem *active_icon;

SGworksheet *active_worksheet;
SGplot *active_plot;
SGlayer *active_layer;
SGdataset *active_dataset;

GtkWidget *worksheet_popup;
GtkWidget *plot_popup;

GtkWidget *worksheet_menu;
GtkWidget *plot_menu;

gint num_worksheets;
gint num_plots;
gint num_functions;
gint num_expressions;
gint last_worksheet;
gint last_plot;
gint last_function;
gint last_expression;

gchar *last_worksheet_path;
gchar *last_worksheet_filename;
gchar *last_plot_path;
gchar *last_plot_filename;
gchar *last_project_path;
gchar *last_project_filename;

gboolean project_changed;
gboolean project_name_changed;
gboolean plot_name_changed;
gboolean worksheet_name_changed;
gboolean sg_exiting;

gint arrange_rows;
gint arrange_cols;
gdouble arrange_vgap;
gdouble arrange_hgap;
gdouble arrange_top;
gdouble arrange_bottom;
gdouble arrange_left;
gdouble arrange_right;

GList *worksheets;
GList *plots;
GList *functions;
GList *expressions;

gboolean gui_iconlist;
gboolean gui_worksheet;
gboolean gui_plot;

enum
{
  SG_DELIMITER_UNKNOWN,
  SG_DELIMITER_COMMA,
  SG_DELIMITER_TAB,
  SG_DELIMITER_SPACE,
};

static gchar *line_styles[] = {
					"None",
					"Solid",
					"Dotted",
					"Dashed",
					"Dot-dash",
					"Dot-dot-dash",
					"Dot-dash-dash",
					NULL
};

static gchar *border_styles[] = {
					"None",
					"Line",
					"Shadow",
					NULL
};

static gchar *connectors[] = {
					"None",
					"Straight",
					"Spline",
					"H-V step",
					"V-H step",
					"Middle step",
					NULL
};

static gchar *symbol_styles[] = {
					"Empty",
					"Filled",
					"Opaque",
					NULL
};

gint delimiter;
gint skip_lines;
gboolean rename_columns;
gboolean rename_worksheets;
gboolean rename_plots;
gboolean precision_mod;
gchar comment_string[80],block_start[80],custom_delimiter[80],*file_path;
gint begin_line;
gint end_line;
gint blocknum;
gint read_method;
gboolean read_all_lines,use_custom_delim;
gint sg_canvas_label_pos;
gint sg_canvas_label_width;
gint sg_autosave_int;
gint sg_compress_level;
gint sg_units;


#define OAFIID_SCIGRAPHICA_FACTORY \
 "OAFIID:bonobo_scigraphica_factory:46a396b7-7e6d-4781-9163-d90338cbd51b"

#define OAFIID_SCIGRAPHICA \
 "OAFIID:bonobo_scigraphica:3d2d8d14-3994-4e5b-9e26-bf175d5064d2"

#endif /* __SG_MAIN_H__ */
