%define version	0.7.1
%define release	1mdk
%define name scigraphica
%define python_mod_dir ${prefix}/share/scigraphica/python

Name: %name
Summary: Data analysis and technical graphics
Version: %version
Release: %release
License: GPL
Group: Sciences/Other
Source: sg-%version.tar.bz2
BuildRoot: %_tmppath/%name-buildroot
Requires: glib gtk+ libgtk+extra0 >= 0.99.15 python python-numeric
Buildrequires: libgtk+extra0-devel >= 0.99.15 python-numeric

%description
SciGraphica is a scientific application for data analysis and technical 
graphics. It pretends to be a clone of the popular commercial (and expensive)
application "Microcal Origin". It fully supplies plotting features for 2D, 3D 
and polar charts. The aim is to obtain a fully-featured, cross-platform, 
user-friendly, self-growing scientific application. It is free and
open-source, released under the GPL license. 

%prep
rm -rf $RPM_BUILD_ROOT

%setup -n sg-%version

%build
%ifarch alpha
MYARCH_FLAGS="--host=alpha-linux"
%endif
if [ ! -f configure ]; then
  ./autogen.sh
  CFLAGS="$RPM_OPT_FLAGS" ./configure --prefix=%_prefix $MYARCH_FLAGS
else
  CFLAGS="$RPM_OPT_FLAGS" ./configure --prefix=%_prefix $MYARCH_FLAGS
fi

%make

%install
make prefix=$RPM_BUILD_ROOT%_prefix pprefix=$RPM_BUILD_ROOT%_prefix install-strip

mkdir -p $RPM_BUILD_ROOT/%{_menudir}
cat << EOF > $RPM_BUILD_ROOT/%{_menudir}/scigraphica
?package(scigraphica):command="/usr/bin/sga" icon="sg_icon.xpm" \
                 needs="X11" section="Applications/Sciences/Other" title="SciGraphica" \
                 longtitle="Data Plotting and Visualization"
EOF

%post
%update_menus

%postun
%clean_menus

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr (-,root,root)
%doc AUTHORS COPYING ChangeLog NEWS README TODO
%_bindir/*
%_datadir
%{python_mod_dir}/*
%_menudir/*

%changelog
* Sun Jul 01 2001 Conrad Steenberg <conrad@hep.caltech.edu> 0.7.0-1mdk
- update to 0.7.0
- put examples in the right place

* Thu Feb 08 2001 Conrad Steenberg <conrad@hep.caltech.edu> 0.6.2-1mdk
- update to 0.6.2
- include only sg_icon.xpm
- include example files in doc directory

* Fri Jan 19 2001 Lenny Cartier <lenny@mandrakesoft.com> 0.6.1-2mdk
- update requires and buildrequires

* Tue Jan 16 2001 Lenny Cartier <lenny@mandrakesoft.com> 0.6.1-1mdk
- new in contribs
