/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdlib.h>
#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>
#include "sg_title_dialog.h"
#include "sg.h"
#include "sg_dialogs.h"


typedef struct{
  SGlayer *layer;
  SGplot *plot;
  GtkPlotText *text;
  GtkPlotAxis *axis;

  GtkWidget *fg_combo;
  GtkWidget *bg_combo;
  GtkWidget *text_frame;
  GtkWidget *font_combo;
  GtkWidget *border_combo;
  GtkWidget *text_entry;
  GtkWidget *angle_spin;
  GtkWidget *x_spin;
  GtkWidget *y_spin;
  GtkWidget *center_item;
  GtkWidget *transparent_item;

} SGtitledialog;

static SGtitledialog text_dialog[4];


void
sg_title_dialog_update_plot(GtkWidget *notebook)
{
  SGtitledialog *dialog;
  GtkColorCombo *combo;
  GtkPlotAxis *axis;
  GtkPlot *plot;
  GdkColor color, fg, bg;
  GtkWidget *child;
  GtkPlotAxisPos the_axis = GTK_PLOT_AXIS_LEFT;
  gchar *text;
  gchar *color_name;
  gchar *font;
  gint height;
  gint angle;
  gint page;
  gboolean state;
  gdouble xoffset, yoffset;

  page = gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook));
  dialog = &text_dialog[page];
 
  axis = dialog->axis;
  text = gtk_entry_get_text(GTK_ENTRY(dialog->text_entry));
  plot = GTK_PLOT(dialog->layer->real_plot);

  if(axis == plot->top) the_axis = GTK_PLOT_AXIS_TOP; 
  if(axis == plot->bottom) the_axis = GTK_PLOT_AXIS_BOTTOM; 
  if(axis == plot->left) the_axis = GTK_PLOT_AXIS_LEFT; 
  if(axis == plot->right) the_axis = GTK_PLOT_AXIS_RIGHT; 
  
  font = GTK_FONT_COMBO(dialog->font_combo)->psfont->psname;
  height = GTK_FONT_COMBO(dialog->font_combo)->height;
  axis->title.transparent = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(dialog->transparent_item));

  child = (GtkWidget *)GTK_LIST(GTK_COMBO(dialog->border_combo)->list)->selection->data;
  axis->title.border = (GtkPlotBorderStyle)gtk_list_child_position(GTK_LIST(GTK_COMBO(dialog->border_combo)->list), child);

  combo = GTK_COLOR_COMBO(dialog->fg_combo);
  color_name = gtk_color_combo_get_color_at(combo, combo->row, combo->column);
  gdk_color_parse(color_name, &color);
  gdk_color_alloc(dialog->fg_combo->style->colormap, &color);
  fg = color;
  combo = GTK_COLOR_COMBO(dialog->bg_combo);
  color_name = gtk_color_combo_get_color_at(combo, combo->row, combo->column);
  gdk_color_parse(color_name, &color);
  gdk_color_alloc(dialog->bg_combo->style->colormap, &color);
  bg = color;

  angle = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(dialog->angle_spin));

  xoffset = gtk_spin_button_get_value_as_float(GTK_SPIN_BUTTON(dialog->x_spin));
  yoffset = gtk_spin_button_get_value_as_float(GTK_SPIN_BUTTON(dialog->y_spin));

  state = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(dialog->center_item));
  dialog->text->justification = state ? GTK_JUSTIFY_CENTER : GTK_JUSTIFY_LEFT;

  gtk_plot_axis_set_title(plot, the_axis, text);
  gtk_plot_axis_move_title(plot, the_axis, angle, xoffset, yoffset);
  gtk_plot_axis_title_set_attributes(plot, the_axis,
                                     font, height, angle, &fg, &bg,
                                     axis->title.transparent, 
                                     dialog->text->justification); 

  gtk_plot_canvas_paint(GTK_PLOT_CANVAS(dialog->plot->real_canvas));
  gtk_plot_canvas_refresh(GTK_PLOT_CANVAS(dialog->plot->real_canvas));
}

static void
new_fg(GtkColorCombo *combo, gint selection, gchar *name, gpointer data)
{
  GtkWidget *text_entry;
  GdkColormap *colormap;
  GdkGC *gc;
  GdkColor color;
  GtkStyle *style;
 
  text_entry = GTK_WIDGET(data);

  colormap =gdk_colormap_get_system();
  gc = gdk_gc_new(GTK_PIXMAP(GTK_BIN(GTK_COMBO_BOX(combo)->button)->child)->pixmap);

  gdk_color_parse(name, &color);
  gdk_color_alloc(colormap, &color);
  gdk_gc_set_foreground(gc, &color);

  gdk_draw_rectangle(GTK_PIXMAP(GTK_BIN(GTK_COMBO_BOX(combo)->button)->child)->pixmap,
                     gc,
                     TRUE,
                     4,4,33,13);

  gdk_gc_unref(gc); 
  gtk_widget_draw(GTK_BIN(GTK_COMBO_BOX(combo)->button)->child, NULL);

  style = gtk_style_copy(text_entry->style);
  style->fg[0] = color;
  gtk_widget_set_style (text_entry, style);
  gtk_style_unref(style);

} 

static void
new_bg(GtkColorCombo *combo, gint selection, gchar *name, gpointer data)
{
  GtkWidget *text_entry;
  GdkColormap *colormap;
  GdkGC *gc;
  GdkColor color;
  GtkStyle *style;
 
  text_entry = GTK_WIDGET(data);

  colormap =gdk_colormap_get_system();
  gc = gdk_gc_new(GTK_PIXMAP(GTK_BIN(GTK_COMBO_BOX(combo)->button)->child)->pixmap);

  gdk_color_parse(name, &color);
  gdk_color_alloc(colormap, &color);
  gdk_gc_set_foreground(gc, &color);

  gdk_draw_rectangle(GTK_PIXMAP(GTK_BIN(GTK_COMBO_BOX(combo)->button)->child)->pixmap,
                     gc,
                     TRUE,
                     4,4,33,13);

  gdk_gc_unref(gc); 
  gtk_widget_draw(GTK_BIN(GTK_COMBO_BOX(combo)->button)->child, NULL);

  style = gtk_style_copy(text_entry->style);
  style->base[0] = color;
  gtk_widget_set_style (text_entry, style);
  gtk_style_unref(style);
} 

static gint 
init_dialog(SGtitledialog *dialog)
{
  GtkPSFont *font;
  GtkPlotText *text;
  gchar *color_name;
  gint row, col;

  text = dialog->text;

  gtk_entry_set_text(GTK_ENTRY(dialog->text_entry), text->text);

  sg_color_combo_init(GTK_COLOR_COMBO(dialog->fg_combo), text->fg);
  sg_color_combo_init(GTK_COLOR_COMBO(dialog->bg_combo), text->bg);

  row = GTK_COLOR_COMBO(dialog->fg_combo)->row;
  col = GTK_COLOR_COMBO(dialog->fg_combo)->column;
  color_name = gtk_color_combo_get_color_at(GTK_COLOR_COMBO(dialog->fg_combo), row, col);
  new_fg(GTK_COLOR_COMBO(dialog->fg_combo), 0, color_name, dialog->text_entry);

  row = GTK_COLOR_COMBO(dialog->bg_combo)->row;
  col = GTK_COLOR_COMBO(dialog->bg_combo)->column;
  color_name = gtk_color_combo_get_color_at(GTK_COLOR_COMBO(dialog->fg_combo), row, col);
  new_bg(GTK_COLOR_COMBO(dialog->bg_combo), 0, color_name, dialog->text_entry);

  gtk_list_select_item(GTK_LIST(GTK_COMBO(dialog->border_combo)->list),
                       text->border);

  font = gtk_psfont_get_font(text->font);
  gtk_font_combo_select(GTK_FONT_COMBO(dialog->font_combo),
                        font->family,
                        FALSE,
                        FALSE,
                        text->height);
  return FALSE;
}

static GtkWidget * 
sg_build_title_dialog (SGlayer *layer, GtkPlotAxis *axis,  SGtitledialog *dialog)
{
  GtkWidget *frame;
  GtkWidget *main_box, *main_table, *table;
  GtkRequisition req;
  GtkPlotText *text;
  GtkAdjustment *adj;
  gboolean state;
  GtkWidget *label;

  dialog->layer = layer;
  dialog->plot = (SGplot *)layer->parent;
  dialog->text = text = &axis->title;
  dialog->axis = axis;

  /* Create widgets */
  main_box = gtk_hbox_new (FALSE,5);
  gtk_container_set_border_width(GTK_CONTAINER(main_box), 5);

  main_table = gtk_table_new(2,2,FALSE);
  gtk_container_set_border_width(GTK_CONTAINER(main_table), 5);
  gtk_table_set_col_spacings(GTK_TABLE(main_table), 2);
  gtk_table_set_row_spacings(GTK_TABLE(main_table), 2);
  gtk_box_pack_start (GTK_BOX (main_box), main_table, FALSE, FALSE, 0);
/*----------------------------------------------*/
  dialog->text_frame = sg_entry_new();
  gtk_frame_set_shadow_type (GTK_FRAME (dialog->text_frame), GTK_SHADOW_ETCHED_IN);
  gtk_table_attach_defaults(GTK_TABLE(main_table), dialog->text_frame, 0, 2, 1, 2);

  dialog->font_combo = SG_ENTRY(dialog->text_frame)->font_combo;
  dialog->text_entry = SG_ENTRY(dialog->text_frame)->text_entry;
/*--------------------------------------*/
  frame = gtk_frame_new("Position");
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_IN);
  gtk_table_attach_defaults(GTK_TABLE(main_table), frame, 0, 1, 0, 1);

  table=gtk_table_new(2, 2, FALSE);  
  gtk_container_set_border_width(GTK_CONTAINER(table), 5);
  gtk_table_set_col_spacings(GTK_TABLE(table), 5);
  gtk_table_set_row_spacings(GTK_TABLE(table), 5);
  gtk_container_add(GTK_CONTAINER(frame), table);

  label = gtk_label_new("X: ");
  gtk_table_attach_defaults(GTK_TABLE(table), label, 0, 1, 0, 1);

  adj = (GtkAdjustment *)gtk_adjustment_new(0., 0., 1., .05, .10, .10);
  dialog->x_spin = gtk_spin_button_new(adj, 0, 3);
  gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(dialog->x_spin), TRUE);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(dialog->x_spin), text->x);
  gtk_widget_size_request(dialog->x_spin, &req);
  req.width /= 2;
  gtk_widget_set_usize(dialog->x_spin, req.width, req.height);
  gtk_table_attach_defaults(GTK_TABLE(table), dialog->x_spin, 1, 2, 0, 1);

  label = gtk_label_new("Y: ");
  gtk_table_attach_defaults(GTK_TABLE(table), label, 0, 1, 1, 2);

  adj = (GtkAdjustment *)gtk_adjustment_new(0., 0., 1., .05, .10, .10);
  dialog->y_spin = gtk_spin_button_new(adj, 0, 3);
  gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(dialog->y_spin), TRUE);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(dialog->y_spin), text->y);
  gtk_widget_size_request(dialog->y_spin, &req);
  req.width /= 2;
  gtk_widget_set_usize(dialog->y_spin, req.width, req.height);
  gtk_table_attach_defaults(GTK_TABLE(table), dialog->y_spin, 1, 2, 1, 2);

  label = gtk_label_new("Rotate (deg): ");
  gtk_table_attach_defaults(GTK_TABLE(table), label, 0, 1, 2, 3);


  adj = (GtkAdjustment *)gtk_adjustment_new(0., 0., 270., 90., 90., 0.);
  dialog->angle_spin = gtk_spin_button_new(adj, 90, 0);
  gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(dialog->angle_spin), TRUE);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(dialog->angle_spin), text->angle);
  gtk_entry_set_editable(GTK_ENTRY(dialog->angle_spin), FALSE);
  gtk_widget_size_request(dialog->angle_spin, &req);
  req.width /= 2;
  gtk_widget_set_usize(dialog->angle_spin, req.width, req.height);
  gtk_table_attach_defaults(GTK_TABLE(table), dialog->angle_spin, 1, 2, 2, 3);

  dialog->center_item = gtk_check_item_new_with_label("Centered");
  gtk_table_attach_defaults(GTK_TABLE(table), dialog->center_item, 0, 3, 3, 4);
  state = (text->justification == GTK_JUSTIFY_CENTER);
  gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(dialog->center_item), state);

/*                               
  dialog->hide_item = gtk_check_item_new_with_label("Hide");
  gtk_table_attach_defaults(GTK_TABLE(table), dialog->hide_item, 0, 2, 4, 5);
  state = (axis->label_mask != 0);
  gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(dialog->hide_item), state);
*/
 /*--------------------------------------*/
  frame = gtk_frame_new("Properties");
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_IN);
  gtk_table_attach_defaults(GTK_TABLE(main_table), frame, 1, 2, 0, 1);

  table=gtk_table_new(4, 2, FALSE);  
  gtk_container_set_border_width(GTK_CONTAINER(table), 5);
  gtk_table_set_col_spacings(GTK_TABLE(table), 5);
  gtk_table_set_row_spacings(GTK_TABLE(table), 5);
  gtk_container_add(GTK_CONTAINER(frame), table);

  label = gtk_label_new("Foreground ");
/*  gtk_misc_set_alignment(GTK_MISC(label), 1., 0.5);
*/
  gtk_table_attach_defaults(GTK_TABLE(table), label, 0, 1, 0, 1);
  dialog->fg_combo = gtk_color_combo_new();
  gtk_table_attach_defaults(GTK_TABLE(table), dialog->fg_combo, 1, 2, 0, 1);

  label = gtk_label_new("Background ");
/*  gtk_misc_set_alignment(GTK_MISC(label), 1., 0.5);
*/
  gtk_table_attach_defaults(GTK_TABLE(table), label, 0, 1, 1, 2);

  dialog->bg_combo = gtk_color_combo_new();
  gtk_table_attach_defaults(GTK_TABLE(table), dialog->bg_combo, 1, 2, 1, 2);

  label = gtk_label_new("Border ");
/*  gtk_misc_set_alignment(GTK_MISC(label), 1., 0.5);
*/
  gtk_table_attach_defaults(GTK_TABLE(table), label, 0, 1, 2, 3);
  dialog->border_combo = gtk_combo_new();
  gtk_widget_set_usize(dialog->border_combo, req.width, req.height);
  sg_combo_set_items(GTK_COMBO(dialog->border_combo), border_styles);
  gtk_entry_set_editable(GTK_ENTRY(GTK_COMBO(dialog->border_combo)->entry), FALSE);
  gtk_table_attach_defaults(GTK_TABLE(table), dialog->border_combo, 1, 2, 2, 3);

  dialog->transparent_item = gtk_check_item_new_with_label("Transparent");
  gtk_table_attach_defaults(GTK_TABLE(table), dialog->transparent_item, 0, 2, 3, 4);
  state = text->transparent;
  gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(dialog->transparent_item), state);

  /* connect signals */

  init_dialog(dialog);

  /* Show widgets */
  gtk_widget_show_all (main_box);

  return main_box;
}

GtkWidget *
sg_title_dialog_new(SGlayer *layer)
{
  GtkWidget *notebook;
  GtkPlot *plot;
  GtkWidget *dialog;

  plot = GTK_PLOT(layer->real_plot);
  notebook = gtk_notebook_new();

  switch(layer->type){
    case SG_LAYER_3D:
      dialog = sg_build_title_dialog(layer, plot->bottom, &text_dialog[0]);
      gtk_notebook_append_page(GTK_NOTEBOOK(notebook), dialog,
                               gtk_label_new("X"));
      dialog = sg_build_title_dialog(layer, plot->left, &text_dialog[1]);
      gtk_notebook_append_page(GTK_NOTEBOOK(notebook), dialog,
                               gtk_label_new("Y"));
      dialog = sg_build_title_dialog(layer, plot->top, &text_dialog[2]);
      gtk_notebook_append_page(GTK_NOTEBOOK(notebook), dialog,
                               gtk_label_new("Z"));
      break;
    case SG_LAYER_2D: 
      dialog = sg_build_title_dialog(layer, plot->left, &text_dialog[0]);
      gtk_notebook_append_page(GTK_NOTEBOOK(notebook), dialog,
                               gtk_label_new("Left"));
      dialog = sg_build_title_dialog(layer, plot->right, &text_dialog[1]);
      gtk_notebook_append_page(GTK_NOTEBOOK(notebook), dialog,
                               gtk_label_new("Right"));
      dialog = sg_build_title_dialog(layer, plot->top, &text_dialog[2]);
      gtk_notebook_append_page(GTK_NOTEBOOK(notebook), dialog,
                               gtk_label_new("Top"));
      dialog = sg_build_title_dialog(layer, plot->bottom, &text_dialog[3]);
      gtk_notebook_append_page(GTK_NOTEBOOK(notebook), dialog,
                               gtk_label_new("Bottom"));
      break;
    case SG_LAYER_POLAR: 
      dialog = sg_build_title_dialog(layer, plot->bottom, &text_dialog[0]);
      gtk_notebook_append_page(GTK_NOTEBOOK(notebook), dialog,
                               gtk_label_new("Angles"));
      dialog = sg_build_title_dialog(layer, plot->left, &text_dialog[1]);
      gtk_notebook_append_page(GTK_NOTEBOOK(notebook), dialog,
                               gtk_label_new("R"));
      break;
  }

  gtk_widget_show_all(notebook);

  return notebook;
}
