/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdlib.h>
#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>
#include "sg_matrix_dialog.h"
#include "sg.h"                       
#include "sg_stock.h"

static GtkWidget *rows_entry;
static GtkWidget *cols_entry;
static GtkWidget *xmin_entry;
static GtkWidget *xmax_entry;
static GtkWidget *ymin_entry;
static GtkWidget *ymax_entry;

static void
update_matrix(GtkWidget *widget, gpointer data)
{
  SGworksheet *matrix;
  gint nrows, ncols, orows, ocols;
  gint i, j;
  gint nlayers;
  gdouble x, y, width, height;
  gdouble xmin, xmax, ymin, ymax;
  gchar text[255];

  matrix = active_worksheet;

  orows = gtk_sheet_get_rows_count(GTK_SHEET(matrix->sheet)) - 1;
  ocols = gtk_sheet_get_columns_count(GTK_SHEET(matrix->sheet)) - 1;

  ncols = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(cols_entry));
  nrows = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(rows_entry));

  if(nrows != orows) sg_worksheet_add_rows(matrix, nrows - orows + 1);
  if(ncols != ocols) sg_worksheet_add_columns(matrix, ncols - ocols + 1);

  matrix->xmin = atof(gtk_entry_get_text(GTK_ENTRY(xmin_entry)));
  matrix->xmax = atof(gtk_entry_get_text(GTK_ENTRY(xmax_entry)));
  matrix->ymin = atof(gtk_entry_get_text(GTK_ENTRY(ymin_entry)));
  matrix->ymax = atof(gtk_entry_get_text(GTK_ENTRY(ymax_entry)));
}

static void
ok_clicked(GtkWidget *widget, gpointer data)
{
  update_matrix(widget, data);
  gtk_widget_destroy(widget);
}

static void
init_dialog()
{
  SGworksheet *matrix;
  gchar label[100];

  matrix = active_worksheet;

  gtk_spin_button_set_value(GTK_SPIN_BUTTON(rows_entry), 
                            gtk_sheet_get_rows_count(GTK_SHEET(matrix->sheet)));
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(cols_entry),
                            gtk_sheet_get_columns_count(GTK_SHEET(matrix->sheet)));

  sprintf(label, "%*.*f", 1, 3, matrix->xmin);
  gtk_entry_set_text(GTK_ENTRY(xmin_entry), label);
  sprintf(label, "%*.*f", 1, 3, matrix->xmax);
  gtk_entry_set_text(GTK_ENTRY(xmax_entry), label);
  sprintf(label, "%*.*f", 1, 3, matrix->ymin);
  gtk_entry_set_text(GTK_ENTRY(ymin_entry), label);
  sprintf(label, "%*.*f", 1, 3, matrix->ymax);
  gtk_entry_set_text(GTK_ENTRY(ymax_entry), label);

  sg_entry_set_numeric(GTK_ENTRY(xmin_entry), 3);
  sg_entry_set_numeric(GTK_ENTRY(xmax_entry), 3);
  sg_entry_set_numeric(GTK_ENTRY(ymin_entry), 3);
  sg_entry_set_numeric(GTK_ENTRY(ymax_entry), 3);
}


void
sg_matrix_dialog (void)
{
  GtkWidget *window = NULL;
  GtkWidget *frame;
  GtkWidget *main_box;
  GtkWidget *ok_button, *apply_button, *cancel_button;
  GtkWidget *action_area;
  GtkWidget *table;
  GtkWidget *label;
  GtkAdjustment *adj;
  GtkRequisition req;

  window=gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_policy(GTK_WINDOW(window), FALSE, FALSE, FALSE);
  gtk_window_set_title (GTK_WINDOW(window),"Matrix dimensions");

  gtk_window_set_modal (GTK_WINDOW(window),TRUE);
  /* Create widgets */
  main_box = gtk_vbox_new (FALSE,5);
  gtk_container_set_border_width(GTK_CONTAINER(main_box), 10);
  gtk_container_add (GTK_CONTAINER (window), main_box);

  frame = gtk_frame_new(NULL);
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_IN);
  gtk_box_pack_start (GTK_BOX (main_box), frame, FALSE, FALSE, 0);

  table = gtk_table_new(9, 4, FALSE);
  gtk_container_set_border_width(GTK_CONTAINER(table), 10);
  gtk_container_add(GTK_CONTAINER(frame), table);
  gtk_table_set_row_spacings(GTK_TABLE(table), 5);
  gtk_table_set_col_spacings(GTK_TABLE(table), 5);

  adj = (GtkAdjustment *)gtk_adjustment_new(0., 0., 1000000., 1., 0., 0.); 
  rows_entry = gtk_spin_button_new(adj, 0, 0);   
  adj = (GtkAdjustment *)gtk_adjustment_new(0., 0., 1000000., 1., 0., 0.); 
  cols_entry = gtk_spin_button_new(adj, 0, 0);   
  xmin_entry = gtk_entry_new();   
  xmax_entry = gtk_entry_new();   
  ymin_entry = gtk_entry_new();   
  ymax_entry = gtk_entry_new();   
  gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(rows_entry), TRUE);
  gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(cols_entry), TRUE);
  gtk_spin_button_set_digits(GTK_SPIN_BUTTON(rows_entry), 0);
  gtk_spin_button_set_digits(GTK_SPIN_BUTTON(cols_entry), 0);

  gtk_widget_size_request(cols_entry, &req);
  gtk_widget_set_usize(cols_entry, req.width, req.height);
  gtk_widget_set_usize(rows_entry, req.width, req.height);
  gtk_widget_set_usize(xmin_entry, req.width, req.height);
  gtk_widget_set_usize(xmax_entry, req.width, req.height);
  gtk_widget_set_usize(ymin_entry, req.width, req.height);
  gtk_widget_set_usize(ymax_entry, req.width, req.height);

/*
  gtk_table_attach_defaults(GTK_TABLE(table), 
                            gtk_label_new(""),
                            0, 2, 0, 1);
*/
  label = gtk_label_new("Number of rows"),
  gtk_misc_set_alignment(GTK_MISC(label), 1., 0.);
  gtk_table_attach_defaults(GTK_TABLE(table), 
                            label,
                            0, 2, 1, 2);
  label = gtk_label_new("Number of columns"),
  gtk_misc_set_alignment(GTK_MISC(label), 1., 0.);
  gtk_table_attach_defaults(GTK_TABLE(table), 
                            label,
                            0, 2, 2, 3);
  gtk_table_attach_defaults(GTK_TABLE(table), 
                            gtk_hseparator_new(),
                            0, 4, 3, 4);

  label = gtk_label_new("Xmin:"),
  gtk_misc_set_alignment(GTK_MISC(label), 1., 0.);
  gtk_table_attach_defaults(GTK_TABLE(table), 
                            label,
                            0, 1, 6, 7);
  label = gtk_label_new("Xmax:"),
  gtk_misc_set_alignment(GTK_MISC(label), 1., 0.);
  gtk_table_attach_defaults(GTK_TABLE(table), 
                            label,
                            2, 3, 6, 7);
  label = gtk_label_new("Ymin:"),
  gtk_misc_set_alignment(GTK_MISC(label), 1., 0.);
  gtk_table_attach_defaults(GTK_TABLE(table), 
                            label,
                            0, 1, 7, 8);
  label = gtk_label_new("Ymax:"),
  gtk_misc_set_alignment(GTK_MISC(label), 1., 0.);
  gtk_table_attach_defaults(GTK_TABLE(table), 
                            label,
                            2, 3, 7, 8);
  gtk_table_attach_defaults(GTK_TABLE(table), rows_entry, 2, 4, 1, 2);
  gtk_table_attach_defaults(GTK_TABLE(table), cols_entry, 2, 4, 2, 3);
  gtk_table_attach_defaults(GTK_TABLE(table), xmin_entry, 1, 2, 6, 7);
  gtk_table_attach_defaults(GTK_TABLE(table), xmax_entry, 3, 4, 6, 7);
  gtk_table_attach_defaults(GTK_TABLE(table), ymin_entry, 1, 2, 7, 8);
  gtk_table_attach_defaults(GTK_TABLE(table), ymax_entry, 3, 4, 7, 8);

  /* Action Area */
  action_area = gtk_hbutton_box_new ();
  gtk_button_box_set_layout(GTK_BUTTON_BOX(action_area), GTK_BUTTONBOX_SPREAD);
  gtk_button_box_set_spacing(GTK_BUTTON_BOX(action_area), 5);
  gtk_box_pack_end (GTK_BOX (main_box), action_area, FALSE, FALSE, 0);
  gtk_widget_show (action_area);

  ok_button = sg_stock_button(GNOME_STOCK_BUTTON_OK);
  GTK_WIDGET_SET_FLAGS (ok_button, GTK_CAN_DEFAULT);
  gtk_box_pack_start (GTK_BOX (action_area), ok_button, TRUE, TRUE, 0);
  gtk_widget_grab_default (ok_button);
  gtk_widget_show (ok_button);

  apply_button = sg_stock_button(GNOME_STOCK_BUTTON_APPLY);
  GTK_WIDGET_SET_FLAGS (apply_button, GTK_CAN_DEFAULT);
  gtk_box_pack_start (GTK_BOX (action_area), apply_button, TRUE, TRUE, 0);
  gtk_widget_show (apply_button);

  cancel_button = sg_stock_button(GNOME_STOCK_BUTTON_CANCEL);
  GTK_WIDGET_SET_FLAGS (cancel_button, GTK_CAN_DEFAULT);
  gtk_box_pack_start (GTK_BOX (action_area), cancel_button, TRUE, TRUE, 0);
  gtk_widget_show (cancel_button);

  /* connect signals */
  gtk_signal_connect_object (GTK_OBJECT (cancel_button), "clicked",
                             GTK_SIGNAL_FUNC (gtk_widget_destroy),
                             GTK_OBJECT (window));

  gtk_signal_connect_object (GTK_OBJECT (ok_button), "clicked",
                             GTK_SIGNAL_FUNC (ok_clicked),
                             GTK_OBJECT (window));

  gtk_signal_connect_object (GTK_OBJECT (apply_button), "clicked",
                             GTK_SIGNAL_FUNC (update_matrix),
                             GTK_OBJECT (window));

  /* Show widgets */

  init_dialog();

  gtk_widget_show_all (window);

  return;
}
