/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>
#ifdef WITH_GNOME
#include <zlib.h>
#endif
#include <Python.h>
#include "sg_file.h"
#include "sg.h"
#include "sg_dialogs.h"
#include "python/python_main.h"
#include "python/import_data.h"
#include "python/python_int.h"

gboolean
sg_worksheet_file_import_block(SGworksheet *worksheet, gchar *file)
{
  GtkSheet *sheet;
  GArray *array;
  GPtrArray *titles,*sarray;
  PyArrayObject *parray;
  PyObject *list,*tlist;
  gint row, col, x, y, i,temp_line,vert;
  gboolean newcol = TRUE;
  gboolean space = FALSE;
  gchar *line,delim[20]="";
  gchar label[255];

  sheet = GTK_SHEET(worksheet->sheet);
  row = 0;
  col = 0;

  if (use_custom_delimiter)
      strncat(delim,custom_delimiter,20);
  else
      switch (delimiter)
      {
          case SG_DELIMITER_COMMA:
             strncat(delim,",",20);
             break;

      }

  strncat(delim," \t\n",20);
  gtk_sheet_get_active_cell(sheet,&row,&col);

  if (precision_mod)
  {  
     if (read_method==0)
     {
         if (!read_all_lines) temp_line=end_line;
         array=read_table(file,comment_string, delim,NULL,0,begin_line,temp_line,&x, &y, &titles);
     }
     else
     {
         array=read_table(file,comment_string, delim,block_start,blocknum,0,0,&x, &y, &titles);
     }

     if (array)
     {
         parray=(PyArrayObject *)python_read_build_array(array, x, y);
         Py_INCREF(parray);
     }
   
     if (!array || !parray)
     {
       g_warning("ERROR: Could not import data from: %s", file);
       return FALSE;
     }
   
     python_insert_object(worksheet, row, col, (PyObject *)parray,
                          GTK_ORIENTATION_VERTICAL,TRUE,FALSE);
     g_array_free(array,TRUE);
     Py_XDECREF(parray);
  } /* !precision_mod*/
  else
  { 
     if (read_method==0)
     {
         if (!read_all_lines) temp_line=end_line;
         sarray=read_table_string(file,comment_string, delim,NULL,0,begin_line,temp_line,&x, &y, &titles);
     }
     else
     {
         sarray=read_table_string(file,comment_string, delim,block_start,blocknum,0,0,&x, &y, &titles);
     }
     if (sarray)
     {
         list=python_read_build_list(sarray, x, y);
         Py_INCREF(list);
     }
   
     if (!sarray || !list)
     {
       g_warning("ERROR: Could not import data from: %s", file);
       return FALSE;
     }
   
     python_insert_object(worksheet, (rename_columns?row:row+1), col, list,
                       GTK_ORIENTATION_VERTICAL,TRUE,TRUE);
     g_ptr_array_free_strings(sarray,TRUE,TRUE);

     if(titles && titles->len>0 && rename_columns)
        for (i=0;i<titles->len;i++)
         { 
             gtk_sheet_column_button_add_label(sheet, col+i, (gchar*)titles->pdata[i]);
             gtk_sheet_set_column_title(sheet, col+i, (gchar*)titles->pdata[i]);
         }

     if (!rename_columns && titles)
     {
         tlist=python_read_build_list(titles, x, 1);
         Py_INCREF(tlist);
         python_insert_object(worksheet, row, col, tlist,
                           GTK_ORIENTATION_VERTICAL,TRUE,TRUE);
         Py_XDECREF(tlist);
     }

     if (titles) g_ptr_array_free_strings(titles,TRUE,TRUE);
     Py_XDECREF(list);
  }

  return TRUE;
}


#ifdef WITH_WARNINGS
#warning Use better output system, see print_raw() function
#endif
gchar *
xml_get_string(gchar *input)
{
  gchar *c;
  gchar *output = NULL;
  gint n = 1;

  output = g_new(gchar,1);

  c = input;
  while(c && *c != '\0' && *c != '\n'){
    switch(*c){
        case '>':
          output = g_renew(gchar, output, (n + 3));
          output [n - 1] = '&';
          output [n] = 'g';
          output [n + 1] = 't';
          output [n + 2] = ';';
          n += 4;
          break;
        case '<':
          output = g_renew(gchar, output, (n + 3));
          output [n - 1] = '&';
          output [n] = 'l';
          output [n + 1] = 't';
          output [n + 2] = ';';
          n += 4;
          break;
        case '&':
          output = g_renew(gchar, output, (n + 4));
          output [n - 1] = '&';
          output [n] = 'a';
          output [n + 1] = 'm';
          output [n + 2] = 'p';
          output [n + 3] = ';';
          n += 5;
          break;
        case '\"':
          output = g_renew(gchar, output, (n + 5));
          output [n - 1] = '&';
          output [n] = 'q';
          output [n + 1] = 'u';
          output [n + 2] = 'o';
          output [n + 3] = 't';
          output [n + 4] = ';';
          n += 6;
          break;
        default:
          output = g_renew(gchar, output, n);
          output[n-1] = *c;
          n += 1;
          break;
    }
    c++;
  }

  output = (gchar *)g_realloc(output, n * sizeof(gchar));
  output[n-1] = '\0';
  return output;
}

FILE *
sg_fopen( gchar *filename, gchar *mode )
{
 if ( !sg_check_file_writeable(filename) ) return NULL;

 if (sg_compress_level)
 {   gchar pipe[500];
     g_snprintf(pipe, 500, "gzip -%df - > %s", sg_compress_level, filename);
     return popen(pipe, mode);
 }
 else
  return fopen(filename, mode);
}

gint
sg_fclose( FILE *stream )
{
 gint return_value;

 if (sg_compress_level)
    {/* save, disable and restore the SIGCHLD signal action */
     /* otherwise pclose kills the python terminal           */
     struct sigaction action, tmp_action;
     tmp_action.sa_handler = SIG_IGN;
     tmp_action.sa_flags = 0;
     sigemptyset(&tmp_action.sa_mask);
     sigaction(SIGCHLD, &tmp_action, &action);
     return_value = pclose(stream);
     sigaction(SIGCHLD, &action, NULL);
    }
 else
  return_value = fclose(stream);
  
 return return_value; 
}
