#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <unistd.h>
#include <time.h>
#include <qpopmenu.h>
#include <qkeycode.h>
#include <qaccel.h> 
#include <qfiledlg.h> 
#include <string.h>
#include <stdlib.h>
#include <kmsgbox.h> 
#include <qmsgbox.h> 
#include <ktopwidget.h>
#include <ktoolbar.h>
#include <qframe.h>
#include "ksplinedemo.h"
#include "klocale.h"
#include <kiconloader.h>
#define TRS klocale->translate

DisplayDlg::DisplayDlg(DrawWidget* DW, QWidget* parent=0, const char* name=0):
     QDialog (parent, name, WStyle_DialogBorder)
{
// Anzeigedialoch
char Strg[20];

   setFixedSize(250,200);
   Client=DW;
   QLabel *Label1 = new QLabel("XMin", this, "Label1");
   Label1->setGeometry(10,10,100,20);
   QLabel *Label2 = new QLabel("XMax", this, "Label2");
   Label2->setGeometry(10,40,100,20);
   QLabel *Label3 = new QLabel("YMin", this, "Label3");
   Label3->setGeometry(10,70,100,20);
   QLabel *Label4 = new QLabel("YMax", this, "Label4");
   Label4->setGeometry(10,100,100,20);
   
   Links = new KRestrictedLine(this, "Links", "0123456789.+-eE");
   Links->setGeometry(120,10,100,25);
   sprintf(Strg,"%0.2f", Client->l);
   Links->setText(Strg);

   Rechts = new KRestrictedLine(this, "Rechts", "0123456789.+-eE");
   Rechts->setGeometry(120,40,100,25);
   sprintf(Strg,"%0.2f", Client->r);
   Rechts->setText(Strg);

   Unten = new KRestrictedLine(this, "Unten", "0123456789.+-eE");
   Unten->setGeometry(120,70,100,25);
   sprintf(Strg,"%0.2f", Client->u);
   Unten->setText(Strg);

   Oben = new KRestrictedLine(this, "Oben", "0123456789.+-eE");
   Oben->setGeometry(120,100,100,25);
   sprintf(Strg,"%0.2f", Client->o);
   Oben->setText(Strg);
   
   
   // OK-Button
   QPushButton *OkBtn = new QPushButton(TRS("OK"), this, "OkBtn");
   OkBtn->setGeometry(10,170,80,30);
   connect(OkBtn, SIGNAL(clicked()), SLOT(accept()) );

   // cancel-Button
   QPushButton *AbortBtn = new QPushButton(TRS("Cancel"), this, "OkBtn");
   AbortBtn->setGeometry(110,170,80,30);
   connect(AbortBtn, SIGNAL(clicked()), SLOT(reject()) );
}

int DisplayDlg::SetParams(void) {
double L,R,O,U;
char* eptr;

   L = strtod(Links->text(), &eptr);
   if (*eptr!=0) return FALSE;
   R = strtod(Rechts->text(), &eptr);
   if (*eptr!=0) return FALSE;
   U = strtod(Unten->text(), &eptr);
   if (*eptr!=0) return FALSE;
   O = strtod(Oben->text(), &eptr);
   if (*eptr!=0) return FALSE;

   Client->l=L;
   Client->r=R;
   Client->u=U;
   Client->o=O;
   return TRUE;
}

SplineManDlg::SplineManDlg(DrawWidget* DW, QWidget* parent=0, const char* name=0):
     QDialog (parent, name, WStyle_DialogBorder)
{
// Spline manuell

   setFixedSize(350,300);
   Client=DW;
   Count = 0;
   
   QGroupBox *PointsGroup = new QGroupBox(this, "Spline Points");
   PointsGroup->setGeometry(10,10,330,130);
   
   QLabel *Label3 = new QLabel("No.", PointsGroup, "Label3");
   Label3->setGeometry(15,15,30,20);
   
   QLabel *Label1 = new QLabel("X:", PointsGroup, "Label1");
   Label1->setGeometry(15,45,30,20);
   QLabel *Label2 = new QLabel("Y:", PointsGroup, "Label2");
   Label2->setGeometry(15,70,30,20);
   
   PointLab = new QLabel("", PointsGroup, "PointLab");
   PointLab->setGeometry(60,15,30,20);

   PointX = new KRestrictedLine(PointsGroup, "PointX", "0123456789.+-eE");
   PointX->setGeometry(60,45,100,25);
   PointY = new KRestrictedLine(PointsGroup, "PointY", "0123456789.+-eE");
   PointY->setGeometry(60,70,100,25);

   // Prev
   QPushButton *PrevBtn = new QPushButton(TRS("Prev"), PointsGroup, "Prev");
   PrevBtn->setGeometry(180,10,50,30);
   connect(PrevBtn, SIGNAL(clicked()), SLOT(PrevClick()) );
    
   // Next
   QPushButton *NextBtn = new QPushButton(TRS("Next"), PointsGroup, "Next");
   NextBtn->setGeometry(230,10,50,30);
   connect(NextBtn, SIGNAL(clicked()), SLOT(NextClick()) );
   
   // First
   QPushButton *FirstBtn = new QPushButton(TRS("First"), PointsGroup, "First");
   FirstBtn->setGeometry(180,40,50,30);
   connect(FirstBtn, SIGNAL(clicked()), SLOT(FirstClick()) );
   
   // Last
   QPushButton *LastBtn = new QPushButton(TRS("Last"), PointsGroup, "Last");
   LastBtn->setGeometry(230,40,50,30);
   connect(LastBtn, SIGNAL(clicked()), SLOT(LastClick()) );
   
   // Delete
   QPushButton *DeleteBtn = new QPushButton(TRS("Delete"), PointsGroup, "Delete");
   DeleteBtn->setGeometry(180,70,50,30);
   connect(DeleteBtn, SIGNAL(clicked()), SLOT(DeleteClick()) );
   
   // Modify
   QPushButton *ModifyBtn = new QPushButton(TRS("Modify"), PointsGroup, "Modify");
   ModifyBtn->setGeometry(230,70,50,30);
   connect(ModifyBtn, SIGNAL(clicked()), SLOT(ModifyClick()) );
   
   // Neuer Sttzpunkt
   QGroupBox *NewGroup = new QGroupBox(this, "New Point");
   NewGroup->setGeometry(10,150,330,80);
   
   QLabel* Label4 = new QLabel("X:", NewGroup, "Label4");
   Label4->setGeometry(10,20,30,20);
   QLabel* Label5 = new QLabel("Y:", NewGroup, "Label5");
   Label5->setGeometry(10,50,30,20);

   NewX = new KRestrictedLine(NewGroup, "NewX", "0123456789.+-eE");
   NewX->setGeometry(60,20,100,25);
   NewY = new KRestrictedLine(NewGroup, "NewY", "0123456789.+-eE");
   NewY->setGeometry(60,50,100,25);

   // Add
   QPushButton *AddBtn = new QPushButton(TRS("Add"), NewGroup, "Add");
   AddBtn->setGeometry(180,40,50,30);
   connect(AddBtn, SIGNAL(clicked()), SLOT(AddClick()) );
   
   StatusLab = new QLabel("",this,"StatusLab");
   StatusLab->setGeometry(10,240,300,18);

   // Initialisieren
   if (Client->Spline->numPoints > 0) {
      DispPoint(0);  // ersten Punkt anzeigen
   }

   // OK-Button
   QPushButton *OkBtn = new QPushButton(TRS("OK"), this, "OkBtn");
   OkBtn->setGeometry(10,265,80,30);
   connect(OkBtn, SIGNAL(clicked()), SLOT(accept()) );

   // cancel-Button
   QPushButton *AbortBtn = new QPushButton(TRS("Cancel"), this, "OkBtn");
   AbortBtn->setGeometry(110,265,80,30);
   connect(AbortBtn, SIGNAL(clicked()), SLOT(reject()) );
}

void SplineManDlg::DispPoint(int Num) {
char S[20];
   //printf("n=%d\n",Client->Spline->numPoints());
   
   sprintf(S, "%d", Num);
   PointLab->setText(S);
   sprintf(S,"%0.3f", Client->Spline->getX(Num));
   PointX->setText(S);
   sprintf(S,"%0.3f", Client->Spline->getY(Num));
   PointY->setText(S);
}

void SplineManDlg::PrevClick() {
   if (Count > 0) {
      Count--;
      DispPoint(Count);
   }
}

void SplineManDlg::NextClick() {
   if (Count < Client->Spline->numPoints()-1) {
      Count++;
      DispPoint(Count);
   }
}

void SplineManDlg::FirstClick() {
   Count = 0;
   DispPoint(Count);
}

void SplineManDlg::LastClick() {
   Count = Client->Spline->numPoints()-1;
   DispPoint(Count);
}

void SplineManDlg::DeleteClick() {
int ret;
   //printf("DeleteClick\n");
   ret = Client->Spline->del(Count);
   StatusLab->setText(Client->Spline->errorText(ret));
   FirstClick();
}

void SplineManDlg::ModifyClick() {
char* eptr;
double x,y;
int ret;

   //printf("ModifyClick\n");
   x = strtod(PointX->text(), &eptr);
   if (*eptr!=0) return; 
   y = strtod(PointY->text(), &eptr);
   if (*eptr!=0) return; 
   
   //printf("modify now\n");
   ret = Client->Spline->modify(Count,x,y);
   StatusLab->setText(Client->Spline->errorText(ret));
}

void SplineManDlg::AddClick() {
char* eptr;
double x,y;
int ret;

   //printf("AddClick\n");

   x = strtod(NewX->text(), &eptr);
   if (*eptr!=0) return; 
   y = strtod(NewY->text(), &eptr);
   if (*eptr!=0) return; 
   
   //printf("Add now\n");
   ret=Client->Spline->add(x,y);
   StatusLab->setText(Client->Spline->errorText(ret));
}


SplineVisDlg::SplineVisDlg(DrawWidget* DW, QWidget* parent=0, const char* name=0):
     QDialog (parent, name, WStyle_DialogBorder)
{
// visueller Splinedialog
//char Strg[20];

   setFixedSize(350,300);
   Client=DW;
   
   SplEdit = new KSplineEdit(Client->Spline, this, "SplEdit");
//   SplEdit->setFrameStyle( QFrame::Box | QFrame::Sunken );
//   SplEdit->setLineWidth( 2 );
   SplEdit->setGeometry(10,10,330,200);
   SplEdit->setPosNeg(Client->PosNeg);
   SplEdit->setZoom(Client->Zoom);
   
   // Spline1
   QPushButton *Spl1Btn = new QPushButton("Spl1", this, "Spl1Btn");
   Spl1Btn->setGeometry(10,220,50,25);
   connect(Spl1Btn, SIGNAL(clicked()), SLOT(Spl1BtnClick()) );

   // Spline2
   QPushButton *Spl2Btn = new QPushButton("Spl2", this, "Spl2Btn");
   Spl2Btn->setGeometry(70,220,50,25);
   connect(Spl2Btn, SIGNAL(clicked()), SLOT(Spl2BtnClick()) );

   // OK-Button
   QPushButton *OkBtn = new QPushButton(TRS("OK"), this, "OkBtn");
   OkBtn->setGeometry(10,260,80,30);
   connect(OkBtn, SIGNAL(clicked()), SLOT(accept()) );

   // cancel-Button
   QPushButton *AbortBtn = new QPushButton(TRS("Cancel"), this, "OkBtn");
   AbortBtn->setGeometry(110,260,80,30);
   connect(AbortBtn, SIGNAL(clicked()), SLOT(reject()) );
}

void SplineVisDlg::Spl1BtnClick() {
//printf("Spl1\n");
   if (SplEdit->modified()) {
      if (QMessageBox::warning(this,"Changes","Changes made to Spline2, save?", 1, 2)==2)
         SplEdit->cancel();
   }
   SplEdit->setSpline(Client->Spline);
}

void SplineVisDlg::Spl2BtnClick() {
//printf("Spl2\n");
   if (SplEdit->modified()) {
      if (QMessageBox::warning(this,"Changes","Changes made to Spline1, save?", 1, 2)==2)
         SplEdit->cancel();
   }
   SplEdit->setSpline(Client->Spline2);
}


DrawWidget::DrawWidget( QWidget* parent=0, const char* name=0, WFlags f=0)
        : QWindow( parent, name, f ) {
   Paint = new QPainter();
   Spline = new SplineCurve();
   Spline2 = new SplineCurve();
   l=-0.1;
   r=1.1;
   u=-1.1;
   o=1.1;
   
   PosNeg = TRUE;
   Zoom = 1.0;
//printf("DrawWidget Constuktor\n");   
/*   Spline->add(0,0);
   Spline->add(1,1);
   Spline->add(0.5,0.5);*/
/*   Spline->add(0,0);
   Spline->add(1,1);
   Spline->add(2,2);
   Spline->add(4,4);
   Spline->add(3,0);
   Spline->add(-3,0);
   Spline->add(2.5,2.5);
   Spline->add(3,3);
   Spline->add(-1,3);*/

   Spline->add(0,0);
   Spline->add(0.2,0.6);
   Spline->add(0.7,0.2);
   Spline->add(1,1);

   Spline->TestAus();
   Spline->calcSpline();

   Spline2->add(0,1);
   Spline2->add(0.2,0.2);
   Spline2->add(0.7,0.6);
   Spline2->add(1,0);

}

DrawWidget::~DrawWidget() {
   delete Spline;
   delete Paint;
   Paint=0;
}

void DrawWidget::paintEvent(QPaintEvent*){
//printf("paintevent\n");      
   Plot();
}

void DrawWidget::Plot(void) {
int nx,ny;   // Nulllinien
double dx,dy; // Schrittweiten
int x,y,ay;  // aktuelle Werte, letzte Werte
int Lauf;

   Paint->begin(this);
   Paint->setPen(QRgb(0x00000000));
   dy=(o-u)/height();
   ny=(int)(-u/dy);
   dx=(r-l)/width();
   nx=(int)(-l/dx);
   Paint->drawLine(0,height()-ny,width(),height()-ny); //Waag
   Paint->drawLine(nx,0,nx,height());            // senkrecht
   Paint->drawLine(nx-2,height()-(int)(ny+1/dy),nx+2,height()-(int)(ny+1/dy));    //1 senk
   Paint->drawLine((int)(nx+1/dx),height()-ny-2,(int)(nx+1/dx),height()-ny+2);    //1 senk

   // Spline - Ausgabe der Knotenpunkte
   Paint->setPen(QRgb(0x000000FF));
   for (Lauf=0; Lauf<Spline->numPoints();Lauf++) {
     x = (int)(nx+Spline->getX(Lauf)/dx);
     y = (int)(height()-ny-Spline->getY(Lauf)/dy);
     Paint->drawLine(x-2,y,x+2,y);
     Paint->drawLine(x,y-2,x,y+2);
   }
   
   // Spline - Ausgabe der Funktion
   Paint->setPen(QRgb(0x00FF0000));
   ay = (int)(ny+Spline->spline(l)/dy);
   for (Lauf=1; Lauf<width(); Lauf++) {
      y = (int)(ny+Spline->spline(l+Lauf*dx)/dy);
      Paint->drawLine(Lauf-1,height()-ay,Lauf,height()-y);
      ay=y;
   }

   // Spline2 - Ausgabe der Knotenpunkte
   Paint->setPen(QRgb(0x000000FF));
   for (Lauf=0; Lauf<Spline2->numPoints();Lauf++) {
     x = nx+(int)(Spline2->getX(Lauf)/dx);
     y = height()-ny-(int)(Spline2->getY(Lauf)/dy);
     Paint->drawLine(x-2,y,x+2,y);
     Paint->drawLine(x,y-2,x,y+2);
   }
   
   // Spline2 - Ausgabe der Funktion
   Paint->setPen(QRgb(0x0000C000));
   ay = (int)(ny+Spline2->spline(l)/dy);
   for (Lauf=1; Lauf<width(); Lauf++) {
      y = (int)(ny+Spline2->spline(l+Lauf*dx)/dy);
      Paint->drawLine(Lauf-1,height()-ay,Lauf,height()-y);
      ay=y;
   }
   Paint->end();
}

int SplineWidget::initMenu() {

   QPopupMenu* SplineMenu = new QPopupMenu; 
   SplineMenu->insertItem(TRS("&Display"),        this, SLOT(MenuDisplay()),ALT+Key_D);
   SplineMenu->insertItem(TRS("&Spline manuell"), this, SLOT(MenuSplMan()), ALT+Key_M );
   SplineMenu->insertItem(TRS("&Spline visuell"), this, SLOT(MenuSplVis()), ALT+Key_V );
   SplineMenu->insertSeparator();
   SplineMenu->insertItem(TRS("&Exit"), qApp, SLOT(quit()), ALT+Key_X );
   MainMenu = new KMenuBar(this);
   MainMenu->insertItem(TRS("&Spline"), SplineMenu);
   setMenu(MainMenu);
      
   resize(640,480);
   show();
   return 0;
}

SplineWidget::SplineWidget() {
  Client = new DrawWidget(this);
  setView(Client);
  initMenu();
  setCaption(kapp->getCaption());
}


SplineWidget::~SplineWidget() {
  //delete toolbar;
  delete MainMenu;
}

void SplineWidget::MenuDisplay() {
//printf("MenuDisplay\n");
DisplayDlg DispDlg(Client, this, "Display settings");

   if (DispDlg.exec()) {
      if (DispDlg.SetParams())
         Client->update();
   }
}

void SplineWidget::MenuSplMan() {
SplineManDlg SMDlg(Client, this, "Spline manuell");
//printf("MenuSplMan\n");
   
   SMDlg.exec();
   Client->Spline->calcSpline();
   Client->update();
}

void SplineWidget::MenuSplVis() {
SplineVisDlg SVDlg(Client, this, "Spline visuell");
//printf("MenuSplVis\n");
   
   if (!SVDlg.exec())
      SVDlg.SplEdit->cancel();
   else {  // ok, Zoom-verte bernehmen
      Client->Zoom = SVDlg.SplEdit->zoom();
      Client->PosNeg = SVDlg.SplEdit->posNeg();
   }
   Client->update();
}

int main(int argc, char **argv) {
  KApplication a(argc,argv,"kspline");  

    SplineWidget *hw = new SplineWidget();
    a.setMainWidget(hw);
  
    return a.exec();
}

#include "ksplinedemo.moc"
