#ifndef KSPLINEEDIT_H
#define KSPLINEEDIT_H
#include <stdio.h>
#include <math.h>
#include <qwidget.h>
#include <qframe.h>
#include <qpushbt.h>
#include <qpainter.h>
#include <kkeyconf.h>
#include "kspline.h"

/**
* KSplineEdit ist das visuelle Interface zu SplineCurve.<br><br>
* <A HREF="#Einfuehrung">Einfhrung</A><br>
* <A HREF="#Maus">ndern mit der Maus</A><br>
* <A HREF="#Tastatur">Tastatur</A><br>
* <A HREF="#Buttons">Buttons</A><br>
* <A HREF="#UndoInf">Undo-Informationen</A><br>
*
* <a Name="Einfuehrung"><h4>Einfhrung</h4></a>
* Die Klasse <b>KSplineEdit</b> erlaubt das einfache Verndern eines Splines,
* der als SplineCurve definiert ist. Ich habe bewusst den Spline und das
* Editobjekt getrennt, damit nach der Einstellung des Splines der Dialog
* mit dem Edit-Widget wieder entfernt werden kann, aber der Spline weiterhin
* noch zur Verfgung steht. Alle nderungen an dem Spline werden sofort in das
* SplineCurve-Objekt bernommen. Sollen die nderungen nicht bernommen werden,
* mssen sie explizit wieder zckgngig gemacht werden.<br><br>
* Der Edit-Bereich des Splines ist auf den Bereich von 0.0 bis 1.0 fr die
* X- und Y-Werte begrenzt. Der zugrunde liegende Spline sollte mindestens
* zwei Sttzstellen enthalten, die auf den Randpunkten 0 und 1 liegen. Weitere
* Sttzstellen sollten in dem Zwischenbereich liegen.<br>
* Die aktive Sttzstelle ist <font color="#FF0000">rot</font> markiert 
* (alle anderen schwarz). Funktionen
* wie Lschen oder Einfgen beziehen sich auf diesen markierten Punkt.
*
* <a Name="Maus"><h4>ndern mit der Maus</h4></a>
* Die Sttzstellen sind durch Rechtecke markiert. Um den Punkt zu verschieben,
* mu man auf das Rechteck klicken und mit gedrckter Maustaste verschieben.
* Der Bereich, in dem sich der Punkt verschieben lt, ist nach links und 
* rechts durch die Nachbarpunkte vorgegeben.
*
* <a Name="Tastatur"><h4>Tastatur</h4></a>
* Alle Edit-Funktionen knnen auch mit der Tastatur erreicht werden. Folgende
* Zuordnung wird verwendet:
* <table border=0 cellspacing="1" cellpadding="4">
* <tr><th>Taste</th><th>Funktion</th></tr>
* <tr><td>Cursortasten</td><td>Verschieben des selektierten Punktes</td></tr>
* <tr><td>PgUp/PgDn</td><td>Wechseln der Sttzstelle</td></tr>
* <tr><td>Einfg(ins)</td><td>neue Sttzstelle erzeugen</td></tr>
* <tr><td>Entf(del)</td><td>Lschen der selektierten Sttzstelle</td></tr>
* <tr><td>N</td><td>Neuinitialisierung</td></tr>
* <tr><td>C</td><td>Konfigurationsdialog starten</td></tr>
* <tr><td>X</td><td>Undo</td></tr>
* </table>
* <a Name="Buttons"><h4>Buttons</h4></a>
* <h5>Ins</h5>
* Es wird eine neue Sttzstelle eingefgt. Der Punkt wird links mittig von dem
* markierten Punkt erzeugt. Der Y-Wert des neuen Punktes wird so gewhlt,
* da die Funktion nicht verndert wird (aber eine Sttzstelle mehr hat).
* <h5>Del</h5>
* Die markierte Sttzstelle wird gelscht. Der linke und rechte Randpunkt
* knnen nicht gelscht werden.
* <h5>New</h5>
* Ein neuer Spline wird erzeugt (in dem bestehenden SplineCurve-Objekt). Der
* Spline erhlt drei Sttzstellen mit den Koordinaten (0,0) (0.5,0.5) und (1.1).
* <h5>Conf</h5>
* Konfigurationsdialog aufrufen. In diesem Dialog knnen folgende Werte
* eingestellt werden:
* <ul>
* <li> natrlicher Spline / parametisierter Spline
* <li> Steigungen an den Randpunkten (wenn nicht natrlich)
* </ul>
* <h5>Undo</h5>
* Verwerfen der nderungen (seit dem letzten internen Speichern)
*
* <a Name="UndoInf"><h4>Unfo-Informationen</h4></a>
* Da das Spline-Objekt direkt verndert wird, mssen die Undo-Informationen
* getrennt gespeichert werden. Alle Daten des Splines werden in entspr.
* Puffern gescheichert und knnen von dort wieder in das Spline-Objekt
* zurckgeschrieben werden. Diese interne Speicherung erfolgt zu folgenden
* Zeitpunkten:
* <ul>
* <li> bei der Initialisierung des Splineedit-Objektes
* <li> nach einen Aufruf von setSpline()
* </ul>
* Mit der Funktion <i>modified</i> kann der nderungstatus erfragt werden.<br>
* Mit der Funktion <i>cancel</i> knnen die nderungen wieder zurckgenommen
* werden (seit dem letzten speichern).
*
* @short Visuelles ndern von Splines
* @author Jrgen Hochwald
* @version 0.2 (5.7.1998)
*/
class KSplineEdit : public QFrame {
   Q_OBJECT
public:
   /**
   *  Erzeugen des Edit-Objekes
   */
   KSplineEdit(SplineCurve* Spl, QWidget* parent=0, const char* name=0, WFlags f=0,bool allowLines=TRUE);
   /**
   * Verwefen aller nderungen, der Orginalzustand wird wiederhergestellt.
   */
   void cancel(void);
   /**
   * Wechseln des zu bearbeitenden Splines. Evtl. knnen vorher beim alten
   * Objekt mit cancel die nderungen verworfen werden.
   * @param Spl neues Splineobjekt
   * @see #cancel
   */
   void setSpline(SplineCurve* Spl);
   /**
   * berprft, ob nderungen vorgenommen wurden. Die nderungen werden seit
   * Erzeugung des Edit-Objektes oder seit Aufruf von 'setSpline' gespeichert.
   * @return TRUE nderungen liegen vor, FALSE keine nderungen
   */
   int modified(void);
   /**
   * Anzeige nur positive Werte oder positiv und negativ. Diese Funktion 
   * ermittelt den Zustand der Anzeige
   * @return TRUE Positive und negative Werte, FALSE nur pos. Werte
   */
   int posNeg();
   /**
   * Setzen der Anzeige
   * @param pn TRUE positiove und negative Werte (Nulllinie in der Mitte)
   * FALSE nur positive Werte
   */
   void setPosNeg(int pn);
   /**
   * Zoomfaktor fr die Anzeige abfragen. Der Zoom ist nur in Y-Richtung wirksam.
   * Grerer Wert bedeutet grere Vergrerung.
   * @return Wert des Zoomfaktors
   */
   double zoom(void);
   /**
   * Setzen des Zoomfaktors
   * @param z neuer Zoomfaktor
   */
   void setZoom(double z);
   
protected:
   void paintEvent( QPaintEvent * e);
   void resizeEvent( QResizeEvent * e);
   void keyPressEvent (QKeyEvent*);
   virtual void focusInEvent ( QFocusEvent * );
   virtual void focusOutEvent ( QFocusEvent * );
   void mouseMoveEvent (QMouseEvent*);
   void mousePressEvent (QMouseEvent*);
private slots:
   void AddBtnClick();
   void DelBtnClick();
   void NewBtnClick();
   void ConfBtnClick();
   void UndoBtnClick();
   void ZoomInBtnClick();
   void ZoomOutBtnClick();
   void PosNegBtnClick();
private:
   void Plot(void);
   void MovePoint(int x, int y);
   void MovePoint(double x, double y);
   void Save(void);
   void CalcD(void);  // Schittweiten dx und dy berechnen
   void PrintLabels(void);  // Texte auf den Labbels setzen
   double dx,dy;  // Schrittweiten
   int PosNeg;    // FALSE nur pos. Werte, TRUE pos. und neg. Werte
   double Zoom;   // Vergrerungsfaktor
   double GridSizeY;  // Gitterabstand Y
   int SplX,SplY; // Gre des Splinefensters
   int NullX;     // x-Nulllinie
   SplineCurve* Spline;
   QPushButton *AddBtn, *DelBtn, *NewBtn, *ConfBtn, *UndoBtn,
   *ZoomInBtn, *ZoomOutBtn, *PosNegBtn;
   QPainter* Paint;
   int CurPoint;  // aktive Sttzstelle (wird bei Tastaturereignissen gendert)
   int Ofs;       // Breite des Rahmens
   int Mod;       // Modified-Status (TRUE=derungen,FALSE=keine nd.)
   // Sicherungswerte fr "Cancel"
   double XSave[MAXPNTS], YSave[MAXPNTS], yp1, ypn;
   int ParaSave;
   QLabel *ZoomLab, *XLab, *YLab;
};
#endif
