#include <qbttngrp.h>
#include <qfiledlg.h>
#include <qglobal.h>
#include <qgrpbox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qpushbt.h>
#include <kapp.h>

#include "kfunction.h"
#include "kprintpreview.moc"

RCSTAG( "$Id: kprintpreview.cpp,v 3.1 1998/01/24 18:01:44 kde Exp $" );


KPrintPreviewDlg::KPrintPreviewDlg( QWidget* parent, QPrinter* _printer,
				    QPainter** _p ) :
  QDialog( parent, "PrintPreview", TRUE )
{
  setCaption( klocale->translate( "printer setup" ) );

  printer = _printer;
  painter = _p;

  pdm = new QPaintDeviceMetrics( printer );
  CHECK_PTR( pdm );

  resize( 300, 400 );

  QVBoxLayout* vbox = new QVBoxLayout( this, 5 );
  CHECK_PTR( vbox );

  QHBoxLayout* hbox = new QHBoxLayout();
  CHECK_PTR( hbox );
  vbox->addLayout( hbox, 1 );
  cbPaperSize = new KCombo( FALSE, this, "cbPaperSize" );
  CHECK_PTR( cbPaperSize );
  connect( cbPaperSize, SIGNAL( activated( int ) ), SLOT( update() ) );
  QLabel* label = new QLabel( cbPaperSize,
			      klocale->translate( "paper &size" ), this );
  CHECK_PTR( label );
  label->setFixedSize( label->sizeHint() );
  hbox->addWidget( label );
  hbox->addSpacing( 5 );
  hbox->addWidget( cbPaperSize, 2 );
  hbox->addStretch( 1 );

  QButtonGroup* btngrp = new QButtonGroup(
    klocale->translate( "orientation" ), this );
  CHECK_PTR( btngrp );
  connect( btngrp, SIGNAL( clicked( int ) ), SLOT( update() ) );
  vbox->addWidget( btngrp, 2 );
  QVBoxLayout* vbox2 = new QVBoxLayout( btngrp, 3 );
  CHECK_PTR( vbox2 );
  hbox = new QHBoxLayout();
  CHECK_PTR( hbox );
  vbox2->addSpacing( 12 );
  vbox2->addLayout( hbox );
  rbPortrait = new QRadioButton( klocale->translate( "portrait" ), btngrp );
  CHECK_PTR( rbPortrait );
  btngrp->insert( rbPortrait );
  hbox->addWidget( rbPortrait, 1 );
  rbLandscape = new QRadioButton( klocale->translate( "landscape" ), btngrp );
  CHECK_PTR( rbLandscape );
  btngrp->insert( rbLandscape );
  hbox->addWidget( rbLandscape, 1 );

  hbox = new QHBoxLayout();
  CHECK_PTR( hbox );
  vbox->addLayout( hbox, 1 );
  labelWidth = new QLabel( klocale->translate( "width: 999mm" ), this );
  CHECK_PTR( labelWidth );
  hbox->addWidget( labelWidth, 1 );
  labelHeight = new QLabel( klocale->translate( "height: 999mm" ), this );
  CHECK_PTR( labelHeight );
  hbox->addWidget( labelHeight, 1 );

  btngrp = new QButtonGroup(
    klocale->translate( "print to" ), this );
  CHECK_PTR( btngrp );
  vbox->addWidget( btngrp, 2 );
  vbox2 = new QVBoxLayout( btngrp, 3 );
  CHECK_PTR( vbox2 );
  hbox = new QHBoxLayout();
  CHECK_PTR( hbox );
  vbox2->addSpacing( 12 );
  vbox2->addLayout( hbox );
  rbPrinter = new QRadioButton( klocale->translate( "printer" ), btngrp );
  CHECK_PTR( rbPrinter );
  btngrp->insert( rbPrinter );
  hbox->addWidget( rbPrinter, 1 );
  rbFile = new QRadioButton( klocale->translate( "file" ), btngrp );
  CHECK_PTR( rbFile );
  btngrp->insert( rbFile );
  hbox->addWidget( rbFile, 1 );

  QGroupBox* grpbox = new QGroupBox( klocale->translate( "margins [mm]" ),
				     this );
  CHECK_PTR( grpbox );
  vbox->addWidget( grpbox, 5 );
  vbox2 = new QVBoxLayout( grpbox, 4 );
  vbox2->addSpacing( 12 );  

  hbox = new QHBoxLayout();
  CHECK_PTR( hbox );
  vbox2->addLayout( hbox, 1 );
  ilLeft = new KIntegerLine( grpbox );
  CHECK_PTR( ilLeft );
  connect( ilLeft, SIGNAL( textChanged( const char* ) ),
	   SLOT( updateUnits_size_x() ) );
  label = new QLabel( ilLeft, klocale->translate( "&left" ), grpbox );
  CHECK_PTR( label );
  hbox->addWidget( label, 1 );
  hbox->addWidget( ilLeft, 2 );

  hbox = new QHBoxLayout();
  CHECK_PTR( hbox );
  vbox2->addLayout( hbox, 1 );
  ilRight = new KIntegerLine( grpbox );
  CHECK_PTR( ilRight );
  connect( ilRight, SIGNAL( textChanged( const char* ) ),
	   SLOT( updateUnits_size_x() ) );
  label = new QLabel( ilRight, klocale->translate( "&right" ), grpbox );
  CHECK_PTR( label );
  hbox->addWidget( label, 1 );
  hbox->addWidget( ilRight, 2 );

  hbox = new QHBoxLayout();
  CHECK_PTR( hbox );
  vbox2->addLayout( hbox, 1 );
  ilTop = new KIntegerLine( grpbox );
  CHECK_PTR( ilTop );
  connect( ilTop, SIGNAL( textChanged( const char* ) ),
	   SLOT( updateUnits_size_y() ) );
  label = new QLabel( ilTop, klocale->translate( "&top" ), grpbox );
  CHECK_PTR( label );
  hbox->addWidget( label, 1 );
  hbox->addWidget( ilTop, 2 );

  hbox = new QHBoxLayout();
  CHECK_PTR( hbox );
  vbox2->addLayout( hbox, 1 );
  ilBottom = new KIntegerLine( grpbox );
  CHECK_PTR( ilBottom );
  connect( ilBottom, SIGNAL( textChanged( const char* ) ),
	   SLOT( updateUnits_size_y() ) );
  label = new QLabel( ilBottom, klocale->translate( "&bottom" ), grpbox );
  CHECK_PTR( label );
  hbox->addWidget( label, 1 );
  hbox->addWidget( ilBottom, 2 );

  grpbox = new QGroupBox( klocale->translate( "units" ), this );
  CHECK_PTR( grpbox );
  vbox->addWidget( grpbox, 3 );
  vbox2 = new QVBoxLayout( grpbox, 4 );
  vbox2->addSpacing( 12 );  

  hbox = new QHBoxLayout();
  CHECK_PTR( hbox );
  vbox2->addLayout( hbox, 1 );
  ilUnit_x = new KIntegerLine( grpbox );
  CHECK_PTR( ilUnit_x );
  connect( ilUnit_x, SIGNAL( textChanged( const char* ) ),
	   SLOT( updateUnits_unit_x() ) );
  label = new QLabel( ilLeft, "x: 1 =>", grpbox );
  CHECK_PTR( label );
  hbox->addWidget( label, 1 );
  hbox->addWidget( ilUnit_x, 2 );
  label = new QLabel( "mm", grpbox );
  CHECK_PTR( label );
  label->setFixedSize( label->sizeHint() );
  hbox->addWidget( label, 1 );

  hbox = new QHBoxLayout();
  CHECK_PTR( hbox );
  vbox2->addLayout( hbox, 1 );
  ilUnit_y = new KIntegerLine( grpbox );
  CHECK_PTR( ilUnit_y );
  connect( ilUnit_y, SIGNAL( textChanged( const char* ) ),
	   SLOT( updateUnits_unit_y() ) );
  label = new QLabel( ilLeft, "y: 1 =>", grpbox );
  CHECK_PTR( label );
  hbox->addWidget( label, 1 );
  hbox->addWidget( ilUnit_y, 2 );
  label = new QLabel( "mm", grpbox );
  CHECK_PTR( label );
  label->setFixedSize( label->sizeHint() );
  hbox->addWidget( label, 1 );

  hbox = new QHBoxLayout();
  CHECK_PTR( hbox );
  vbox->addSpacing( 5 );
  vbox->addLayout( hbox, 2 );
  QPushButton* btn = new QPushButton( klocale->translate( "&Ok" ), this );
  CHECK_PTR( btn );
  btn->setDefault( TRUE );
  hbox->addStretch( 1 );
  hbox->addWidget( btn, 2 );
  hbox->addStretch( 1 );
  connect( btn, SIGNAL( clicked() ), SLOT( ok() ) );

  btn = new QPushButton( klocale->translate( "Cancel" ), this );
  CHECK_PTR( btn );
  connect( btn, SIGNAL( clicked() ), SLOT( cancel() ) );
  hbox->addWidget( btn, 2 );
  hbox->addStretch( 1 );

  cbPaperSize->insertItem( "A4" );
  cbPaperSize->insertItem( "B5" );
  cbPaperSize->insertItem( "Letter" );
  cbPaperSize->insertItem( "Legal" );
  cbPaperSize->insertItem( "Executive" );
  QPrinter::PageSize pageSize = printer->pageSize();
  switch( pageSize ) {
  case QPrinter::A4: { cbPaperSize->setCurrentItem( 0 ); break; }
  case QPrinter::B5: { cbPaperSize->setCurrentItem( 1 ); break; }
  case QPrinter::Letter: { cbPaperSize->setCurrentItem( 2 ); break; }
  case QPrinter::Legal: { cbPaperSize->setCurrentItem( 3 ); break; }
  case QPrinter::Executive: { cbPaperSize->setCurrentItem( 4 ); break; }
  } // switch

  QPrinter::Orientation orientation = printer->orientation();
  if ( orientation == QPrinter::Portrait ) rbPortrait->setChecked( TRUE );
  else rbLandscape->setChecked( TRUE );

  rbPrinter->setChecked( TRUE );

  ilLeft->setText( "0" );
  ilRight->setText( "0" );
  ilTop->setText( "0" );
  ilBottom->setText( "0" );

  fSetByProgram = FALSE;

  update();
} // KPrintPreviewDlg constructor


void
KPrintPreviewDlg::update()
{
  int n = cbPaperSize->currentItem();
  if ( n == 0 ) printer->setPageSize( QPrinter::A4 );
  else if ( n == 1 ) printer->setPageSize( QPrinter::B5 );
  else if ( n == 2 ) printer->setPageSize( QPrinter::Letter );
  else if ( n == 3 ) printer->setPageSize( QPrinter::Legal );
  else printer->setPageSize( QPrinter::Executive );

  if ( rbPortrait->isChecked() ) printer->setOrientation( QPrinter::Portrait );
  else printer->setOrientation( QPrinter::Landscape );

  QString s;
  s.sprintf( klocale->translate( "width: %dmm" ), pdm->widthMM() );
  labelWidth->setText( s );
  s.sprintf( klocale->translate( "height: %dmm" ), pdm->heightMM() );
  labelHeight->setText( s );

  updateUnits_size_x();
  updateUnits_size_y();
} // KPrintPreviewDlg::update


void
KPrintPreviewDlg::updateUnits_size_x()
{
  if ( fSetByProgram ) { fSetByProgram = FALSE; return; }

  QString s;
  s = ilLeft->text();
  int margin_l = s.toInt();
  s = ilRight->text();
  int margin_r = s.toInt();

  float x_1 = static_cast<float>( ( pdm->widthMM() - margin_l - margin_r ) ) /
    ( maxX - minX );
  s.setNum( rint( x_1 ) );

  fSetByProgram = TRUE;
  ilUnit_x->setText( s );
} // KPrintPreviewDlg::updateUnits_size_x

void
KPrintPreviewDlg::updateUnits_size_y()
{
  if ( fSetByProgram ) { fSetByProgram = FALSE; return; }

  QString s;
  s = ilTop->text();
  int margin_t = s.toInt();
  s = ilBottom->text();
  int margin_b = s.toInt();

  float y_1 = static_cast<float>( ( pdm->heightMM() - margin_t - margin_b ) ) /
    ( maxY - minY );
  s.setNum( rint( y_1 ) );

  fSetByProgram = TRUE;
  ilUnit_y->setText( s );
} // KPrintPreviewDlg::updateUnits_size_y

void
KPrintPreviewDlg::updateUnits_unit_x()
{
  if ( fSetByProgram ) { fSetByProgram = FALSE; return; }

  QString s;
  s = ilUnit_x->text();
  int x_1 = s.toInt();

  float margins_x = ( static_cast<float>( -x_1 ) * ( maxX - minX ) +
    pdm->widthMM() ) / 2;
  s.setNum( rint( margins_x ) );
  fSetByProgram = TRUE;
  ilLeft->setText( s );
  fSetByProgram = TRUE;
  ilRight->setText( s );
} // KPrintPreviewDlg::updateUnits_unit_x

void
KPrintPreviewDlg::updateUnits_unit_y()
{
  if ( fSetByProgram ) { fSetByProgram = FALSE; return; }

  QString s;
  s = ilUnit_y->text();
  int y_1 = s.toInt();

  float margins_y = ( static_cast<float>( -y_1 ) * ( maxY - minY ) +
    pdm->heightMM() ) / 2;
  s.setNum( rint( margins_y ) );
  fSetByProgram = TRUE;
  ilTop->setText( s );
  fSetByProgram = TRUE;
  ilBottom->setText( s );
} // KPrintPreviewDlg::updateUnits_unit_y


void
KPrintPreviewDlg::ok()
{
  if ( rbFile->isChecked() ) {
    printer->setOutputToFile( TRUE );
    QString fileName = QFileDialog::getSaveFileName( 0, "*.ps", this );
    if( !fileName.data() ) { done( FALSE ); return; }
    else printer->setOutputFileName( fileName );
  } // if

  int n = cbPaperSize->currentItem();
  if ( n == 0 ) printer->setPageSize( QPrinter::A4 );
  else if ( n == 1 ) printer->setPageSize( QPrinter::B5 );
  else if ( n == 2 ) printer->setPageSize( QPrinter::Letter );
  else if ( n == 3 ) printer->setPageSize( QPrinter::Legal );
  else printer->setPageSize( QPrinter::Executive );

  if ( rbPortrait->isChecked() ) printer->setOrientation( QPrinter::Portrait );
  else printer->setOrientation( QPrinter::Landscape );

  *painter = new QPainter( printer );
  CHECK_PTR( *painter );

  // calculating in float to be (much) more precise
  // dots per mm
  float dpmm_x = static_cast<float>( pdm->width() ) / pdm->widthMM();
  float dpmm_y = static_cast<float>( pdm->height() ) / pdm->heightMM();

  QString s;
  s = ilLeft->text();
  int margin_l = static_cast<int>( dpmm_x * s.toInt() );
  s = ilRight->text();
  int margin_r = static_cast<int>( dpmm_x * s.toInt() );
  s = ilTop->text();
  int margin_t = static_cast<int>( dpmm_y * s.toInt() );
  s = ilTop->text();
  int margin_b = static_cast<int>( dpmm_y * s.toInt() );

  (*painter)->setViewport( margin_l, margin_t,
			   pdm->width() - margin_l - margin_r,
			   pdm->height() - margin_t - margin_b );

  done( TRUE );
} // KPrintPreviewDlg::ok


void
KPrintPreviewDlg::cancel()
{
  done( FALSE );
} // KPrintPreviewDlg::cancel
