#include "kplotwin.moc"

RCSTAG( "$Id: kplotwin.cpp,v 3.2 1998/01/25 18:08:03 kde Exp $" );

#include <qkeycode.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qpainter.h>
#include <qpdevmet.h>
#include <qpushbt.h>
#include <qvalidator.h>
#include <kcolordlg.h>

#include "kfunction.h"

//#define __DEBUG

// declared "extern" in kfunction.h
double minX, minY, maxX, maxY;
int showGrid; double gridX, gridY; QColor gridColor; PenStyle gridPenStyle;

QList<KTextLabel> Labels;

void paintExpressions( QPaintDevice* pd, QPainter* p )
{
  QPaintDeviceMetrics pdm( pd );

  if ( minX > maxX ) {
    double tempX = maxX;
    maxX = minX;
    minX = tempX;
  } // if

  if ( minY > maxY ) {
    double tempY = maxY;
    maxY = minY;
    minY = tempY;
  } // if

  int h = pdm.height();
  double deltaX = ( maxX - minX ) / pdm.width();
  double deltaY = ( maxY - minY ) / h;

  paintGrid( pd, p, h, deltaX, deltaY );
  paintLabels( pd, p, h, deltaX, deltaY );

  // prepare a thicker pen for the axes
  p->setPen( QPen( black, 2 ) );

  // plot axes
  if ( ( minX < 0 ) && ( maxX > 0 ) ) {
    int x_0 = static_cast<int>( -minX / deltaX );
    p->moveTo( x_0, 0 );
    p->lineTo( x_0, pdm.height() );
  } // if

  if ( ( minY < 0 ) && ( maxY > 0 ) ) {
    int y_0 = static_cast<int>( h + minY / deltaY );
    p->moveTo( 0, y_0 );
    p->lineTo( pdm.width(), y_0 );
  } // if

  uint n;
  KFunction* f;
  for( n = 0; n < functions->count(); n++ ) {
    f = functions->at( n );
    f->expression.plot( pd, p, f->pen, minX, minY, maxX, maxY );
  } // for

  p->end();
  delete p;
} // paintExpressions



void
paintGrid( QPaintDevice* pd, QPainter* p, int h, double deltaX, double deltaY )
{
  int x_0, y_0;
  double X, Y;
  QPen savePen;

  QPaintDeviceMetrics pdm( pd );

  if ( ( minX <= 0 ) && ( maxX >= 0 ) ) x_0 =
					  static_cast<int>( -minX / deltaX );
  else x_0 = 0;
  X = 0;

  if ( ( minY <= 0 ) && ( maxY >= 0 ) ) y_0 =
					 static_cast<int>( h + minY / deltaY );
  else y_0 = h;
  Y = 0;

  int x_screen = static_cast<int>( ( X - minX ) / deltaX );
  int y_screen = h - static_cast<int>( ( Y - minY ) / deltaY ) - 1;

  QString s;

  if ( ( showGrid == grid_Axes ) || ( showGrid == grid_Grid ) ||
       ( showGrid == grid_Dots ) ) {
    p->setPen( QPen( gridColor , 0,
		     showGrid == grid_Grid ? gridPenStyle : SolidLine
		     ) );

    while ( x_screen > 0 ) {
      X -= gridX;
      x_screen = static_cast<int>( ( X - minX ) / deltaX );
    } // while

    while ( x_screen < pdm.width() ) {
      if ( ( showGrid == grid_Axes ) || ( showGrid == grid_Dots ) ) {
	if ( showGrid == grid_Dots ) {
	  while ( y_screen > 0 ) {
	    Y += gridY;
	    y_screen = h - static_cast<int>( ( Y - minY ) / deltaY ) - 1;
	  } // while

	  while ( y_screen < pdm.height() ) {
	    p->moveTo( x_screen - 1, y_screen );
	    p->lineTo( x_screen + 1, y_screen );
	    p->moveTo( x_screen, y_screen - 1 );
	    p->lineTo( x_screen, y_screen + 1 );
	  
	    Y -= gridY;
	    y_screen = h - static_cast<int>( ( Y - minY ) / deltaY ) - 1;
	  } // while
	} // if

	QPen penTemp = p->pen();
	p->setPen( QPen( black, 0 ) );
	p->moveTo( x_screen, y_0 - 5 );
	p->lineTo( x_screen, y_0 + 5 );
	p->setPen( penTemp );
      } // if
      else {
	p->moveTo( x_screen, 0 );
	p->lineTo( x_screen, h );
      } // else

      savePen = p->pen();
      p->setPen( black );
      s.setNum( X );
      p->drawText( x_screen + 2, y_0 - 2, s );
      p->setPen( savePen );
      X += gridX;
      x_screen = static_cast<int>( ( X - minX ) / deltaX );
    } // while

    if ( ( showGrid == grid_Axes ) || ( showGrid == grid_Grid ) ||
	 ( showGrid == grid_Dots ) ) {
      while ( y_screen > 0 ) {
	Y += gridY;
        y_screen = h - static_cast<int>( ( Y - minY ) / deltaY ) - 1;
      } // while

      while ( y_screen < pdm.height() ) {
	if ( ( showGrid == grid_Axes ) || ( showGrid == grid_Dots ) ) {
	  QPen penTemp = p->pen();
	  p->setPen( QPen( black, 0 ) );
	  p->moveTo( x_0 - 5, y_screen );
	  p->lineTo( x_0 + 5, y_screen );
	  p->setPen( penTemp );
	}
	else {
	  p->moveTo( 0, y_screen );
	  p->lineTo( pdm.width(), y_screen );
	}
	savePen = p->pen();
	p->setPen( black );
	s.setNum( Y );
	p->drawText( x_0 + 2, y_screen - 2, s );
	p->setPen( savePen );
	Y -= gridY;
	y_screen = h - static_cast<int>( ( Y - minY ) / deltaY ) - 1;
      } // while
    } // if
  } // if

  else if ( showGrid == grid_Off ) {
    p->drawText( x_0+3, h-5, "0" );

    QString s1, s2;
    s1.setNum( minX );
    s2 = "(" + s1 + "|";
    s1.setNum( minY );
    s2 += s1 + ")";
    p->drawText( 5, pdm.height()-5, s2 );

    s1.setNum( maxX );
    s2 = "(" + s1 + "|";
    s1.setNum( maxY );
    s2 += s1 + ")";

    p->drawText( 5, 5, pdm.width()-10, pdm.height()-10, AlignRight | AlignTop,
		 s2 );
    p->drawText( 5, y_0+3, pdm.width()-10, 20, AlignRight | AlignTop, "0" );
  } // else if
} // paintGrid


void
paintLabels( QPaintDevice*, QPainter* p, int h, double deltaX,
	     double deltaY )
{
  QListIterator<KTextLabel> it( Labels );

  KTextLabel* label;
  for ( ; ( label = it.current() ); ++it ) {
      int x_screen = static_cast<int>( ( label->x - minX ) / deltaX );
      int y_screen = h - static_cast<int>( ( label->y - minY ) / deltaY ) - 1;
      p->setPen( QPen( label->color, 0 ) );
      if ( label->showCross != KTextLabel::off ) {
	p->moveTo( x_screen, y_screen - 2 );
	p->lineTo( x_screen, y_screen + 2 );
	p->moveTo( x_screen - 2, y_screen );
	p->lineTo( x_screen + 2, y_screen );
      } // if

      QFontMetrics fm = p->fontMetrics();
      // returns a too small rectangle?!?
      QRect r = fm.boundingRect( label->text );
      // resizing shouldn't be a bad thing as we use alignment
      r.setHeight( r.height() + 5 );
      r.setWidth( r.width() + 5 );
      switch( label->showCross ) {
      case KTextLabel::off: {
	p->drawText( x_screen, y_screen, label->text );
	break;
      } // case
      case KTextLabel::leftTop: {
	r.moveTopLeft( QPoint( x_screen + 2, y_screen + 2 ) );
	p->drawText( r, AlignLeft || AlignTop, label->text );
	break;
      } // case
      case KTextLabel::leftBottom: {
	r.moveBottomLeft( QPoint( x_screen + 2, y_screen - 2 ) );
	p->drawText( r, AlignLeft || AlignBottom, label->text );
	break;
      } // case
      case KTextLabel::rightTop: {
	r.moveTopRight( QPoint( x_screen - 2, y_screen + 2 ) );
	p->drawText( r, AlignRight || AlignTop, label->text );
	break;
      } // case
      case KTextLabel::rightBottom: {
	r.moveBottomRight( QPoint( x_screen - 2, y_screen - 2 ) );
	p->drawText( r, AlignRight || AlignBottom, label->text );
	break;
      } // case
      } // switch
  } // for
} // paintLabels



KPlotWindow::KPlotWindow( QWidget* parent ) : QWidget( parent )
{
  setMouseTracking( TRUE );
  setBackgroundColor( white );
  setCursor( crossCursor );

  painter = static_cast<QPainter*>( NULL );
  rectStart = FALSE;
  addLabelMode = FALSE;

  lastViewports = new QStack<KViewport>;
  CHECK_PTR( lastViewports );
} // KPlotWindow constructor


KPlotWindow::~KPlotWindow()
{
  delete lastViewports; // not a child of this object
} // KPlotWindow


void
KPlotWindow::unzoom()
{
  if ( lastViewports->isEmpty() ) return;

  KViewport* vp = lastViewports->pop();
  minX = vp->minX;
  minY = vp->minY;
  maxX = vp->maxX;
  maxY = vp->maxY;
  delete vp;

  deltaX = ( maxX - minX ) / width();
  deltaY = ( maxY - minY ) / height();

  repaint( TRUE );
} // unzoom


void
KPlotWindow::addLabel()
{
  setCursor( ibeamCursor );
  addLabelMode = TRUE;
} // addLabel


void
KPlotWindow::paintEvent( QPaintEvent* )
{
#ifdef __DEBUG
  debug( "KPlotWindow::paintEvent called" );
#endif

  QPainter* p = new QPainter( this );
  CHECK_PTR( p );
  paintExpressions( this, p );
} // KPlotWindow::paintEvent


void
KPlotWindow::resizeEvent( QResizeEvent* e )
{
  QWidget::resizeEvent( e );

  h = height();
  deltaX = ( maxX - minX ) / width();
  deltaY = ( maxY - minY ) / h;
} // KPlotWindow::resizeEvent


void
KPlotWindow::mouseMoveEvent( QMouseEvent* e )
{
  int x_screen = e->x();
  int y_screen = e->y();

  double x_r = deltaX * x_screen + minX;
  double y_r = ( h - y_screen ) * deltaY + minY;

  emit mouseAt( x_r, y_r );

  if ( rectStart ) {
    int x = e->pos().x();
    int y = e->pos().y();

    if ( !painter ) {
#ifdef __DEBUG
      debug( "no painter in KPlotWindow::mouseMoveEvent()" );
#endif
      return;
    } // if

    painter->begin( this );
    painter->setRasterOp( NotROP );
    painter->drawRect( rectX1, rectY1, rectX2 - rectX1, rectY2 - rectY1 );
    painter->end();

    int x1 = rectX1;
    int y1 = rectY1;
    int tmp;

    if ( x1 > x ) { tmp = x1; x1 = x; x = tmp; }
    if ( y1 > y ) { tmp = y1; y1 = y; y = tmp; }

    rectX2 = e->pos().x();
    rectY2 = e->pos().y();

    painter->begin( this );
    painter->setRasterOp( NotROP );
    painter->drawRect( rectX1, rectY1, rectX2 - rectX1, rectY2 - rectY1 );
    painter->end();
  } // if
} // KPlotWindow::mouseMoveEvent


void
KPlotWindow::mousePressEvent( QMouseEvent* e )
{
  rectStart = FALSE;

  if ( addLabelMode ) return;

  if ( e->button() == LeftButton ) {
    rectStart = TRUE;
    rectX1 = rectX2 = e->pos().x();
    rectY1 = rectY2 = e->pos().y();

    if ( !painter ) {
      painter = new QPainter;
      CHECK_PTR( painter );
    } // if
  } // if
} // KPlotWindow::mousePressEvent


void
KPlotWindow::mouseReleaseEvent( QMouseEvent* e )
{
  if ( addLabelMode ) {
    KTextLabel* lab = new KTextLabel;
    CHECK_PTR( lab );
    lab->x = deltaX * e->pos().x() + minX;
    lab->y = ( h - e->pos().y() ) * deltaY + minY;
    lab->color = black;
    lab->showCross = KTextLabel::off;

    KGetLabelTextDlg* dlg = new KGetLabelTextDlg( this, lab );
    CHECK_PTR( dlg );
    if ( dlg->exec() ) {
      Labels.append( lab );
      repaint( FALSE );
    } // if
    else delete lab;
    delete dlg;

    addLabelMode = FALSE;
    setCursor( crossCursor );
    return;
  } // if

  if ( rectStart ) {
    rectStart = FALSE;

    if ( ( fabs( rectX2 - rectX1 ) <= 5 ) || ( fabs( rectY2 - rectY1 ) <= 5 ) )
      {
	// just a click
	painter->begin( this );
	painter->setRasterOp( NotROP );
	painter->drawRect( rectX1, rectY1, rectX2 - rectX1, rectY2 - rectY1 );
	painter->end();

	delete painter;
	painter = static_cast<QPainter*>( NULL );
	return;
      }

    // save the current viewport onto the stack
    KViewport* vp = new KViewport;
    CHECK_PTR( vp );
    vp->minX = minX; vp->minY = minY;
    vp->maxX = maxX; vp->maxY = maxY;
    lastViewports->push( vp );

    // and set the new one
    double minX_new = deltaX * rectX1 + minX;
    double minY_new = ( h - rectY2 ) * deltaY + minY;
    maxX = deltaX * rectX2 + minX;
    maxY = ( h - rectY1 ) * deltaY + minY;

    minX = minX_new;
    minY = minY_new;

    deltaX = ( maxX - minX ) / width();
    deltaY = ( maxY - minY ) / height();

    delete painter;
    painter = static_cast<QPainter*>( NULL );

    repaint( TRUE );
  } // if
} // KPlotWindow::mouseReleaseEvent


void
KPlotWindow::keyReleaseEvent( QKeyEvent* e )
{
  if ( ( e->key() == Key_Escape ) && addLabelMode ) {
    addLabelMode = FALSE;
    setCursor( crossCursor );
    e->accept();
  } // if
} // KPlotWindow::keyReleaseEvent

